/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.download.DownloadSource;
import com.mohistmc.network.download.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.MD5Util;
import com.mohistmc.util.i18n.Message;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultLibraries {
    public static HashMap<String, String> fail = new HashMap();

    public static void run() throws Exception {
        System.out.println(Message.getString("libraries.checking.start"));
        System.out.println(Message.getFormatString("libraries.downloadsource", new Object[]{DownloadSource.get()}));
        String url = DownloadSource.get().getUrl();
        LinkedHashMap<File, String> libs = DefaultLibraries.getDefaultLibs();
        AtomicLong currentSize = new AtomicLong();
        LinkedHashSet<File> defaultLibs = new LinkedHashSet<File>();
        for (File lib : DefaultLibraries.getDefaultLibs().keySet()) {
            if (lib.exists() && MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(lib.getName())) continue;
            if (lib.getName().contains("launchwrapper")) {
                File customLaunchwrapper = new File(JarTool.getJarDir() + "/libraries/customize_libraries/launchwrapper-fccb-1.12.jar");
                if (MohistConfigUtil.bMohist("forge_can_call_bukkit")) {
                    if (lib.exists()) {
                        lib.delete();
                    }
                    if (customLaunchwrapper.exists() && MD5Util.md5CheckSum(customLaunchwrapper, "8f121345f96b77620fcfa69a4330947a")) continue;
                    defaultLibs.add(customLaunchwrapper);
                    continue;
                }
                if (customLaunchwrapper.exists()) {
                    customLaunchwrapper.delete();
                }
            }
            if (lib.exists() && MD5Util.md5CheckSum(lib, libs.get(lib))) {
                currentSize.addAndGet(lib.length());
                continue;
            }
            defaultLibs.add(lib);
        }
        for (File lib : defaultLibs) {
            lib.getParentFile().mkdirs();
            String u = url + "libraries/" + lib.getAbsolutePath().replaceAll("\\\\", "/").split("/libraries/")[1];
            System.out.println(Message.getString("libraries.global.percentage") + Math.round((double)(currentSize.get() * 100L) / 7.0E7) + "%");
            try {
                UpdateUtils.downloadFile(u, lib);
                currentSize.addAndGet(lib.length());
                fail.remove(u.replace(url, ""));
            }
            catch (Exception e) {
                System.out.println(Message.getFormatString("file.download.nook", new Object[]{u}));
                lib.delete();
                fail.put(u.replace(url, ""), lib.getAbsolutePath());
            }
        }
        if (!fail.isEmpty()) {
            DefaultLibraries.run();
        } else {
            System.out.println(Message.getString("libraries.checking.end"));
        }
    }

    public static LinkedHashMap<File, String> getDefaultLibs() throws Exception {
        String str;
        LinkedHashMap<File, String> temp = new LinkedHashMap<File, String>();
        BufferedReader b = new BufferedReader(new InputStreamReader(DefaultLibraries.class.getClassLoader().getResourceAsStream("mohist_libraries.txt")));
        while ((str = b.readLine()) != null) {
            String[] s = str.split("\\|");
            temp.put(new File(JarTool.getJarDir() + "/" + s[0]), s[1]);
        }
        b.close();
        return temp;
    }

    public static void loadDefaultLibs() throws Exception {
        for (File lib : DefaultLibraries.getDefaultLibs().keySet()) {
            if (!lib.exists() || MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(lib.getName())) continue;
            JarLoader.loadjar(lib.getAbsolutePath());
        }
    }
}

