/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.libraries;

import com.mohistmc.configuration.MohistConfigUtil;
import com.mohistmc.network.UpdateUtils;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.JarTool;
import com.mohistmc.util.MD5Util;
import com.mohistmc.util.i18n.i18n;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultLibraries {
    public static HashMap<String, String> fail = new HashMap();
    private static String mirror = "";

    public static void loadDefaultLibs() throws Exception {
        System.out.println(i18n.get("libraries.checking.start"));
        String url = mirror.isEmpty() ? "https://maven.mohistmc.com/" : mirror;
        LinkedHashMap<File, String> libs = DefaultLibraries.getDefaultLibs();
        AtomicLong currentSize = new AtomicLong();
        LinkedHashSet<File> defaultLibs = new LinkedHashSet<File>();
        for (File file : DefaultLibraries.getDefaultLibs().keySet()) {
            if (file.exists() && MohistConfigUtil.getString(MohistConfigUtil.mohistyml, "libraries_black_list:", "xxxxx").contains(file.getName())) continue;
            if (file.exists() && MD5Util.getMD5(file).equals(libs.get(file))) {
                currentSize.addAndGet(file.length());
                continue;
            }
            defaultLibs.add(file);
        }
        for (File file : defaultLibs) {
            file.getParentFile().mkdirs();
            String u = url + "libraries/" + file.getAbsolutePath().replaceAll("\\\\", "/").split("/libraries/")[1];
            System.out.println(i18n.get("libraries.global.percentage") + Math.round((double)(currentSize.get() * 100L) / 6.2557711E7) + "%");
            try {
                UpdateUtils.downloadFile(u, file);
                if (file.getName().endsWith(".jar") && !file.getName().contains("asm-tree-6.1.1.jar")) {
                    new JarLoader();
                    JarLoader.loadJar(file.toURI().toURL());
                }
                currentSize.addAndGet(file.length());
                fail.remove(u.replace(url, ""));
            }
            catch (Exception e) {
                System.out.println(i18n.get("file.download.nook", u));
                file.delete();
                fail.put(u.replace(url, ""), file.getAbsolutePath());
            }
        }
        if (!fail.isEmpty()) {
            if (!mirror.equals("")) {
                System.out.println("Looks like there is no maven available at the moment, or you don't have any network connection.\nPlease try again later or come into our Discord server (discord.gg/mohist) to get help.");
                System.out.println(i18n.get("libraries.check.missing"));
                for (String string : fail.keySet()) {
                    System.out.println("Link : " + string + "\nPath : " + fail.get(string) + "\n");
                }
                System.exit(0);
            }
            System.out.println(i18n.get("libraries.check.retry", 0));
            System.out.println("Something went wrong during download, trying to download with the mirror...");
            mirror = "https://mohistmc.github.io/maven/";
            DefaultLibraries.loadDefaultLibs();
        } else {
            System.out.println(i18n.get("libraries.check.end"));
        }
    }

    public static LinkedHashMap<File, String> getDefaultLibs() throws Exception {
        String str;
        LinkedHashMap<File, String> temp = new LinkedHashMap<File, String>();
        BufferedReader b2 = new BufferedReader(new InputStreamReader(DefaultLibraries.class.getClassLoader().getResourceAsStream("mohist_libraries.txt")));
        while ((str = b2.readLine()) != null) {
            String[] s = str.split("\\|");
            temp.put(new File(JarTool.getJarDir() + "/" + s[0]), s[1]);
        }
        b2.close();
        return temp;
    }
}

