/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLContainer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.common.network.internal.EntitySpawnHandler;
import cpw.mods.fml.common.network.internal.FMLMessage;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.network.internal.FMLRuntimeCodec;
import cpw.mods.fml.common.network.internal.HandshakeCompletionHandler;
import cpw.mods.fml.common.network.internal.NetworkModHolder;
import cpw.mods.fml.common.network.internal.OpenGuiHandler;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.core.util.Integers;
import org.bukkit.craftbukkit.v1_7_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftInventoryView;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.InventoryHolder;

public class FMLNetworkHandler {
    public static final int READ_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.readTimeout", "30"), (int)30);
    public static final int LOGIN_TIMEOUT = Integers.parseInt((String)System.getProperty("fml.loginTimeout", "600"), (int)600);
    private static EnumMap<Side, FMLEmbeddedChannel> channelPair;

    public static void fmlServerHandshake(oi scm, ej manager, mw player) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(manager, scm);
        dispatcher.serverToClientHandshake(player);
    }

    public static void fmlClientHandshake(ej field_147393_d) {
        NetworkDispatcher dispatcher = NetworkDispatcher.allocAndSet(field_147393_d);
        dispatcher.clientToServerHandshake();
    }

    public static void openGui(yz entityPlayer, Object mod, int modGuiId, ahb world, int x, int y, int z2) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        if (entityPlayer instanceof mw) {
            mw entityPlayerMP = (mw)entityPlayer;
            zs remoteGuiContainer = NetworkRegistry.INSTANCE.getRemoteGuiContainer(mc, entityPlayerMP, modGuiId, world, x, y, z2);
            if (remoteGuiContainer != null) {
                if (entityPlayer != null && remoteGuiContainer.getBukkitView() == null) {
                    aor te2 = entityPlayer.o.o(x, y, z2);
                    if (te2 != null && te2 instanceof rb) {
                        rb teInv = (rb)te2;
                        CraftInventory inventory = new CraftInventory(teInv);
                        remoteGuiContainer.bukkitView = new CraftInventoryView(entityPlayer.getBukkitEntity(), inventory, remoteGuiContainer);
                    } else {
                        remoteGuiContainer.bukkitView = new CraftInventoryView(entityPlayer.getBukkitEntity(), MinecraftServer.I().server.createInventory((InventoryHolder)entityPlayer.getBukkitEntity(), InventoryType.CHEST), remoteGuiContainer);
                    }
                    remoteGuiContainer = CraftEventFactory.callInventoryOpenEvent((mw)entityPlayer, remoteGuiContainer, false);
                    if (remoteGuiContainer == null) {
                        return;
                    }
                }
                entityPlayerMP.bV();
                entityPlayerMP.m();
                int windowId = entityPlayerMP.bY;
                FMLMessage.OpenGui openGui = new FMLMessage.OpenGui(windowId, mc.getModId(), modGuiId, x, y, z2);
                EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
                embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entityPlayerMP);
                embeddedChannel.writeOutbound(new Object[]{openGui});
                entityPlayerMP.bo = remoteGuiContainer;
                entityPlayerMP.bo.d = windowId;
                entityPlayerMP.bo.a((aac)entityPlayerMP);
            }
        } else if (FMLCommonHandler.instance().getSide().equals((Object)Side.CLIENT)) {
            Object guiContainer = NetworkRegistry.INSTANCE.getLocalGuiContainer(mc, entityPlayer, modGuiId, world, x, y, z2);
            FMLCommonHandler.instance().showGuiScreen(guiContainer);
        } else {
            FMLLog.fine("Invalid attempt to open a local GUI on a dedicated server. This is likely a bug. GUIID: %s,%d", mc.getModId(), modGuiId);
        }
    }

    public static void makeEntitySpawnAdjustment(sa entity, mw player, int serverX, int serverY, int serverZ) {
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        embeddedChannel.writeOutbound(new Object[]{new FMLMessage.EntityAdjustMessage(entity, serverX, serverY, serverZ)});
    }

    public static ft getEntitySpawningPacket(sa entity) {
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(entity.getClass(), false);
        if (er == null) {
            return null;
        }
        if (er.usesVanillaSpawning()) {
            return null;
        }
        return channelPair.get((Object)Side.SERVER).generatePacketFrom(new FMLMessage.EntitySpawnMessage(er, entity, er.getContainer()));
    }

    public static String checkModList(FMLHandshakeMessage.ModList modListPacket, Side side) {
        Map<String, String> modList = modListPacket.modList();
        return FMLNetworkHandler.checkModList(modList, side);
    }

    public static String checkModList(Map<String, String> listData, Side side) {
        ArrayList rejects = Lists.newArrayList();
        ArrayList hackpacks = Lists.newArrayList();
        for (Map.Entry<ModContainer, NetworkModHolder> networkMod : NetworkRegistry.INSTANCE.registry().entrySet()) {
            boolean result = networkMod.getValue().check(listData, side);
            if (!result) {
                rejects.add(networkMod.getKey());
            }
            String name = networkMod.getKey().getName().toLowerCase() + networkMod.getKey().getModId().toLowerCase();
            if (!rejects.isEmpty() || !name.contains("cjb") && !name.contains("kradxns") && !name.contains("chestfinder") && !name.contains("cheating") && !name.contains("xray") && !name.contains("radarbro") && !name.contains("zyin")) continue;
            hackpacks.add(networkMod.getKey());
        }
        if (rejects.isEmpty()) {
            if (!hackpacks.isEmpty()) {
                FMLLog.info("[Thermos] Rejecting hacker %s: %s", new Object[]{side, hackpacks});
                return String.format("Hack rejections %s", hackpacks);
            }
            return null;
        }
        FMLLog.info("Rejecting connection %s: %s", new Object[]{side, rejects});
        return String.format("Mod rejections %s", rejects);
    }

    @SideOnly(value=Side.CLIENT)
    private static void addClientHandlers() {
        ChannelPipeline pipeline = channelPair.get((Object)Side.CLIENT).pipeline();
        String targetName = channelPair.get((Object)Side.CLIENT).findChannelHandlerNameForType(FMLRuntimeCodec.class);
        pipeline.addAfter(targetName, "GuiHandler", (ChannelHandler)new OpenGuiHandler());
        pipeline.addAfter(targetName, "EntitySpawnHandler", (ChannelHandler)new EntitySpawnHandler());
    }

    public static void registerChannel(FMLContainer container, Side side) {
        channelPair = NetworkRegistry.INSTANCE.newChannel(container, "FML", new ChannelHandler[]{new FMLRuntimeCodec(), new HandshakeCompletionHandler()});
        EmbeddedChannel embeddedChannel = channelPair.get((Object)Side.SERVER);
        embeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.NOWHERE);
        if (side == Side.CLIENT) {
            FMLNetworkHandler.addClientHandlers();
        }
    }

    public static List<FMLProxyPacket> forwardHandshake(FMLMessage.CompleteHandshake push, NetworkDispatcher target, Side side) {
        channelPair.get((Object)side).attr(NetworkDispatcher.FML_DISPATCHER).set((Object)target);
        channelPair.get((Object)side).writeOutbound(new Object[]{push});
        ArrayList<FMLProxyPacket> list = new ArrayList<FMLProxyPacket>();
        for (Object o : channelPair.get((Object)side).outboundMessages()) {
            list.add((FMLProxyPacket)((Object)o));
        }
        channelPair.get((Object)side).outboundMessages().clear();
        return list;
    }

    public static void enhanceStatusQuery(JsonObject jsonobject) {
        JsonObject fmlData = new JsonObject();
        fmlData.addProperty("type", "FML");
        JsonArray modList = new JsonArray();
        for (ModContainer mc : Loader.instance().getActiveModList()) {
            JsonObject modData = new JsonObject();
            modData.addProperty("modid", mc.getModId());
            modData.addProperty("version", mc.getVersion());
            modList.add((JsonElement)modData);
        }
        fmlData.add("modList", (JsonElement)modList);
        jsonobject.add("modinfo", (JsonElement)fmlData);
    }
}

