/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.internal;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLNetworkException;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.util.Integers;

public class FMLProxyPacket
extends ft {
    final String channel;
    private Side target;
    private final ByteBuf payload;
    private fb netHandler;
    private NetworkDispatcher dispatcher;
    private static Multiset<String> badPackets = ConcurrentHashMultiset.create();
    private static int packetCountWarning = Integers.parseInt((String)System.getProperty("fml.badPacketCounter", "100"), (int)100);

    private FMLProxyPacket(byte[] payload, String channel) {
        this(Unpooled.wrappedBuffer((byte[])payload), channel);
    }

    public FMLProxyPacket(gr original) {
        this(original.d(), original.c());
        this.target = Side.CLIENT;
    }

    public FMLProxyPacket(iz original) {
        this(original.e(), original.c());
        this.target = Side.SERVER;
    }

    public FMLProxyPacket(ByteBuf payload, String channel) {
        this.channel = channel;
        this.payload = payload;
    }

    public void a(et packetbuffer) throws IOException {
    }

    public void b(et packetbuffer) throws IOException {
    }

    public void a(fb inethandler) {
        this.netHandler = inethandler;
        FMLEmbeddedChannel internalChannel = NetworkRegistry.INSTANCE.getChannel(this.channel, this.target);
        if (internalChannel != null) {
            internalChannel.attr(NetworkRegistry.NET_HANDLER).set((Object)this.netHandler);
            try {
                if (internalChannel.writeInbound(new Object[]{this})) {
                    badPackets.add((Object)this.channel);
                    if (badPackets.size() % packetCountWarning == 0) {
                        FMLLog.severe("Detected ongoing potential memory leak. %d packets have leaked. Top offenders", badPackets.size());
                        int i = 0;
                        for (Multiset.Entry s : Multisets.copyHighestCountFirst(badPackets).entrySet()) {
                            if (i++ > 10) break;
                            FMLLog.severe("\t %s : %d", s.getElement(), s.getCount());
                        }
                    }
                }
                internalChannel.inboundMessages().clear();
            }
            catch (FMLNetworkException ne) {
                FMLLog.log(Level.ERROR, ne, "There was a network exception handling a packet on channel %s", this.channel);
                this.dispatcher.rejectHandshake(ne.getMessage());
            }
            catch (Throwable t) {
                FMLLog.log(Level.ERROR, t, "There was a critical exception handling a packet on channel %s", this.channel);
                this.dispatcher.rejectHandshake("A fatal error has occured, this connection is terminated");
            }
        }
    }

    public String channel() {
        return this.channel;
    }

    public ByteBuf payload() {
        return this.payload;
    }

    public fb handler() {
        return this.netHandler;
    }

    public ft toC17Packet() {
        return new iz(this.channel, this.payload.array());
    }

    public ft toS3FPacket() {
        return new gr(this.channel, this.payload.array());
    }

    public void setTarget(Side target) {
        this.target = target;
    }

    public void setDispatcher(NetworkDispatcher networkDispatcher) {
        this.dispatcher = networkDispatcher;
    }

    public ej getOrigin() {
        return this.dispatcher != null ? this.dispatcher.manager : null;
    }

    public NetworkDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public Side getTarget() {
        return this.target;
    }
}

