/*
 * Decompiled with CFR 0.152.
 */
package guava10.com.google.common.collect;

import guava10.com.google.common.annotations.GwtCompatible;
import guava10.com.google.common.base.Objects;
import guava10.com.google.common.base.Optional;
import guava10.com.google.common.base.Preconditions;
import guava10.com.google.common.collect.BoundType;
import guava10.com.google.common.collect.Ordering;
import guava10.com.google.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true)
final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final Optional<T> lowerEndpoint;
    private final BoundType lowerBoundType;
    private final Optional<T> upperEndpoint;
    private final BoundType upperBoundType;
    private transient GeneralRange<T> reverse;

    static <T extends Comparable> GeneralRange<T> from(Range<T> range) {
        Optional lowerEndpoint = range.hasLowerBound() ? Optional.of(range.lowerEndpoint()) : Optional.absent();
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.OPEN;
        Optional upperEndpoint = range.hasUpperBound() ? Optional.of(range.upperEndpoint()) : Optional.absent();
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.OPEN;
        return new GeneralRange(Ordering.natural(), lowerEndpoint, lowerBoundType, upperEndpoint, upperBoundType);
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator) {
        return new GeneralRange<T>(comparator, Optional.absent(), BoundType.OPEN, Optional.absent(), BoundType.OPEN);
    }

    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator, T endpoint, BoundType boundType) {
        return new GeneralRange<T>(comparator, Optional.of(endpoint), boundType, Optional.absent(), BoundType.OPEN);
    }

    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator, T endpoint, BoundType boundType) {
        return new GeneralRange<T>(comparator, Optional.absent(), BoundType.OPEN, Optional.of(endpoint), boundType);
    }

    static <T> GeneralRange<T> range(Comparator<? super T> comparator, T lower, BoundType lowerType, T upper, BoundType upperType) {
        return new GeneralRange<T>(comparator, Optional.of(lower), lowerType, Optional.of(upper), upperType);
    }

    private GeneralRange(Comparator<? super T> comparator, Optional<T> lowerEndpoint, BoundType lowerBoundType, Optional<T> upperEndpoint, BoundType upperBoundType) {
        this.comparator = Preconditions.checkNotNull(comparator);
        this.lowerEndpoint = Preconditions.checkNotNull(lowerEndpoint);
        this.lowerBoundType = Preconditions.checkNotNull(lowerBoundType);
        this.upperEndpoint = Preconditions.checkNotNull(upperEndpoint);
        this.upperBoundType = Preconditions.checkNotNull(upperBoundType);
        if (lowerEndpoint.isPresent() && upperEndpoint.isPresent()) {
            int cmp = comparator.compare(lowerEndpoint.get(), upperEndpoint.get());
            Preconditions.checkArgument(cmp <= 0, "lowerEndpoint (%s) > upperEndpoint (%s)", lowerEndpoint, upperEndpoint);
            if (cmp == 0) {
                Preconditions.checkArgument(lowerBoundType != BoundType.OPEN | upperBoundType != BoundType.OPEN);
            }
        }
    }

    Comparator<? super T> comparator() {
        return this.comparator;
    }

    boolean hasLowerBound() {
        return this.lowerEndpoint.isPresent();
    }

    boolean hasUpperBound() {
        return this.upperEndpoint.isPresent();
    }

    boolean isEmpty() {
        return this.hasUpperBound() && this.tooLow(this.upperEndpoint.get()) || this.hasLowerBound() && this.tooHigh(this.lowerEndpoint.get());
    }

    boolean tooLow(T t) {
        if (!this.hasLowerBound()) {
            return false;
        }
        T lbound = this.lowerEndpoint.get();
        int cmp = this.comparator.compare(t, lbound);
        return cmp < 0 | cmp == 0 & this.lowerBoundType == BoundType.OPEN;
    }

    boolean tooHigh(T t) {
        if (!this.hasUpperBound()) {
            return false;
        }
        T ubound = this.upperEndpoint.get();
        int cmp = this.comparator.compare(t, ubound);
        return cmp > 0 | cmp == 0 & this.upperBoundType == BoundType.OPEN;
    }

    boolean contains(T t) {
        Preconditions.checkNotNull(t);
        return !this.tooLow(t) && !this.tooHigh(t);
    }

    GeneralRange<T> intersect(GeneralRange<T> other) {
        int cmp;
        int cmp2;
        Preconditions.checkNotNull(other);
        Preconditions.checkArgument(((Object)this.comparator).equals(other.comparator));
        Optional<T> lowEnd = this.lowerEndpoint;
        BoundType lowType = this.lowerBoundType;
        if (!this.hasLowerBound()) {
            lowEnd = other.lowerEndpoint;
            lowType = other.lowerBoundType;
        } else if (other.hasLowerBound() && ((cmp2 = this.comparator.compare(this.lowerEndpoint.get(), other.lowerEndpoint.get())) < 0 || cmp2 == 0 && other.lowerBoundType == BoundType.OPEN)) {
            lowEnd = other.lowerEndpoint;
            lowType = other.lowerBoundType;
        }
        Optional<T> upEnd = this.upperEndpoint;
        BoundType upType = this.upperBoundType;
        if (!this.hasUpperBound()) {
            upEnd = other.upperEndpoint;
            upType = other.upperBoundType;
        } else if (other.hasUpperBound() && ((cmp = this.comparator.compare(this.upperEndpoint.get(), other.upperEndpoint.get())) > 0 || cmp == 0 && other.upperBoundType == BoundType.OPEN)) {
            upEnd = other.upperEndpoint;
            upType = other.upperBoundType;
        }
        if (lowEnd.isPresent() && upEnd.isPresent() && ((cmp = this.comparator.compare(lowEnd.get(), upEnd.get())) > 0 || cmp == 0 && lowType == BoundType.OPEN && upType == BoundType.OPEN)) {
            lowEnd = upEnd;
            lowType = BoundType.OPEN;
            upType = BoundType.CLOSED;
        }
        return new GeneralRange<T>(this.comparator, lowEnd, lowType, upEnd, upType);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof GeneralRange) {
            GeneralRange r = (GeneralRange)obj;
            return ((Object)this.comparator).equals(r.comparator) && this.lowerEndpoint.equals(r.lowerEndpoint) && this.lowerBoundType.equals((Object)r.lowerBoundType) && this.upperEndpoint.equals(r.upperEndpoint) && this.upperBoundType.equals((Object)r.upperBoundType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.comparator, this.lowerEndpoint, this.lowerBoundType, this.upperEndpoint, this.upperBoundType});
    }

    public GeneralRange<T> reverse() {
        GeneralRange<Object> result = this.reverse;
        if (result == null) {
            result = new GeneralRange(Ordering.from(this.comparator).reverse(), this.upperEndpoint, this.upperBoundType, this.lowerEndpoint, this.lowerBoundType);
            result.reverse = this;
            this.reverse = result;
            return this.reverse;
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.comparator).append(":");
        switch (this.lowerBoundType) {
            case CLOSED: {
                builder.append('[');
                break;
            }
            case OPEN: {
                builder.append('(');
            }
        }
        if (this.hasLowerBound()) {
            builder.append(this.lowerEndpoint.get());
        } else {
            builder.append("-\u221e");
        }
        builder.append(',');
        if (this.hasUpperBound()) {
            builder.append(this.upperEndpoint.get());
        } else {
            builder.append("\u221e");
        }
        switch (this.upperBoundType) {
            case CLOSED: {
                builder.append(']');
                break;
            }
            case OPEN: {
                builder.append(')');
            }
        }
        return builder.toString();
    }
}

