/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.Random;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.event.block.BlockFromToEvent;

public class BlockFluidClassic
extends BlockFluidBase {
    protected boolean[] isOptimalFlowDirection = new boolean[4];
    protected int[] flowCost = new int[4];
    protected FluidStack stack;

    public BlockFluidClassic(Fluid fluid, awt material) {
        super(fluid, material);
        this.stack = new FluidStack(fluid, 1000);
    }

    public BlockFluidClassic setFluidStack(FluidStack stack) {
        this.stack = stack;
        return this;
    }

    public BlockFluidClassic setFluidStackAmount(int amount) {
        this.stack.amount = amount;
        return this;
    }

    @Override
    public int getQuantaValue(ahl world, int x, int y2, int z2) {
        if (world.a(x, y2, z2) == ajn.a) {
            return 0;
        }
        if (world.a(x, y2, z2) != this) {
            return -1;
        }
        int quantaRemaining = this.quantaPerBlock - world.e(x, y2, z2);
        return quantaRemaining;
    }

    @Override
    public boolean a(int meta, boolean fullHit) {
        return fullHit && meta == 0;
    }

    @Override
    public int getMaxRenderHeightMeta() {
        return 0;
    }

    @Override
    public int getLightValue(ahl world, int x, int y2, int z2) {
        if (this.maxScaledLight == 0) {
            return super.getLightValue(world, x, y2, z2);
        }
        int data = this.quantaPerBlock - world.e(x, y2, z2) - 1;
        return (int)((float)data / this.quantaPerBlockFloat * (float)this.maxScaledLight);
    }

    public void a(ahb world, int x, int y2, int z2, Random rand) {
        Block source;
        int quantaRemaining = this.quantaPerBlock - world.e(x, y2, z2);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y22 = y2 - this.densityDir;
            if (world.a(x, y22, z2) == this || world.a(x - 1, y22, z2) == this || world.a(x + 1, y22, z2) == this || world.a(x, y22, z2 - 1) == this || world.a(x, y22, z2 + 1) == this) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((ahl)world, x - 1, y2, z2, maxQuanta);
                maxQuanta = this.getLargerQuanta((ahl)world, x + 1, y2, z2, maxQuanta);
                maxQuanta = this.getLargerQuanta((ahl)world, x, y2, z2 - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((ahl)world, x, y2, z2 + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.b(x, y2, z2, ajn.a);
                } else {
                    world.a(x, y2, z2, this.quantaPerBlock - expQuanta, 3);
                    world.a(x, y2, z2, (aji)this, this.tickRate);
                    world.d(x, y2, z2, (aji)this);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.a(x, y2, z2, 0, 2);
        }
        CraftServer server = world.getServer();
        CraftWorld bworld = world.getWorld();
        Block block = source = bworld == null ? null : bworld.getBlockAt(x, y2, z2);
        if (this.canDisplace((ahl)world, x, y2 + this.densityDir, z2)) {
            BlockFace face = this.densityDir < 0 ? BlockFace.DOWN : BlockFace.UP;
            BlockFromToEvent event = new BlockFromToEvent(source, face);
            if (server != null) {
                server.getPluginManager().callEvent(event);
            }
            if (event.isCancelled()) {
                return;
            }
            this.flowIntoBlock(world, x, y2 + this.densityDir, z2, 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((ahl)world, x, y2, z2) || !this.isFlowingVertically((ahl)world, x, y2, z2)) {
            if (world.a(x, y2 - this.densityDir, z2) == this) {
                flowMeta = 1;
            }
            boolean[] flowTo = this.getOptimalFlowDirections(world, x, y2, z2);
            BlockFace[] faces = new BlockFace[]{BlockFace.WEST, BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH};
            block6: for (int i = 0; i < 4; ++i) {
                if (!flowTo[i]) continue;
                BlockFromToEvent event = new BlockFromToEvent(source, faces[i]);
                if (server != null) {
                    server.getPluginManager().callEvent(event);
                }
                if (event.isCancelled()) continue;
                switch (i) {
                    case 0: {
                        this.flowIntoBlock(world, x - 1, y2, z2, flowMeta);
                        continue block6;
                    }
                    case 1: {
                        this.flowIntoBlock(world, x + 1, y2, z2, flowMeta);
                        continue block6;
                    }
                    case 2: {
                        this.flowIntoBlock(world, x, y2, z2 - 1, flowMeta);
                        continue block6;
                    }
                    case 3: {
                        this.flowIntoBlock(world, x, y2, z2 + 1, flowMeta);
                    }
                }
            }
        }
    }

    public boolean isFlowingVertically(ahl world, int x, int y2, int z2) {
        return world.a(x, y2 + this.densityDir, z2) == this || world.a(x, y2, z2) == this && this.canFlowInto(world, x, y2 + this.densityDir, z2);
    }

    public boolean isSourceBlock(ahl world, int x, int y2, int z2) {
        return world.a(x, y2, z2) == this && world.e(x, y2, z2) == 0;
    }

    protected boolean[] getOptimalFlowDirections(ahb world, int x, int y2, int z2) {
        int side;
        for (int side2 = 0; side2 < 4; ++side2) {
            this.flowCost[side2] = 1000;
            int x2 = x;
            int y22 = y2;
            int z22 = z2;
            switch (side2) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z22;
                    break;
                }
                case 3: {
                    ++z22;
                }
            }
            if (!this.canFlowInto((ahl)world, x2, y22, z22) || this.isSourceBlock((ahl)world, x2, y22, z22)) continue;
            this.flowCost[side2] = this.canFlowInto((ahl)world, x2, y22 + this.densityDir, z22) ? 0 : this.calculateFlowCost(world, x2, y22, z22, 1, side2);
        }
        int min = this.flowCost[0];
        for (side = 1; side < 4; ++side) {
            if (this.flowCost[side] >= min) continue;
            min = this.flowCost[side];
        }
        for (side = 0; side < 4; ++side) {
            this.isOptimalFlowDirection[side] = this.flowCost[side] == min;
        }
        return this.isOptimalFlowDirection;
    }

    protected int calculateFlowCost(ahb world, int x, int y2, int z2, int recurseDepth, int side) {
        int cost = 1000;
        for (int adjSide = 0; adjSide < 4; ++adjSide) {
            int min;
            if (adjSide == 0 && side == 1 || adjSide == 1 && side == 0 || adjSide == 2 && side == 3 || adjSide == 3 && side == 2) continue;
            int x2 = x;
            int y22 = y2;
            int z22 = z2;
            switch (adjSide) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    ++x2;
                    break;
                }
                case 2: {
                    --z22;
                    break;
                }
                case 3: {
                    ++z22;
                }
            }
            if (!this.canFlowInto((ahl)world, x2, y22, z22) || this.isSourceBlock((ahl)world, x2, y22, z22)) continue;
            if (this.canFlowInto((ahl)world, x2, y22 + this.densityDir, z22)) {
                return recurseDepth;
            }
            if (recurseDepth >= 4 || (min = this.calculateFlowCost(world, x2, y22, z22, recurseDepth + 1, adjSide)) >= cost) continue;
            cost = min;
        }
        return cost;
    }

    protected void flowIntoBlock(ahb world, int x, int y2, int z2, int meta) {
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, x, y2, z2)) {
            world.d(x, y2, z2, (aji)this, meta, 3);
        }
    }

    protected boolean canFlowInto(ahl world, int x, int y2, int z2) {
        if (world.a(x, y2, z2).isAir(world, x, y2, z2)) {
            return true;
        }
        aji block = world.a(x, y2, z2);
        if (block == this) {
            return true;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        awt material = block.o();
        if (material.c() || material == awt.h || material == awt.i || material == awt.E) {
            return false;
        }
        int density = BlockFluidClassic.getDensity(world, x, y2, z2);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected int getLargerQuanta(ahl world, int x, int y2, int z2, int compare) {
        int quantaRemaining = this.getQuantaValue(world, x, y2, z2);
        if (quantaRemaining <= 0) {
            return compare;
        }
        return quantaRemaining >= compare ? quantaRemaining : compare;
    }

    @Override
    public FluidStack drain(ahb world, int x, int y2, int z2, boolean doDrain) {
        if (!this.isSourceBlock((ahl)world, x, y2, z2)) {
            return null;
        }
        if (doDrain) {
            world.b(x, y2, z2, ajn.a);
        }
        return this.stack.copy();
    }

    @Override
    public boolean canDrain(ahb world, int x, int y2, int z2) {
        return this.isSourceBlock((ahl)world, x, y2, z2);
    }
}

