/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.enchantments;

import org.apache.commons.lang.StringUtils;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.inventory.ItemStack;

public class CraftEnchantment
extends Enchantment {
    private final aft target;
    private String generatedName;

    public CraftEnchantment(aft target) {
        super(target.B);
        this.target = target;
    }

    @Override
    public int getMaxLevel() {
        return this.target.b();
    }

    @Override
    public int getStartLevel() {
        return this.target.d();
    }

    @Override
    public EnchantmentTarget getItemTarget() {
        switch (this.target.C) {
            case a: {
                return EnchantmentTarget.ALL;
            }
            case b: {
                return EnchantmentTarget.ARMOR;
            }
            case c: {
                return EnchantmentTarget.ARMOR_FEET;
            }
            case f: {
                return EnchantmentTarget.ARMOR_HEAD;
            }
            case d: {
                return EnchantmentTarget.ARMOR_LEGS;
            }
            case e: {
                return EnchantmentTarget.ARMOR_TORSO;
            }
            case h: {
                return EnchantmentTarget.TOOL;
            }
            case g: {
                return EnchantmentTarget.WEAPON;
            }
            case k: {
                return EnchantmentTarget.BOW;
            }
            case i: {
                return EnchantmentTarget.FISHING_ROD;
            }
        }
        return null;
    }

    @Override
    public boolean canEnchantItem(ItemStack item) {
        return this.target.a(CraftItemStack.asNMSCopy(item));
    }

    @Override
    public String getName() {
        switch (this.target.B) {
            case 0: {
                return "PROTECTION_ENVIRONMENTAL";
            }
            case 1: {
                return "PROTECTION_FIRE";
            }
            case 2: {
                return "PROTECTION_FALL";
            }
            case 3: {
                return "PROTECTION_EXPLOSIONS";
            }
            case 4: {
                return "PROTECTION_PROJECTILE";
            }
            case 5: {
                return "OXYGEN";
            }
            case 6: {
                return "WATER_WORKER";
            }
            case 7: {
                return "THORNS";
            }
            case 16: {
                return "DAMAGE_ALL";
            }
            case 17: {
                return "DAMAGE_UNDEAD";
            }
            case 18: {
                return "DAMAGE_ARTHROPODS";
            }
            case 19: {
                return "KNOCKBACK";
            }
            case 20: {
                return "FIRE_ASPECT";
            }
            case 21: {
                return "LOOT_BONUS_MOBS";
            }
            case 32: {
                return "DIG_SPEED";
            }
            case 33: {
                return "SILK_TOUCH";
            }
            case 34: {
                return "DURABILITY";
            }
            case 35: {
                return "LOOT_BONUS_BLOCKS";
            }
            case 48: {
                return "ARROW_DAMAGE";
            }
            case 49: {
                return "ARROW_KNOCKBACK";
            }
            case 50: {
                return "ARROW_FIRE";
            }
            case 51: {
                return "ARROW_INFINITE";
            }
            case 61: {
                return "LUCK";
            }
            case 62: {
                return "LURE";
            }
        }
        if (this.generatedName != null) {
            return this.generatedName;
        }
        this.generatedName = CraftEnchantment.generateName(this.target);
        return this.generatedName;
    }

    private static String generateName(aft target) {
        Class<?> clz = target.getClass();
        if (clz.getName().startsWith("net.minecraft")) {
            String candidate = "UNKNOWN_ENCHANT_" + target.B;
            return candidate;
        }
        String candidate = clz.getSimpleName();
        if (StringUtils.containsIgnoreCase((String)candidate, (String)"Enchantment")) {
            candidate = candidate.replaceFirst("[E|e]nchantment", "");
            candidate = candidate.replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase();
            candidate = CraftEnchantment.addSuffix(candidate.toUpperCase());
            return candidate;
        }
        candidate = clz.getName();
        candidate = candidate.replaceAll("([a-z])([A-Z])", "$1_$2");
        candidate = candidate.replaceAll("\\.", "_");
        candidate = CraftEnchantment.addSuffix(candidate.toUpperCase());
        return candidate;
    }

    private static String addSuffix(String enchName) {
        if (Enchantment.getByName(enchName) == null) {
            return enchName;
        }
        int suffix = 2;
        while (Enchantment.getByName(enchName + "_" + suffix) != null) {
            ++suffix;
        }
        return enchName + "_" + suffix;
    }

    public static aft getRaw(Enchantment enchantment) {
        if (enchantment instanceof EnchantmentWrapper) {
            enchantment = ((EnchantmentWrapper)enchantment).getEnchantment();
        }
        if (enchantment instanceof CraftEnchantment) {
            return ((CraftEnchantment)enchantment).target;
        }
        return null;
    }

    @Override
    public boolean conflictsWith(Enchantment other) {
        if (other instanceof EnchantmentWrapper) {
            other = ((EnchantmentWrapper)other).getEnchantment();
        }
        if (!(other instanceof CraftEnchantment)) {
            return false;
        }
        CraftEnchantment ench = (CraftEnchantment)other;
        return !this.target.a(ench.target);
    }
}

