/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.Json;
import java.util.Collections;
import java.util.List;

public class StringJson
extends Json {
    String val;

    StringJson() {
    }

    StringJson(Json e) {
        super(e);
    }

    StringJson(String val, Json e) {
        super(e);
        this.val = val;
    }

    @Override
    public Json dup() {
        return new StringJson(this.val, null);
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public Object getValue() {
        return this.val;
    }

    @Override
    public String asString() {
        return this.val;
    }

    @Override
    public int asInteger() {
        return Integer.parseInt(this.val);
    }

    @Override
    public float asFloat() {
        return Float.parseFloat(this.val);
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.val);
    }

    @Override
    public long asLong() {
        return Long.parseLong(this.val);
    }

    @Override
    public short asShort() {
        return Short.parseShort(this.val);
    }

    @Override
    public byte asByte() {
        return Byte.parseByte(this.val);
    }

    @Override
    public char asChar() {
        return this.val.charAt(0);
    }

    @Override
    public List<Object> asList() {
        return Collections.singletonList(this.val);
    }

    public String toString() {
        return "\"" + escaper.escapeJsonString(this.val) + "\"";
    }

    @Override
    public String toString(int maxCharacters) {
        if (this.val.length() <= maxCharacters) {
            return this.toString();
        }
        return "\"" + escaper.escapeJsonString(this.val.subSequence(0, maxCharacters)) + "...\"";
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public boolean equals(Object x) {
        return x instanceof StringJson && ((StringJson)x).val.equals(this.val);
    }
}

