/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class NongLi {
    static String[] chineseNumber = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    static SimpleDateFormat chineseDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
    static long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42448L, 83315L, 21200L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46496L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19415L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L};
    private static int year;
    private final int month;
    private final int day;
    private boolean leap;

    public NongLi(Calendar cal) {
        int iMonth;
        int iYear;
        int leapMonth = 0;
        Date baseDate = null;
        try {
            baseDate = chineseDateFormat.parse("1900\u5e741\u670831\u65e5");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int offset = (int)((cal.getTime().getTime() - baseDate.getTime()) / 86400000L);
        int daysOfYear = 0;
        for (iYear = 1900; iYear < 2050 && offset > 0; offset -= daysOfYear, ++iYear) {
            daysOfYear = NongLi.yearDays(iYear);
        }
        if (offset < 0) {
            offset += daysOfYear;
            --iYear;
        }
        year = iYear;
        leapMonth = NongLi.leapMonth(iYear);
        this.leap = false;
        int daysOfMonth = 0;
        for (iMonth = 1; iMonth < 13 && offset > 0; ++iMonth) {
            if (leapMonth > 0 && iMonth == leapMonth + 1 && !this.leap) {
                --iMonth;
                this.leap = true;
                daysOfMonth = NongLi.leapDays(year);
            } else {
                daysOfMonth = NongLi.monthDays(year, iMonth);
            }
            offset -= daysOfMonth;
            if (this.leap && iMonth == leapMonth + 1) {
                this.leap = false;
            }
            if (this.leap) continue;
        }
        if (offset == 0 && leapMonth > 0 && iMonth == leapMonth + 1) {
            if (this.leap) {
                this.leap = false;
            } else {
                this.leap = true;
                --iMonth;
            }
        }
        if (offset < 0) {
            offset += daysOfMonth;
            --iMonth;
        }
        this.month = iMonth;
        this.day = offset + 1;
    }

    private static int yearDays(int y) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((lunarInfo[y - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + NongLi.leapDays(y);
    }

    private static int leapDays(int y) {
        if (NongLi.leapMonth(y) == 0) {
            return 0;
        }
        if ((lunarInfo[y - 1900] & 0x10000L) != 0L) {
            return 30;
        }
        return 29;
    }

    private static int leapMonth(int y) {
        return (int)(lunarInfo[y - 1900] & 0xFL);
    }

    private static int monthDays(int y, int m) {
        if ((lunarInfo[y - 1900] & (long)(65536 >> m)) == 0L) {
            return 29;
        }
        return 30;
    }

    public static String animalsYear() {
        String[] Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
        return Animals[(year - 4) % 12];
    }

    private static String cyclicalm(int num) {
        String[] Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
        String[] Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
        return Gan[num % 10] + Zhi[num % 12];
    }

    public static String getChinaDayString(int day) {
        int n;
        String[] chineseTen = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
        int n2 = n = day % 10 == 0 ? 9 : day % 10 - 1;
        if (day > 30) {
            return "";
        }
        if (day == 10) {
            return "\u521d\u5341";
        }
        return chineseTen[day / 10] + chineseNumber[n];
    }

    public static void main(String[] args) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getDefault());
        NongLi lunar = new NongLi(cal);
        System.out.println("\u519c\u5386" + String.valueOf(lunar) + " " + NongLi.animalsYear());
    }

    public String cyclical() {
        int num = year - 1900 + 36;
        return NongLi.cyclicalm(num);
    }

    public String toString() {
        return year + "\u5e74" + (this.leap ? "\u95f0" : "") + chineseNumber[this.month - 1] + "\u6708" + NongLi.getChinaDayString(this.day);
    }
}

