/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.action;

import com.mohistmc.MohistMCStart;
import com.mohistmc.tools.SHA256;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.JarLoader;
import com.mohistmc.util.JarTool;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;

public abstract class Action {
    private static final PrintStream origin = System.out;
    public String mohistVer;
    public String forgeVer;
    public String mcpVer;
    public String mcVer;
    public String libPath = new File(JarTool.getJarDir(), "libraries").getAbsolutePath() + "/";
    public String forgeStart;
    public File universalJar;
    public File serverJar;
    public File lzma;
    public File installInfo;
    public String otherStart;
    public File extra;
    public File slim;
    public File srg;
    public String mcpStart;
    public File mcpZip;
    public File mcpTxt;
    public File minecraft_server;

    protected Action() {
        this.mohistVer = DataParser.versionMap.get("mohist");
        this.forgeVer = DataParser.versionMap.get("forge");
        this.mcpVer = DataParser.versionMap.get("mcp");
        this.mcVer = DataParser.versionMap.get("minecraft");
        this.forgeStart = this.libPath + "net/minecraftforge/forge/" + this.mcVer + "-" + this.forgeVer + "/forge-" + this.mcVer + "-" + this.forgeVer;
        this.universalJar = new File(this.forgeStart + "-universal.jar");
        this.serverJar = new File(this.forgeStart + "-server.jar");
        this.lzma = new File(this.libPath + "com/mohistmc/installation/data/server.lzma");
        this.installInfo = new File(this.libPath + "com/mohistmc/installation/installInfo");
        this.otherStart = this.libPath + "net/minecraft/server/" + this.mcVer + "-" + this.mcpVer + "/server-" + this.mcVer + "-" + this.mcpVer;
        this.extra = new File(this.otherStart + "-extra.jar");
        this.slim = new File(this.otherStart + "-slim.jar");
        this.srg = new File(this.otherStart + "-srg.jar");
        this.mcpStart = this.libPath + "de/oceanlabs/mcp/mcp_config/" + this.mcVer + "-" + this.mcpVer + "/mcp_config-" + this.mcVer + "-" + this.mcpVer;
        this.mcpZip = new File(this.mcpStart + ".zip");
        this.mcpTxt = new File(this.mcpStart + "-mappings.txt");
        this.minecraft_server = new File(this.libPath + "net/minecraft/server/" + this.mcVer + "/server-" + this.mcVer + ".jar");
    }

    protected void run(String mainClass, String[] args, List<URL> classPath) throws Exception {
        try {
            Class.forName(mainClass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + e.getMessage());
            return;
        }
        URLClassLoader loader = URLClassLoader.newInstance(classPath.toArray(new URL[0]));
        Class.forName(mainClass, true, loader).getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
        loader.clearAssertionStatus();
        loader.close();
    }

    protected List<URL> stringToUrl(List<String> strs) throws Exception {
        ArrayList<URL> temp = new ArrayList<URL>();
        for (String t : strs) {
            File file = new File(t);
            JarLoader.loadJar(file.toPath());
            temp.add(file.toURI().toURL());
        }
        return temp;
    }

    protected void mute() throws Exception {
        File out = new File(this.libPath + "com/mohistmc/installation", "installationLogs.txt");
        if (!out.exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        System.setOut(new PrintStream(new BufferedOutputStream(new FileOutputStream(out))));
    }

    protected void unmute() {
        System.setOut(origin);
    }

    protected void copyFileFromJar(File file, String pathInJar) {
        InputStream is = MohistMCStart.class.getClassLoader().getResourceAsStream(pathInJar);
        if (!file.exists() || !SHA256.is(file, SHA256.as(is)) || file.length() <= 1L) {
            file.getParentFile().mkdirs();
            if (is != null) {
                try {
                    file.createNewFile();
                    Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {}
            } else {
                System.out.println("[Mohist] The file " + file.getName() + " doesn't exists in the Mohist jar !");
                System.exit(0);
            }
        }
    }

    protected boolean isCorrupted(File f) {
        try {
            JarFile j = new JarFile(f);
            j.close();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public boolean checkDependencies() throws IOException {
        if (this.installInfo.exists()) {
            String jarmd = SHA256.as(JarTool.getFile());
            List<String> lines = Files.readAllLines(this.installInfo.toPath());
            return lines.size() < 2 || !jarmd.equals(lines.get(1));
        }
        return true;
    }
}

