/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools;

import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class SHA256 {
    public static String as(InputStream is) {
        try {
            return String.format("%032x", new BigInteger(1, new DigestInputStream(is, MessageDigest.getInstance("SHA-256")).getMessageDigest().digest())).toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String as(File file) {
        try {
            return String.format("%032x", new BigInteger(1, MessageDigest.getInstance("SHA-256").digest(Files.readAllBytes(file.toPath())))).toLowerCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String as(String filePath) {
        return SHA256.as(new File(filePath));
    }

    public static boolean is(InputStream is, String toBeCheckSum) {
        return SHA256.as(is).equals(toBeCheckSum);
    }

    public static boolean is(File file, String toBeCheckSum) {
        return SHA256.as(file).equals(toBeCheckSum);
    }

    public static boolean is(String path, String toBeCheckSum) {
        return SHA256.as(path).equals(toBeCheckSum);
    }
}

