/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void zipFolder(Path sourceFolderPath, Path zipPath) throws Exception {
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(zipPath, new OpenOption[0]));
             Stream<Path> paths = Files.walk(sourceFolderPath, new FileVisitOption[0]);){
            paths.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(sourceFolderPath.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public static void getFileContent(Object fileInPath) throws IOException {
        String line;
        BufferedReader br = null;
        if (fileInPath == null) {
            return;
        }
        if (fileInPath instanceof String) {
            br = new BufferedReader(new FileReader((String)fileInPath));
        } else if (fileInPath instanceof InputStream) {
            br = new BufferedReader(new InputStreamReader((InputStream)fileInPath));
        }
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        br.close();
    }
}

