/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc;

import com.mohistmc.action.v_1_20_1;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.feature.AutoDeleteMods;
import com.mohistmc.feature.CustomLibraries;
import com.mohistmc.feature.DefaultLibraries;
import com.mohistmc.feature.ExceptionHandler;
import com.mohistmc.i18n.i18n;
import com.mohistmc.tools.JarTool;
import com.mohistmc.tools.Logo;
import com.mohistmc.tools.MojangEulaUtil;
import com.mohistmc.tools.ZipUtil;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.MohistModuleManager;
import cpw.mods.bootstraplauncher.BootstrapLauncher;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Stream;

public class MohistMCStart {
    public static final List<String> mainArgs = new ArrayList<String>();
    public static String MCVERSION;
    public static i18n i18n;
    public static JarTool jarTool;

    public static String getVersion() {
        return MohistMCStart.class.getPackage().getImplementationVersion() != null ? MohistMCStart.class.getPackage().getImplementationVersion() : "unknown";
    }

    public static void main(String[] args) throws Exception {
        mainArgs.addAll(List.of(args));
        jarTool = new JarTool(MohistMCStart.class);
        DataParser.parseVersions();
        DataParser.parseLaunchArgs();
        MohistConfigUtil.init();
        MohistConfigUtil.i18n();
        if (i18n.isCN()) {
            Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        }
        if (MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.aBoolean("mohist.show_logo", true)) {
            System.out.printf("%n%s%n%s - %s, Java(%s) %s PID: %s%n", Logo.asMohist(), i18n.as("mohist.launch.welcomemessage"), MohistMCStart.getVersion(), System.getProperty("java.class.version"), System.getProperty("java.version"), ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
            if (i18n.isCN()) {
                System.out.println("+------------------------------------------------------+");
                System.out.println("|                                                      |");
                System.out.println("| \u5b98\u65b9\u4ea4\u6d41QQ\u7fa4: 570870451                              |");
                System.out.println("| \u5b98\u7f51(\u4e2d\u56fd): https://www.mohistmc.cn/                 |");
                System.out.println("| \u7231\u53d1\u7535: https://afdian.com/a/MohistMC                |");
                System.out.println("|                                                      |");
                System.out.println("+------------------------------------------------------+");
            }
        }
        if (System.getProperty("log4j.configurationFile") == null) {
            System.setProperty("log4j.configurationFile", "log4j2_mohist.xml");
        }
        ZipUtil.getFileContent(MohistMCStart.class.getClassLoader().getResourceAsStream("META-INF/libraries"));
        if (MohistConfigUtil.INSTALLATIONFINISHED() && MohistConfigUtil.CHECK_LIBRARIES()) {
            DefaultLibraries.run();
        }
        CustomLibraries.loadCustomLibs();
        if (MohistConfigUtil.INSTALLATIONFINISHED()) {
            v_1_20_1.run();
        }
        AutoDeleteMods.jar();
        ArrayList<String> forgeArgs = new ArrayList<String>();
        for (String arg : DataParser.launchArgs.stream().filter(s -> s.startsWith("--launchTarget") || s.startsWith("--fml.forgeVersion") || s.startsWith("--fml.mcVersion") || s.startsWith("--fml.forgeGroup") || s.startsWith("--fml.mcpVersion")).toList()) {
            forgeArgs.add(arg.split(" ")[0]);
            forgeArgs.add(arg.split(" ")[1]);
        }
        new MohistModuleManager(DataParser.launchArgs);
        if (!MojangEulaUtil.hasAcceptedEULA()) {
            System.out.println(i18n.as("eula"));
            while (!"true".equals(new Scanner(System.in).nextLine().trim())) {
                System.out.println(i18n.as("eula_notrue"));
            }
            MojangEulaUtil.writeInfos(i18n.as("eula.text", "https://account.mojang.com/documents/minecraft_eula") + "\n" + new SimpleDateFormat("yyyy-MM-dd").format(new Date()) + "\neula=true");
        }
        String[] args_ = (String[])Stream.concat(forgeArgs.stream(), mainArgs.stream()).toArray(String[]::new);
        BootstrapLauncher.main((String[])args_);
    }
}

