/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.jar.JarFile;

public class JarTool {
    private final Class<?> classz;

    public JarTool(Class<?> classz) {
        this.classz = classz;
    }

    public static boolean isCorrupted(File f) {
        try {
            JarFile j = new JarFile(f);
            j.close();
            return false;
        }
        catch (IOException e) {
            return true;
        }
    }

    public String getJarPath() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public File getJarDir() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getParentFile();
    }

    public String getJarName() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public File getFile() {
        String path = this.classz.getProtectionDomain().getCodeSource().getLocation().getFile();
        path = URLDecoder.decode(path, String.valueOf(StandardCharsets.UTF_8));
        return new File(path);
    }

    public static void restartServer(List<String> cmd, boolean shutdown) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.inheritIO().start().waitFor();
        Thread.sleep(2000L);
        if (shutdown) {
            System.exit(0);
        }
    }
}

