/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.util;

import com.mohistmc.MohistMCStart;
import com.mohistmc.config.MohistConfigUtil;
import com.mohistmc.mjson.Json;
import com.mohistmc.tools.ConnectionUtil;
import com.mohistmc.tools.NumberUtil;
import com.mohistmc.util.DataParser;
import com.mohistmc.util.I18n;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class UpdateUtils {
    public Json json;
    public String jar_version = DataParser.versionMap.get("mohist");
    public int build_number;
    public String time;
    public String url;

    public void init() {
        System.out.println(I18n.as("update.check"));
        System.out.println(I18n.as("update.stopcheck"));
        if (this.jar_version.equals("dev")) {
            return;
        }
        if (this.canUpdate()) {
            System.out.println(I18n.as("update.latest", this.jar_version, this.build_number));
        } else {
            System.out.println(I18n.as("update.detect", this.build_number, this.jar_version, this.time));
            if (MohistConfigUtil.CHECK_UPDATE_AUTO_DOWNLOAD()) {
                File mohistjar = MohistMCStart.jarTool.getFile();
                System.out.println(I18n.as("download.file", mohistjar.getName(), NumberUtil.getSize(ConnectionUtil.getConn(this.url).getContentLength())));
                if (ConnectionUtil.downloadFile(this.url, mohistjar)) {
                    System.out.println(I18n.as("download.file.ok", mohistjar.getName()));
                    try {
                        UpdateUtils.restartServer(Arrays.asList("java", "-jar", MohistMCStart.jarTool.getJarName()), true);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private boolean canUpdate() {
        try {
            this.build_number = Integer.parseInt(this.jar_version);
            this.json = Json.read(new URL("https://ci.codemc.io/job/MohistMC/job/Mohist-%s/lastSuccessfulBuild/api/json".formatted(MohistMCStart.MCVERSION)));
            this.build_number = this.json.asInteger("number");
            this.time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.json.asLong("timestamp")));
            this.url = "https://ci.codemc.io/job/MohistMC/job/Mohist-%s/lastSuccessfulBuild/artifact/projects/mohist/build/libs/mohist-%s-%s-server.jar".formatted(MohistMCStart.MCVERSION, MohistMCStart.MCVERSION, this.build_number);
            return Integer.parseInt(this.jar_version) >= this.build_number;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void restartServer(List<String> cmd, boolean shutdown) throws Exception {
        System.out.println(I18n.as("jarfile.restart"));
        if (cmd.stream().anyMatch(s -> s.contains("-Xms"))) {
            System.out.println(I18n.as("xmswarn"));
        }
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(MohistMCStart.jarTool.getJarDir());
        pb.inheritIO().start().waitFor();
        Thread.sleep(2000L);
        if (shutdown) {
            System.exit(0);
        }
    }
}

