/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import com.mohistmc.mjson.ToJson;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class BeanSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object serialize(Object bean) throws NullPointerException {
        if (bean == null) {
            return null;
        }
        if (bean instanceof String || bean instanceof Boolean || bean instanceof Number) {
            return bean;
        }
        if (bean instanceof Collection) {
            return BeanSerializer.serialize(((Collection)bean).toArray());
        }
        if (bean.getClass().isArray()) {
            int length = Array.getLength(bean);
            ArrayList<Object> array = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                array.add(BeanSerializer.serialize(Array.get(bean, i)));
            }
            return array;
        }
        if (bean instanceof Map) {
            Map map = (Map)bean;
            map.replaceAll((k, v) -> BeanSerializer.serialize(map.get(k)));
            return map;
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<String> keys = new ArrayList<String>();
        for (Field field : bean.getClass().getDeclaredFields()) {
            boolean isRequired = false;
            Object value = null;
            try {
                field.setAccessible(true);
                ToJson seriable = field.getAnnotation(ToJson.class);
                if (seriable == null) continue;
                String key = field.getName();
                value = BeanSerializer.serialize(field.get(bean));
                isRequired = seriable.isRequired();
                if (!seriable.name().isEmpty()) {
                    key = seriable.name();
                }
                int order = seriable.order();
                int positon = indexs.size();
                if (order < Integer.MAX_VALUE) {
                    for (int i = 0; i < indexs.size(); ++i) {
                        if (order >= (Integer)indexs.get(i)) continue;
                        positon = i;
                    }
                }
                indexs.add(positon, order);
                values.add(positon, value);
                keys.add(positon, key);
            }
            catch (Exception exception) {
                if (!isRequired || null != value) continue;
                throw new NullPointerException("Field " + field.getName() + " can't be null");
            }
            finally {
                if (isRequired && null == value) {
                    throw new NullPointerException("Field " + field.getName() + " can't be null");
                }
            }
        }
        LinkedHashMap map = new LinkedHashMap(indexs.size());
        for (int i = 0; i < indexs.size(); ++i) {
            map.put((String)keys.get(i), values.get(i));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserialize(Class<T> klass, Map map) throws Exception {
        T bean = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field[] fieldArray = klass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                Field field = fieldArray[n2];
                Collection<T> value = null;
                boolean isRequired = false;
                try {
                    field.setAccessible(true);
                    ToJson seriable = field.getAnnotation(ToJson.class);
                    if (seriable == null) break block17;
                    String name = seriable.name();
                    if (name.isEmpty()) {
                        name = field.getName();
                    }
                    isRequired = seriable.isRequired();
                    value = (Collection<T>)map.get(name);
                    Class<?> clazz = field.getType();
                    if (Collection.class.isAssignableFrom(clazz)) {
                        Class genericType = Object.class;
                        try {
                            genericType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (value instanceof Collection) {
                            value = BeanSerializer.deserialize(clazz, genericType, value);
                        } else {
                            if (!value.getClass().isArray()) {
                                T t = null;
                                return t;
                            }
                            value = BeanSerializer.deserialize(clazz, genericType, (Object[])value);
                        }
                    } else {
                        value = (Collection<T>)BeanSerializer.deserialize(clazz, value);
                    }
                    field.set(bean, value);
                }
                catch (Exception exception) {
                    if (isRequired && value == null) {
                        throw new NullPointerException();
                    }
                }
                finally {
                    if (isRequired && value == null) {
                        throw new NullPointerException();
                    }
                }
            }
            ++n2;
        }
        return bean;
    }

    public static <T, A> Collection<T> deserialize(Class<? extends Collection> klass, Class<T> genericType, A[] array) throws Exception {
        Collection collection = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (A a : array) {
            collection.add(BeanSerializer.deserialize(genericType, a));
        }
        return collection;
    }

    public static <T> Collection<T> deserialize(Class<? extends Collection> klass, Class<T> genericType, Collection array) throws Exception {
        return BeanSerializer.deserialize(klass, genericType, array.toArray());
    }

    public static <T> T[] deserialize(Class<T> componentType, Collection array) {
        return BeanSerializer.deserialize(componentType, array.toArray());
    }

    public static <T, A> T[] deserialize(Class<T> componentType, A[] array) {
        Object[] collection = (Object[])Array.newInstance(componentType, array.length);
        for (int i = 0; i < array.length; ++i) {
            collection[i] = BeanSerializer.deserialize(componentType, array[i]);
        }
        return collection;
    }

    public static <T> T deserialize(Class<T> klass, Object object) {
        try {
            if (object instanceof Number || object instanceof String || object instanceof Boolean) {
                return (T)object;
            }
            if (object instanceof Map) {
                if (Map.class.isAssignableFrom(klass)) {
                    return klass.cast(object);
                }
                return BeanSerializer.deserialize(klass, (Map)object);
            }
            if (Collection.class.isAssignableFrom(klass)) {
                if (object instanceof Collection) {
                    return (T)BeanSerializer.deserialize(klass, Object.class, (Collection)object);
                }
                if (object.getClass().isArray()) {
                    return (T)BeanSerializer.deserialize(klass, Object.class, (Object[])object);
                }
                return null;
            }
            if (klass.isArray()) {
                if (object instanceof Collection) {
                    return (T)BeanSerializer.deserialize(klass.getComponentType(), (Collection)object);
                }
                if (object.getClass().isArray()) {
                    return (T)BeanSerializer.deserialize(klass.getComponentType(), (Object[])object);
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

