/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.tools;

import com.mohistmc.tools.Tools;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

public class ConnectionUtil {
    private static final boolean debug = true;

    public static boolean isValid(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean canAccess(String urlStr) {
        try {
            URLConnection urlConnection = ConnectionUtil.getConn(urlStr);
            if (urlConnection == null) {
                return false;
            }
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.connect();
            int responseCode = connection.getResponseCode();
            return responseCode >= 200 && responseCode < 300;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Integer getCode(String urlStr) {
        try {
            URLConnection urlConnection = ConnectionUtil.getConn(urlStr);
            if (urlConnection == null) {
                return null;
            }
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            connection.connect();
            return connection.getResponseCode();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URLConnection getConn(String URL2) {
        try {
            URLConnection connection = URI.create(URL2).toURL().openConnection();
            connection.setRequestProperty("User-Agent", "MohistMC-Tools/" + Tools.version());
            return connection;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static long measureLatency(String urlString) {
        try {
            long start = System.nanoTime();
            URLConnection urlConnection = ConnectionUtil.getConn(urlString);
            if (urlConnection == null) {
                return Long.MAX_VALUE;
            }
            HttpURLConnection connection = (HttpURLConnection)urlConnection;
            int responseCode = connection.getResponseCode();
            long end = System.nanoTime();
            return Duration.ofNanos(end - start).toMillis();
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
    }

    public static String fastURL(List<String> urls) {
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        List futures = urls.stream().map(url -> CompletableFuture.supplyAsync(() -> ConnectionUtil.measureLatency(url), executor).thenApply(latency -> new LatencyResult((String)url, (long)latency))).collect(Collectors.toList());
        Optional<LatencyResult> minLatencyResult = futures.stream().map(CompletableFuture::join).min(Comparator.comparing(LatencyResult::getLatency));
        executor.shutdown();
        if (minLatencyResult.isPresent()) {
            LatencyResult result = minLatencyResult.get();
            return result.url;
        }
        return null;
    }

    public static boolean downloadFile(String URL2, File f) {
        try {
            URLConnection conn = ConnectionUtil.getConn(URL2);
            if (conn == null) {
                return false;
            }
            ReadableByteChannel rbc = Channels.newChannel(conn.getInputStream());
            FileChannel fc = FileChannel.open(f.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            fc.transferFrom(rbc, 0L, Long.MAX_VALUE);
            fc.close();
            rbc.close();
            return true;
        }
        catch (IOException | NullPointerException ignored) {
            return false;
        }
    }

    static class LatencyResult {
        final String url;
        final long latency;

        LatencyResult(String url, long latency) {
            this.url = url;
            this.latency = latency;
        }

        public String getUrl() {
            return this.url;
        }

        public long getLatency() {
            return this.latency;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LatencyResult)) {
                return false;
            }
            LatencyResult other = (LatencyResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLatency() != other.getLatency()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LatencyResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $latency = this.getLatency();
            result = result * 59 + (int)($latency >>> 32 ^ $latency);
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        public String toString() {
            return "ConnectionUtil.LatencyResult(url=" + this.getUrl() + ", latency=" + this.getLatency() + ")";
        }
    }
}

