/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.feature;

import java.net.BindException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Map<Class<? extends Throwable>, Consumer<Throwable>> exceptionHandlers = new HashMap<Class<? extends Throwable>, Consumer<Throwable>>();

    public ExceptionHandler() {
        this.exceptionHandlers.put(OutOfMemoryError.class, this::handleOutOfMemoryError);
        this.exceptionHandlers.put(ClassNotFoundException.class, this::handleClassNotFoundException);
        this.exceptionHandlers.put(NoClassDefFoundError.class, this::handleNoClassDefFoundError);
        this.exceptionHandlers.put(BindException.class, this::handleBindException);
        this.exceptionHandlers.put(NullPointerException.class, this::handleNullPointerException);
        this.exceptionHandlers.put(SQLException.class, this::handleSQLException);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Consumer<Throwable> handler = this.exceptionHandlers.get(e.getClass());
        if (handler != null) {
            handler.accept(e);
        } else {
            System.out.println("\u672a\u5904\u7406\u7684\u5f02\u5e38: " + e.getClass().getName() + " - " + e.getMessage());
            this.printJarOrClassInfo(e);
            e.printStackTrace();
        }
    }

    private void printJarOrClassInfo(Throwable e) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = e.getStackTrace()) {
            if (this.isInternalJavaClass(element.getClassName())) continue;
            System.out.println("\u95ee\u9898\u53d1\u751f\u5728: " + element.getClassName() + " (\u6587\u4ef6: " + element.getFileName() + " \u884c: " + element.getLineNumber() + ")");
            try {
                Class<?> clazz = Class.forName(element.getClassName());
                String location = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
                System.out.println("\u76f8\u5173\u7684Jar/\u7c7b\u8def\u5f84: " + location);
            }
            catch (ClassNotFoundException ex) {
                System.out.println("\u65e0\u6cd5\u627e\u5230\u76f8\u5173\u7684\u7c7b: " + element.getClassName());
            }
            break;
        }
    }

    private boolean isInternalJavaClass(String className) {
        return className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.w3c.dom.") || className.startsWith("org.xml.") || className.startsWith("com.sun.") || className.startsWith("sun.") || className.startsWith("javafx.");
    }

    private void handleOutOfMemoryError(Throwable e) {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory() / 0x100000L;
        long totalMemory = runtime.totalMemory() / 0x100000L;
        long freeMemory = runtime.freeMemory() / 0x100000L;
        long usedMemory = totalMemory - freeMemory;
        System.out.println("\u4f60\u7ed9Minecraft\u670d\u52a1\u5668\u5206\u914d\u7684\u5185\u5b58\u4e0d\u591f\u3002");
        System.out.println("\u5f53\u524d\u5df2\u7528\u5185\u5b58: " + usedMemory + " MB");
        System.out.println("\u5f53\u524d\u603b\u5206\u914d\u5185\u5b58: " + totalMemory + " MB");
        System.out.println("JVM\u6700\u5927\u53ef\u7528\u5185\u5b58: " + maxMemory + " MB");
        this.printJarOrClassInfo(e);
    }

    private void handleClassNotFoundException(Throwable e) {
        System.out.println("\u672a\u627e\u5230\u5bf9\u5e94\u7684Java\u7c7b: " + e.getMessage());
        System.out.println("\u8bf7\u5c1d\u8bd5\u67e5\u627e\u5bf9\u5e94\u7684\u7c7b\u662f\u5426\u662f\u5ba2\u6237\u7aef\u72ec\u6709\uff0c\u4f8b\u5982\u5305\u542b\"GUI\"\u7b49\u5b57\u6837\uff0c\u5982\u679c\u786e\u4fe1\u662fMod\u6216\u63d2\u4ef6\u95ee\u9898\uff0c\u8bf7\u8054\u7cfb\u5bf9\u5e94\u5f00\u53d1\u8005\u3002");
        this.printJarOrClassInfo(e);
    }

    private void handleNoClassDefFoundError(Throwable e) {
        System.out.println("\u8fd0\u884c\u65f6\u672a\u627e\u5230\u7c7b: " + e.getMessage());
        System.out.println("\u8fd9\u53ef\u80fd\u662f\u56e0\u4e3a\u7c7b\u5728\u7f16\u8bd1\u65f6\u5b58\u5728\uff0c\u4f46\u5728\u8fd0\u884c\u65f6\u7531\u4e8e\u4f9d\u8d56\u95ee\u9898\u3001\u7c7b\u8def\u5f84\u4e0d\u5b8c\u6574\u7b49\u539f\u56e0\u5bfc\u81f4\u627e\u4e0d\u5230\u3002");
        this.printJarOrClassInfo(e);
    }

    private void handleBindException(Throwable e) {
        BindException be = (BindException)e;
        System.out.println("\u65e0\u6cd5\u5c06\u670d\u52a1\u5668\u7ed1\u5b9a\u5230: " + e.getMessage());
        System.out.println("\u8fd9\u53ef\u80fd\u662f\u56e0\u4e3a\u7aef\u53e3\u5df2\u7ecf\u88ab\u5360\u7528\uff0c\u6216\u8005\u6ca1\u6709\u8db3\u591f\u7684\u6743\u9650\u7ed1\u5b9a\u5230\u6307\u5b9a\u7684\u7aef\u53e3\u3002");
        System.out.println("\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u5176\u4ed6\u7a0b\u5e8f\u5360\u7528\u4e86\u76f8\u540c\u7684\u7aef\u53e3\uff0c\u6216\u8005\u5c1d\u8bd5\u4f7f\u7528\u4e0d\u540c\u7684\u7aef\u53e3\u542f\u52a8\u670d\u52a1\u5668\u3002");
    }

    private void handleNullPointerException(Throwable e) {
        System.out.println("\u4f60\u9047\u5230\u4e86\u4e00\u4e2aNullPointerException\uff0c\u8fd9\u4e2a\u9519\u8bef\u53ef\u80fd\u4e0e\u672a\u6b63\u786e\u521d\u59cb\u5316\u7684\u5bf9\u8c61\u6709\u5173\u3002");
        System.out.println("\u4ee5\u4e0b\u662f\u5b8c\u6574\u7684\u5f02\u5e38\u4fe1\u606f:");
        e.printStackTrace();
        this.printJarOrClassInfo(e);
    }

    private void handleSQLException(Throwable e) {
        SQLException sqlException = (SQLException)e;
        System.out.println("\u770b\u8d77\u6765\u4e0e\u6570\u636e\u5e93\u8fde\u63a5\u65f6\u51fa\u73b0\u4e86\u95ee\u9898\u3002");
        System.out.println("SQL\u72b6\u6001\u7801\uff1a" + sqlException.getErrorCode());
        System.out.println("SQL\u8fd4\u56de\uff1a" + sqlException.getMessage());
        sqlException.printStackTrace();
        this.printJarOrClassInfo(e);
    }
}

