/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.mjson;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class JSONSerializer {
    private final char[] buffer;
    private int position;

    private JSONSerializer(String string) {
        this.buffer = string.toCharArray();
        this.position = -1;
    }

    public static String serialize(Object object) throws IllegalArgumentException {
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + ((String)object).replace("\b", "\\b").replace("\t", "\\t").replace("\r", "\\r").replace("\f", "\\f").replace("\n", "\\n") + "\"";
        }
        if (object instanceof Number || object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                sb.append(JSONSerializer.serialize(key)).append(':').append(JSONSerializer.serialize(value)).append(',');
            }
            int last = sb.length() - 1;
            if (sb.charAt(last) == ',') {
                sb.deleteCharAt(last);
            }
            sb.append('}');
            return sb.toString();
        }
        if (object instanceof Collection) {
            return JSONSerializer.serialize(((Collection)object).toArray());
        }
        if (object.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int last = Array.getLength(object) - 1;
            for (int i = 0; i <= last; ++i) {
                Object value = Array.get(object, i);
                sb.append(JSONSerializer.serialize(value)).append(',');
            }
            last = sb.length() - 1;
            if (sb.charAt(last) == ',') {
                sb.deleteCharAt(last);
            }
            sb.append(']');
            return sb.toString();
        }
        throw new IllegalArgumentException(object.toString());
    }

    public static Object deserialize(String json) throws RuntimeException {
        return new JSONSerializer(json).nextValue();
    }

    /*
     * Exception decompiling
     */
    private Object nextValue() throws RuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CASE], 33[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private char nextToken() throws ArrayIndexOutOfBoundsException {
        while (this.buffer[++this.position] <= ' ') {
        }
        return this.buffer[this.position];
    }
}

