/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.fabric;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.mohistmc.banner.BannerServer;
import com.mohistmc.banner.api.ServerAPI;
import com.mohistmc.banner.entity.MohistModsEntity;
import com.mohistmc.dynamicenum.MohistDynamEnum;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1847;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.bukkit.Fluid;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_20_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class FabricInjectBukkit {
    public static final BiMap<class_5321<class_5363>, World.Environment> DIM_MAP = HashBiMap.create((Map)ImmutableMap.builder().put((Object)class_5363.field_25412, (Object)World.Environment.NORMAL).put((Object)class_5363.field_25413, (Object)World.Environment.NETHER).put((Object)class_5363.field_25414, (Object)World.Environment.THE_END).build());
    public static Map<Villager.Profession, class_2960> profession = new HashMap<Villager.Profession, class_2960>();
    public static Map<Attribute, class_2960> attributemap = new HashMap<Attribute, class_2960>();

    public static void init() {
        FabricInjectBukkit.addEnumMaterialInItems();
        FabricInjectBukkit.addEnumMaterialsInBlocks();
        FabricInjectBukkit.addEnumBiome();
        FabricInjectBukkit.addEnumEnchantment();
        FabricInjectBukkit.addEnumEffectAndPotion();
        FabricInjectBukkit.addFluid();
        FabricInjectBukkit.addEnumEntity();
        FabricInjectBukkit.addEnumVillagerProfession();
        FabricInjectBukkit.addEnumParticle();
    }

    public static void addEnumEnvironment() {
        int i = World.Environment.values().length;
        class_2378 registry = ServerAPI.getNMSServer().method_30611().method_30530(class_7924.field_41224);
        for (Map.Entry entry : registry.method_29722()) {
            class_5321 key = (class_5321)entry.getKey();
            World.Environment environment1 = (World.Environment)((Object)DIM_MAP.get((Object)key));
            if (environment1 != null) continue;
            String name = FabricInjectBukkit.normalizeName(key.method_29177().toString());
            int id = i - 1;
            environment1 = (World.Environment)MohistDynamEnum.addEnum(World.Environment.class, (String)name, (Class[])new Class[]{Integer.TYPE}, (Object[])new Object[]{id});
            DIM_MAP.put((Object)key, (Object)environment1);
            BannerServer.LOGGER.debug("Registered fabric DimensionType as environment {}", (Object)environment1);
            ++i;
        }
    }

    public static void addEnumMaterialInItems() {
        class_7922 registry = class_7923.field_41178;
        for (class_1792 item : registry) {
            int id;
            String materialName;
            Material material;
            class_2960 resourceLocation = registry.method_10221((Object)item);
            if (FabricInjectBukkit.isMINECRAFT(resourceLocation) || (material = Material.addMaterial(materialName = FabricInjectBukkit.normalizeName(resourceLocation.toString()), id = class_1792.method_7880((class_1792)item), false, resourceLocation.method_12836())) == null) continue;
            CraftMagicNumbers.ITEM_MATERIAL.put(item, material);
            CraftMagicNumbers.MATERIAL_ITEM.put(material, item);
            BannerServer.LOGGER.debug("Save-ITEM: " + material.name() + " - " + materialName);
        }
    }

    public static void addEnumMaterialsInBlocks() {
        class_7922 registry = class_7923.field_41175;
        for (class_2248 block : registry) {
            int id;
            String materialName;
            Material material;
            class_2960 resourceLocation = registry.method_10221((Object)block);
            if (FabricInjectBukkit.isMINECRAFT(resourceLocation) || (material = Material.addMaterial(materialName = FabricInjectBukkit.normalizeName(resourceLocation.toString()), id = class_1792.method_7880((class_1792)block.method_8389()), true, resourceLocation.method_12836())) == null) continue;
            CraftMagicNumbers.BLOCK_MATERIAL.put(block, material);
            CraftMagicNumbers.MATERIAL_BLOCK.put(material, block);
            BannerServer.LOGGER.debug("Save-BLOCK:" + material.name() + " - " + materialName);
        }
    }

    public static void addEnumEnchantment() {
        for (class_1887 enchantment : class_7923.field_41176) {
            Enchantment.registerEnchantment(new CraftEnchantment(enchantment));
        }
        Enchantment.stopAcceptingRegistrations();
    }

    public static void addEnumEffectAndPotion() {
        for (class_1291 effect : class_7923.field_41174) {
            CraftPotionEffectType pet = new CraftPotionEffectType(effect);
            PotionEffectType.registerPotionEffectType(pet);
        }
        PotionEffectType.stopAcceptingRegistrations();
        class_7922 registry = class_7923.field_41179;
        for (class_1842 potion : class_7923.field_41179) {
            class_2960 resourceLocation = registry.method_10221((Object)potion);
            if (CraftPotionUtil.toBukkit(resourceLocation.toString()).getType() != PotionType.UNCRAFTABLE || potion == class_1847.field_8984) continue;
            String name = FabricInjectBukkit.normalizeName(resourceLocation.toString());
            class_1293 effectInstance = potion.method_8049().isEmpty() ? null : (class_1293)potion.method_8049().get(0);
            PotionType potionType = (PotionType)MohistDynamEnum.addEnum0(PotionType.class, (String)name, (Class[])new Class[]{PotionEffectType.class, Boolean.TYPE, Boolean.TYPE}, (Object[])new Object[]{effectInstance == null ? null : PotionEffectType.getById(class_1291.method_5554((class_1291)effectInstance.method_5579())), false, false});
            if (potionType == null) continue;
            BannerServer.LOGGER.debug("Save-PotionType:" + name + " - " + potionType.name());
        }
    }

    public static void addEnumParticle() {
        class_2378 registry = class_7923.field_41180;
        for (class_2396 particleType : class_7923.field_41180) {
            Particle particle;
            class_2960 resourceLocation = registry.method_10221((Object)particleType);
            String name = FabricInjectBukkit.normalizeName(resourceLocation.toString());
            if (resourceLocation.method_12836().equals("minecraft") || (particle = (Particle)MohistDynamEnum.addEnum0(Particle.class, (String)name, (Class[])new Class[0], (Object[])new Object[0])) == null) continue;
            CraftParticle.putParticles(particle, resourceLocation);
            BannerServer.LOGGER.debug("Save-ParticleType:" + name + " - " + particle.name());
        }
    }

    public static void addEnumBiome() {
        ArrayList<String> map = new ArrayList<String>();
        class_2378 registry = class_7923.field_41156;
        for (Codec biome : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)biome);
            String biomeName = FabricInjectBukkit.normalizeName(resourceLocation.toString());
            if (FabricInjectBukkit.isMINECRAFT(resourceLocation) || map.contains(biomeName)) continue;
            map.add(biomeName);
            Biome biomeCB = (Biome)MohistDynamEnum.addEnum0(Biome.class, (String)biomeName, (Class[])new Class[0], (Object[])new Object[0]);
            BannerServer.LOGGER.debug("Save-BIOME:" + biomeCB.name() + " - " + biomeName);
        }
        map.clear();
    }

    public static void addEnumEntity() {
        class_7922 registry = class_7923.field_41177;
        for (class_1299 entity : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)entity);
            if (FabricInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String entityType = FabricInjectBukkit.normalizeName(resourceLocation.toString());
            int typeId = entityType.hashCode();
            EntityType bukkitType = (EntityType)MohistDynamEnum.addEnum0(EntityType.class, (String)entityType, (Class[])new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, (Object[])new Object[]{entityType.toLowerCase(), MohistModsEntity.class, typeId, false});
            EntityType.NAME_MAP.put(entityType.toLowerCase(), bukkitType);
            EntityType.ID_MAP.put((short)typeId, bukkitType);
            ServerAPI.entityTypeMap.put(entity, entityType);
        }
    }

    public static void addEnumVillagerProfession() {
        class_7922 registry = class_7923.field_41195;
        for (class_3852 villagerProfession : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)villagerProfession);
            if (FabricInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            String name = FabricInjectBukkit.normalizeName(resourceLocation.toString());
            Villager.Profession vp = (Villager.Profession)MohistDynamEnum.addEnum0(Villager.Profession.class, (String)name, (Class[])new Class[0], (Object[])new Object[0]);
            profession.put(vp, resourceLocation);
            BannerServer.LOGGER.debug("Registered fabric VillagerProfession as Profession {}", (Object)vp.name());
        }
    }

    public static void addFluid() {
        class_7922 registry = class_7923.field_41173;
        for (class_3611 fluidType : registry) {
            class_2960 resourceLocation = registry.method_10221((Object)fluidType);
            String name = FabricInjectBukkit.normalizeName(resourceLocation.method_12832());
            if (FabricInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            Fluid fluid = (Fluid)MohistDynamEnum.addEnum0(Fluid.class, (String)name, (Class[])new Class[0], (Object[])new Object[0]);
            CraftMagicNumbers.FLUIDTYPE_FLUID.put((Object)fluidType, (Object)fluid);
            BannerServer.LOGGER.debug("Registered fabric Fluid as Fluid(Bukkit) {}", (Object)fluid.name());
        }
    }

    public static String normalizeName(String name) {
        return name.toUpperCase(Locale.ENGLISH).replaceAll("(:|\\s)", "_").replaceAll("\\W", "");
    }

    public static boolean isMINECRAFT(class_2960 resourceLocation) {
        return resourceLocation.method_12836().equals("minecraft");
    }
}

