/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.mappings;

import java.util.List;
import java.util.Map;
import net.fabricmc.mappingio.MappedElementKind;
import net.fabricmc.mappingio.MappingVisitor;

public class MappingCacheVisitor
implements MappingVisitor {
    private final Map<Integer, String> classes;
    private final Map<Integer, String> methods;
    private final Map<Integer, String> fields;
    private String srcClassName;
    private String srcMethodName;
    private String srcFieldName;

    public MappingCacheVisitor(Map<Integer, String> classes, Map<Integer, String> methods, Map<Integer, String> fields) {
        this.classes = classes;
        this.methods = methods;
        this.fields = fields;
    }

    public void visitNamespaces(String srcNamespace, List<String> dstNamespaces) {
    }

    public boolean visitClass(String srcName) {
        this.srcClassName = srcName;
        return true;
    }

    public boolean visitField(String srcName, String srcDesc) {
        this.srcFieldName = srcName;
        return true;
    }

    public boolean visitMethod(String srcName, String srcDesc) {
        this.srcMethodName = srcName;
        return true;
    }

    public boolean visitMethodArg(int argPosition, int lvIndex, String srcName) {
        return true;
    }

    public boolean visitMethodVar(int lvtRowIndex, int lvIndex, int startOpIdx, String srcName) {
        return true;
    }

    public void visitDstName(MappedElementKind targetKind, int namespace, String name) {
        switch (targetKind) {
            case CLASS: {
                String classIdStr;
                int innerClassSeparatorIndex;
                String srcName = this.srcClassName;
                if (srcName.equals(name)) {
                    return;
                }
                if (!srcName.startsWith("net/minecraft/class_")) {
                    if (name.startsWith("net/minecraft/class_")) {
                        String ogName = name;
                        name = srcName;
                        srcName = ogName;
                    } else {
                        return;
                    }
                }
                if ((innerClassSeparatorIndex = srcName.lastIndexOf(36)) != -1) {
                    classIdStr = srcName.substring(innerClassSeparatorIndex + 1);
                    if (!classIdStr.startsWith("class_")) {
                        return;
                    }
                    classIdStr = classIdStr.substring("class_".length());
                } else {
                    classIdStr = srcName.substring("net/minecraft/class_".length());
                }
                innerClassSeparatorIndex = name.indexOf(36);
                name = innerClassSeparatorIndex != -1 ? name.substring(innerClassSeparatorIndex + 1) : name.replace('/', '.');
                this.classes.put(Integer.parseInt(classIdStr), name);
                break;
            }
            case METHOD: {
                String srcName = this.srcMethodName;
                if (srcName.equals(name)) {
                    return;
                }
                if (!srcName.startsWith("method_")) {
                    if (name.startsWith("method_")) {
                        String ogName = name;
                        name = srcName;
                        srcName = ogName;
                    } else {
                        return;
                    }
                }
                int methodId = Integer.parseInt(srcName.substring("method_".length()));
                this.methods.put(methodId, name);
                break;
            }
            case FIELD: {
                String srcName = this.srcFieldName;
                if (srcName.equals(name)) {
                    return;
                }
                if (!srcName.startsWith("field_")) {
                    if (name.startsWith("field_")) {
                        String ogName = name;
                        name = srcName;
                        srcName = ogName;
                    } else {
                        return;
                    }
                }
                int fieldId = Integer.parseInt(srcName.substring("field_".length()));
                this.fields.put(fieldId, name);
            }
        }
    }

    public void visitComment(MappedElementKind targetKind, String comment) {
    }
}

