/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.util;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class MavenArtifactInfo {
    private final String repoUrl;
    private final String groupId;
    private final String artifactId;
    private final String classifier;

    public MavenArtifactInfo(String repoUrl, String groupId, String artifactId, @Nullable String classifier) {
        this.repoUrl = repoUrl.endsWith("/") ? repoUrl : repoUrl + "/";
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
    }

    public static MavenArtifactInfo parse(String repoUrl, String info) {
        String[] split = StringUtils.split((String)info, (char)':');
        Preconditions.checkState((split.length == 2 || split.length == 3 ? 1 : 0) != 0, (Object)("Artifact info is invalid: " + info));
        String groupId = split[0];
        String artifactId = split[1];
        String classifier = split.length > 2 ? split[2] : null;
        return new MavenArtifactInfo(repoUrl, groupId, artifactId, classifier);
    }

    public URI buildMetaUri() {
        return URI.create(this.repoUrl + this.groupId.replace('.', '/') + "/" + this.artifactId + "/maven-metadata.xml");
    }

    public URI buildUri(String version, String extension) {
        String fileName = this.artifactId + "-" + version + (String)(this.classifier != null ? "-" + this.classifier : "") + "." + extension;
        return URI.create(this.repoUrl + this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + version + "/" + fileName);
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getClassifier() {
        return this.classifier;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MavenArtifactInfo)) {
            return false;
        }
        MavenArtifactInfo that = (MavenArtifactInfo)obj;
        if (!this.repoUrl.equals(that.repoUrl)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(that.artifactId)) {
            return false;
        }
        return Objects.equals(this.classifier, that.classifier);
    }

    public int hashCode() {
        int result = this.repoUrl.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MavenArtifactInfo{repoUrl='" + this.repoUrl + "', groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', classifier='" + this.classifier + "'}";
    }
}

