/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.class_3317;
import net.minecraft.class_3320;
import net.minecraft.class_3330;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.CraftIpBanEntry;

public class CraftIpBanList
implements BanList {
    private final class_3317 list;

    public CraftIpBanList(class_3317 list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        class_3320 entry = (class_3320)this.list.method_14640((Object)target);
        if (entry == null) {
            return null;
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        class_3320 entry = new class_3320(target, new Date(), StringUtils.isBlank((CharSequence)source) ? null : source, expires, StringUtils.isBlank((CharSequence)reason) ? null : reason);
        this.list.method_14633((class_3330)entry);
        try {
            this.list.method_14629();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-ips.json, {0}", ex.getMessage());
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.method_14636()) {
            builder.add((Object)new CraftIpBanEntry(target, (class_3320)this.list.method_14640((Object)target), this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        return this.list.method_14527((SocketAddress)InetSocketAddress.createUnresolved(target, 0));
    }

    @Override
    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null", (Object[])new Object[0]);
        this.list.method_14635((Object)target);
    }
}

