/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.class_1427;
import net.minecraft.class_1606;
import org.bukkit.DyeColor;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEnemy;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftGolem;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Shulker;

public class CraftShulker
extends CraftGolem
implements Shulker,
CraftEnemy {
    public CraftShulker(CraftServer server, class_1606 entity) {
        super(server, (class_1427)entity);
    }

    @Override
    public String toString() {
        return "CraftShulker";
    }

    @Override
    public EntityType getType() {
        return EntityType.SHULKER;
    }

    public class_1606 getHandle() {
        return (class_1606)this.entity;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.getByWoolData((Byte)this.getHandle().method_5841().method_12789(class_1606.field_7343));
    }

    @Override
    public void setColor(DyeColor color) {
        this.getHandle().method_5841().method_12778(class_1606.field_7343, (Object)(color == null ? (byte)16 : (byte)color.getWoolData()));
    }

    @Override
    public float getPeek() {
        return (float)this.getHandle().method_7115() / 100.0f;
    }

    @Override
    public void setPeek(float value) {
        Preconditions.checkArgument((value >= 0.0f && value <= 1.0f ? 1 : 0) != 0, (Object)"value needs to be in between or equal to 0 and 1");
        this.getHandle().method_7122((int)(value * 100.0f));
    }

    @Override
    public BlockFace getAttachedFace() {
        return CraftBlock.notchToBlockFace(this.getHandle().method_7119());
    }

    @Override
    public void setAttachedFace(BlockFace face) {
        Preconditions.checkNotNull((Object)((Object)face), (Object)"face cannot be null");
        Preconditions.checkArgument((boolean)face.isCartesian(), (String)"%s is not a valid block face to attach a shulker to, a cartesian block face is expected", (Object)((Object)face));
        this.getHandle().method_35192(CraftBlock.blockFaceToNotch(face));
    }
}

