/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.scoreboard;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.class_268;
import net.minecraft.class_270;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final class_268 team;

    CraftTeam(CraftScoreboard scoreboard, class_268 team) {
        super(scoreboard);
        this.team = team;
    }

    @Override
    public String getName() throws IllegalStateException {
        this.checkState();
        return this.team.method_1197();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.method_1140());
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException {
        Preconditions.checkArgument((displayName != null ? 1 : 0) != 0, (Object)"Display name cannot be null");
        int lengthStripedDisplayName = ChatColor.stripColor(displayName).length();
        Preconditions.checkArgument((lengthStripedDisplayName <= 128 ? 1 : 0) != 0, (String)"Display name '%s' is longer than the limit of 128 characters (%s)", (Object)displayName, (int)lengthStripedDisplayName);
        this.checkState();
        this.team.method_1137(CraftChatMessage.fromString(displayName)[0]);
    }

    @Override
    public String getPrefix() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.method_1144());
    }

    @Override
    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix cannot be null");
        int lengthStripedPrefix = ChatColor.stripColor(prefix).length();
        Preconditions.checkArgument((lengthStripedPrefix <= 64 ? 1 : 0) != 0, (String)"Prefix '%s' is longer than the limit of 64 characters (%s)", (Object)prefix, (int)lengthStripedPrefix);
        this.checkState();
        this.team.method_1138(CraftChatMessage.fromStringOrNull(prefix));
    }

    @Override
    public String getSuffix() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.fromComponent(this.team.method_1136());
    }

    @Override
    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((suffix != null ? 1 : 0) != 0, (Object)"Suffix cannot be null");
        int lengthStripedSuffix = ChatColor.stripColor(suffix).length();
        Preconditions.checkArgument((lengthStripedSuffix <= 64 ? 1 : 0) != 0, (String)"Suffix '%s' is longer than the limit of 64 characters (%s)", (Object)suffix, (int)lengthStripedSuffix);
        this.team.method_1139(CraftChatMessage.fromStringOrNull(suffix));
    }

    @Override
    public ChatColor getColor() throws IllegalStateException {
        this.checkState();
        return CraftChatMessage.getColor(this.team.method_1202());
    }

    @Override
    public void setColor(ChatColor color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"Color cannot be null");
        this.checkState();
        this.team.method_1141(CraftChatMessage.getColor(color));
    }

    @Override
    public boolean allowFriendlyFire() throws IllegalStateException {
        this.checkState();
        return this.team.method_1205();
    }

    @Override
    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        this.checkState();
        this.team.method_1135(enabled);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        this.checkState();
        return this.team.method_1199();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        this.checkState();
        this.team.method_1143(enabled);
    }

    @Override
    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        this.checkState();
        return CraftTeam.notchToBukkit(this.team.method_1201());
    }

    @Override
    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        this.checkState();
        this.team.method_1149(CraftTeam.bukkitToNotch(visibility));
    }

    @Override
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.method_1204()) {
            players.add((Object)Bukkit.getOfflinePlayer(playerName));
        }
        return players.build();
    }

    @Override
    public Set<String> getEntries() throws IllegalStateException {
        this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.method_1204()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    @Override
    public int getSize() throws IllegalStateException {
        this.checkState();
        return this.team.method_1204().size();
    }

    @Override
    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        this.addEntry(player.getName());
    }

    @Override
    public void addEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.method_1172(entry, this.team);
    }

    @Override
    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.removeEntry(player.getName());
    }

    @Override
    public boolean removeEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.method_1204().contains(entry)) {
            return false;
        }
        scoreboard.board.method_1157(entry, this.team);
        return true;
    }

    @Override
    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"OfflinePlayer cannot be null");
        return this.hasEntry(player.getName());
    }

    @Override
    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        this.checkState();
        return this.team.method_1204().contains(entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.method_1191(this.team);
    }

    @Override
    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.method_1201().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.method_1200().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.method_1203().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + option);
    }

    @Override
    public void setOption(Team.Option option, Team.OptionStatus status) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.method_1149(class_270.class_272.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.method_1133(class_270.class_272.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.method_1145(class_270.class_271.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + option);
            }
        }
    }

    public static class_270.class_272 bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return class_270.class_272.field_1442;
            }
            case NEVER: {
                return class_270.class_272.field_1443;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return class_270.class_272.field_1444;
            }
            case HIDE_FOR_OWN_TEAM: {
                return class_270.class_272.field_1446;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    public static NameTagVisibility notchToBukkit(class_270.class_272 visibility) {
        switch (visibility) {
            case field_1442: {
                return NameTagVisibility.ALWAYS;
            }
            case field_1443: {
                return NameTagVisibility.NEVER;
            }
            case field_1444: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case field_1446: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        Preconditions.checkState((((CraftScoreboard)this.getScoreboard()).board.method_1153(this.team.method_1197()) != null ? 1 : 0) != 0, (Object)"Unregistered scoreboard component");
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

