/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.util;

import com.mohistmc.banner.stackdeobf.mappings.RemappingUtil;
import java.lang.reflect.Field;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;

final class Log4jRemapUtil {
    private static final Field PROXY_NAME = Log4jRemapUtil.getField(ThrowableProxy.class, "name");
    private static final Field PROXY_MESSAGE = Log4jRemapUtil.getField(ThrowableProxy.class, "message");
    private static final Field PROXY_LOCALIZED_MESSAGE = Log4jRemapUtil.getField(ThrowableProxy.class, "localizedMessage");
    private static final Field EXT_STACK_ELEMENT = Log4jRemapUtil.getField(ExtendedStackTraceElement.class, "stackTraceElement");

    Log4jRemapUtil() {
    }

    private static Field getField(Class<?> clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException(exception);
        }
    }

    static void remapThrowableProxy(ThrowableProxy proxy) throws IllegalAccessException {
        if (proxy.getName() != null && proxy.getName().startsWith("net.minecraft.class_")) {
            PROXY_NAME.set(proxy, RemappingUtil.remapClasses(proxy.getName()));
        }
        if (proxy.getMessage() != null) {
            PROXY_MESSAGE.set(proxy, RemappingUtil.remapString(proxy.getMessage()));
        }
        if (proxy.getLocalizedMessage() != null) {
            PROXY_LOCALIZED_MESSAGE.set(proxy, RemappingUtil.remapString(proxy.getLocalizedMessage()));
        }
        for (ExtendedStackTraceElement extendedStackTraceElement : proxy.getExtendedStackTrace()) {
            StackTraceElement element = extendedStackTraceElement.getStackTraceElement();
            element = RemappingUtil.remapStackTraceElement(element);
            EXT_STACK_ELEMENT.set(extendedStackTraceElement, element);
        }
        if (proxy.getCauseProxy() != null) {
            Log4jRemapUtil.remapThrowableProxy(proxy.getCauseProxy());
        }
        for (ExtendedStackTraceElement extendedStackTraceElement : proxy.getSuppressedProxies()) {
            Log4jRemapUtil.remapThrowableProxy((ThrowableProxy)extendedStackTraceElement);
        }
    }
}

