/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;

public final class TickThread
extends Thread {
    public static final boolean STRICT_THREAD_CHECKS = Boolean.getBoolean("paper.strict-thread-checks");
    public final int id;
    private static final AtomicInteger ID_GENERATOR;

    public static void softEnsureTickThread(String reason) {
        if (!STRICT_THREAD_CHECKS) {
            return;
        }
        TickThread.ensureTickThread(reason);
    }

    public static void ensureTickThread(String reason) {
        if (!TickThread.isTickThread()) {
            MinecraftServer.field_4546.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(class_3218 world, int chunkX, int chunkZ, String reason) {
        if (!TickThread.isTickThreadFor(world, chunkX, chunkZ)) {
            MinecraftServer.field_4546.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(class_1297 entity, String reason) {
        if (!TickThread.isTickThreadFor(entity)) {
            MinecraftServer.field_4546.error("Thread " + Thread.currentThread().getName() + " failed main thread check: " + reason, new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public TickThread(String name) {
        this((Runnable)null, name);
    }

    public TickThread(Runnable run, String name) {
        this(run, name, ID_GENERATOR.incrementAndGet());
    }

    private TickThread(Runnable run, String name, int id) {
        super(run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    public static boolean isTickThread() {
        return Bukkit.isPrimaryThread();
    }

    public static boolean isTickThreadFor(class_3218 world, int chunkX, int chunkZ) {
        return Bukkit.isPrimaryThread();
    }

    public static boolean isTickThreadFor(class_1297 entity) {
        return Bukkit.isPrimaryThread();
    }

    static {
        if (STRICT_THREAD_CHECKS) {
            MinecraftServer.field_4546.warn("Strict thread checks enabled - performance may suffer");
        }
        ID_GENERATOR = new AtomicInteger();
    }
}

