/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.class_3330;
import net.minecraft.class_3335;
import net.minecraft.class_3336;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R1.CraftProfileBanEntry;

public class CraftProfileBanList
implements BanList {
    private final class_3335 list;

    public CraftProfileBanList(class_3335 list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        class_3336 entry = (class_3336)this.list.method_14640((Object)profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Ban target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return null;
        }
        class_3336 entry = new class_3336(profile, new Date(), StringUtils.isBlank((CharSequence)source) ? null : source, expires, StringUtils.isBlank((CharSequence)reason) ? null : reason);
        this.list.method_14633((class_3330)entry);
        try {
            this.list.method_14629();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-players.json, {0}", ex.getMessage());
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (class_3330 entry : this.list.method_14632()) {
            GameProfile profile = (GameProfile)entry.method_14626();
            builder.add((Object)new CraftProfileBanEntry(profile, (class_3336)entry, this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        if (profile == null) {
            return false;
        }
        return this.list.method_14650(profile);
    }

    @Override
    public void pardon(String target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target cannot be null");
        GameProfile profile = this.getProfile(target);
        this.list.method_14635((Object)profile);
    }

    private GameProfile getProfile(String target) {
        UUID uuid = null;
        try {
            uuid = UUID.fromString(target);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return (uuid != null ? BukkitExtraConstants.getServer().method_3793().method_14512(uuid) : BukkitExtraConstants.getServer().method_3793().method_14515(target)).orElse(null);
    }
}

