/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mohistmc.banner.bukkit.CraftCustomContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2457;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftRayTraceResult;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftVoxelShape;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CraftBlock
implements Block {
    private final class_1936 world;
    private final class_2338 position;

    public CraftBlock(class_1936 world, class_2338 position) {
        this.world = world;
        this.position = position.method_10062();
    }

    public static CraftBlock at(class_1936 world, class_2338 position) {
        return new CraftBlock(world, position);
    }

    public class_2680 getNMS() {
        return this.world.method_8320(this.position);
    }

    public class_2338 getPosition() {
        return this.position;
    }

    public class_1936 getHandle() {
        return this.world;
    }

    @Override
    public World getWorld() {
        return this.world.getMinecraftWorld().getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    @Override
    public Location getLocation() {
        return CraftLocation.toBukkit(this.position, this.getWorld());
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.position.method_10263());
            loc.setY(this.position.method_10264());
            loc.setZ(this.position.method_10260());
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public int getX() {
        return this.position.method_10263();
    }

    @Override
    public int getY() {
        return this.position.method_10264();
    }

    @Override
    public int getZ() {
        return this.position.method_10260();
    }

    @Override
    public Chunk getChunk() {
        return this.getWorld().getChunkAt(this);
    }

    public void setData(byte data) {
        this.setData(data, 3);
    }

    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.setData(data, 3);
        } else {
            this.setData(data, 2);
        }
    }

    private void setData(byte data, int flag) {
        this.world.method_8652(this.position, CraftMagicNumbers.getBlock(this.getType(), data), flag);
    }

    @Override
    public byte getData() {
        class_2680 blockData = this.world.method_8320(this.position);
        return CraftMagicNumbers.toLegacyData(blockData);
    }

    @Override
    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getNMS());
    }

    @Override
    public void setType(Material type) {
        this.setType(type, true);
    }

    @Override
    public void setType(Material type, boolean applyPhysics) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        this.setBlockData(type.createBlockData(), applyPhysics);
    }

    @Override
    public void setBlockData(BlockData data) {
        this.setBlockData(data, true);
    }

    @Override
    public void setBlockData(BlockData data, boolean applyPhysics) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        this.setTypeAndData(((CraftBlockData)data).getState(), applyPhysics);
    }

    public boolean setTypeAndData(class_2680 blockData, boolean applyPhysics) {
        return CraftBlock.setTypeAndData(this.world, this.position, this.getNMS(), blockData, applyPhysics);
    }

    public static boolean setTypeAndData(class_1936 world, class_2338 position, class_2680 old, class_2680 blockData, boolean applyPhysics) {
        if (old.method_31709() && blockData.method_26204() != old.method_26204()) {
            if (world instanceof class_1937) {
                ((class_1937)world).method_8544(position);
            } else {
                world.method_8652(position, class_2246.field_10124.method_9564(), 0);
            }
        }
        if (applyPhysics) {
            return world.method_8652(position, blockData, 3);
        }
        boolean success = world.method_8652(position, blockData, 1042);
        if (success && world instanceof class_1937) {
            world.getMinecraftWorld().method_8413(position, old, blockData, 3);
        }
        return success;
    }

    @Override
    public Material getType() {
        return CraftMagicNumbers.getMaterial(this.world.method_8320(this.position).method_26204());
    }

    @Override
    public byte getLightLevel() {
        return (byte)this.world.getMinecraftWorld().method_22339(this.position);
    }

    @Override
    public byte getLightFromSky() {
        return (byte)this.world.method_8314(class_1944.field_9284, this.position);
    }

    @Override
    public byte getLightFromBlocks() {
        return (byte)this.world.method_8314(class_1944.field_9282, this.position);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    @Override
    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    @Override
    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    @Override
    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    @Override
    public BlockFace getFace(Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{pos=" + this.position + ",type=" + this.getType() + ",data=" + this.getNMS() + ",fluid=" + this.world.method_8316(this.position) + "}";
    }

    public static BlockFace notchToBlockFace(class_2350 notch) {
        if (notch == null) {
            return BlockFace.SELF;
        }
        switch (notch) {
            case field_11033: {
                return BlockFace.DOWN;
            }
            case field_11036: {
                return BlockFace.UP;
            }
            case field_11043: {
                return BlockFace.NORTH;
            }
            case field_11035: {
                return BlockFace.SOUTH;
            }
            case field_11039: {
                return BlockFace.WEST;
            }
            case field_11034: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static class_2350 blockFaceToNotch(BlockFace face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case DOWN: {
                return class_2350.field_11033;
            }
            case UP: {
                return class_2350.field_11036;
            }
            case NORTH: {
                return class_2350.field_11043;
            }
            case SOUTH: {
                return class_2350.field_11035;
            }
            case WEST: {
                return class_2350.field_11039;
            }
            case EAST: {
                return class_2350.field_11034;
            }
        }
        return null;
    }

    @Override
    public BlockState getState() {
        class_2586 blockEntity;
        Material material = this.getType();
        if (material == null && (blockEntity = ((CraftWorld)this.getWorld()).getHandle().method_8321(new class_2338(this.getX(), this.getY(), this.getZ()))) != null && blockEntity instanceof class_1263) {
            return new CraftCustomContainer(this);
        }
        return CraftBlockStates.getBlockState(this);
    }

    @Override
    public Biome getBiome() {
        return this.getWorld().getBiome(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.getX(), this.getY(), this.getZ(), bio);
    }

    public static Biome biomeBaseToBiome(class_2378<class_1959> registry, class_6880<class_1959> base) {
        return CraftBlock.biomeBaseToBiome(registry, (class_1959)base.comp_349());
    }

    public static Biome biomeBaseToBiome(class_2378<class_1959> registry, class_1959 base) {
        if (base == null) {
            return null;
        }
        Biome biome = Registry.BIOME.get(CraftNamespacedKey.fromMinecraft(registry.method_10221((Object)base)));
        return biome == null ? Biome.CUSTOM : biome;
    }

    public static class_6880<class_1959> biomeToBiomeBase(class_2378<class_1959> registry, Biome bio) {
        if (bio == null || bio == Biome.CUSTOM) {
            return null;
        }
        return registry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)CraftNamespacedKey.toMinecraft(bio.getKey())));
    }

    @Override
    public double getTemperature() {
        return ((class_1959)this.world.method_23753(this.position).comp_349()).method_21740(this.position);
    }

    @Override
    public double getHumidity() {
        return this.getWorld().getHumidity(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean isBlockPowered() {
        return this.world.getMinecraftWorld().method_49809(this.position) > 0;
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        return this.world.getMinecraftWorld().method_49803(this.position);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.position.equals((Object)other.position) && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        return this.position.hashCode() ^ this.getWorld().hashCode();
    }

    @Override
    public boolean isBlockFacePowered(BlockFace face) {
        return this.world.getMinecraftWorld().method_49807(this.position, CraftBlock.blockFaceToNotch(face));
    }

    @Override
    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.world.getMinecraftWorld().method_49808(this.position, CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    @Override
    public int getBlockPower(BlockFace face) {
        int power = 0;
        class_3218 world = this.world.getMinecraftWorld();
        int x = this.getX();
        int y = this.getY();
        int z = this.getZ();
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.method_49807(class_2338.method_49637((double)x, (double)(y - 1), (double)z), class_2350.field_11033)) {
            power = CraftBlock.getPower(power, world.method_8320(class_2338.method_49637((double)x, (double)(y - 1), (double)z)));
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.method_49807(class_2338.method_49637((double)x, (double)(y + 1), (double)z), class_2350.field_11036)) {
            power = CraftBlock.getPower(power, world.method_8320(class_2338.method_49637((double)x, (double)(y + 1), (double)z)));
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.method_49807(class_2338.method_49637((double)(x + 1), (double)y, (double)z), class_2350.field_11034)) {
            power = CraftBlock.getPower(power, world.method_8320(class_2338.method_49637((double)(x + 1), (double)y, (double)z)));
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.method_49807(class_2338.method_49637((double)(x - 1), (double)y, (double)z), class_2350.field_11039)) {
            power = CraftBlock.getPower(power, world.method_8320(class_2338.method_49637((double)(x - 1), (double)y, (double)z)));
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.method_49807(class_2338.method_49637((double)x, (double)y, (double)(z - 1)), class_2350.field_11043)) {
            power = CraftBlock.getPower(power, world.method_8320(class_2338.method_49637((double)x, (double)y, (double)(z - 1))));
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.method_49807(class_2338.method_49637((double)x, (double)y, (double)(z + 1)), class_2350.field_11035)) {
            power = CraftBlock.getPower(power, world.method_8320(class_2338.method_49637((double)x, (double)y, (double)(z + 1))));
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    private static int getPower(int i, class_2680 iblockdata) {
        if (!iblockdata.method_27852(class_2246.field_10091)) {
            return i;
        }
        int j = (Integer)iblockdata.method_11654((class_2769)class_2457.field_11432);
        return j > i ? j : i;
    }

    @Override
    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    @Override
    public boolean isEmpty() {
        return this.getNMS().method_26215();
    }

    @Override
    public boolean isLiquid() {
        return this.getNMS().method_51176();
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getNMS().method_26223().ordinal());
    }

    @Override
    public boolean breakNaturally() {
        return this.breakNaturally(null);
    }

    @Override
    public boolean breakNaturally(ItemStack item) {
        class_2680 iblockdata = this.getNMS();
        class_2248 block = iblockdata.method_26204();
        class_1799 nmsItem = CraftItemStack.asNMSCopy(item);
        boolean result = false;
        if (block != class_2246.field_10124 && (item == null || !iblockdata.method_29291() || nmsItem.method_7951(iblockdata))) {
            class_2248.method_9511((class_2680)iblockdata, (class_1937)this.world.getMinecraftWorld(), (class_2338)this.position, (class_2586)this.world.method_8321(this.position), null, (class_1799)nmsItem);
            result = true;
        }
        return this.world.method_8652(this.position, class_2246.field_10124.method_9564(), 3) && result;
    }

    @Override
    public boolean applyBoneMeal(BlockFace face) {
        class_2350 direction = CraftBlock.blockFaceToNotch(face);
        BlockFertilizeEvent event = null;
        class_3218 world = this.getCraftWorld().getHandle();
        class_1838 context = new class_1838((class_1937)world, null, class_1268.field_5808, class_1802.field_8324.method_7854(), new class_3965(class_243.field_1353, direction, this.getPosition(), false));
        world.banner$setCaptureTreeGeneration(true);
        class_1269 result = BukkitExtraConstants.applyBonemeal(context);
        world.banner$setCaptureTreeGeneration(false);
        if (world.bridge$capturedBlockStates().size() > 0) {
            TreeType treeType = BukkitExtraConstants.treeType;
            BukkitExtraConstants.treeType = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.bridge$capturedBlockStates().values());
            world.bridge$capturedBlockStates().clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                structureEvent = new StructureGrowEvent(this.getLocation(), treeType, true, null, blocks);
                Bukkit.getPluginManager().callEvent(structureEvent);
            }
            event = new BlockFertilizeEvent(CraftBlock.at((class_1936)world, this.getPosition()), null, blocks);
            event.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent(event);
            if (!event.isCancelled()) {
                for (BlockState blockstate : blocks) {
                    blockstate.update(true);
                }
            }
        }
        return result == class_1269.field_5812 && (event == null || !event.isCancelled());
    }

    @Override
    public Collection<ItemStack> getDrops() {
        return this.getDrops(null);
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item) {
        return this.getDrops(item, null);
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item, Entity entity) {
        class_2680 iblockdata = this.getNMS();
        class_1799 nms = CraftItemStack.asNMSCopy(item);
        if (item == null || CraftBlockData.isPreferredTool(iblockdata, nms)) {
            return class_2248.method_9609((class_2680)iblockdata, (class_3218)this.world.getMinecraftWorld(), (class_2338)this.position, (class_2586)this.world.method_8321(this.position), (class_1297)(entity == null ? null : ((CraftEntity)entity).getHandle()), (class_1799)nms).stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isPreferredTool(ItemStack item) {
        class_2680 iblockdata = this.getNMS();
        class_1799 nms = CraftItemStack.asNMSCopy(item);
        return CraftBlockData.isPreferredTool(iblockdata, nms);
    }

    @Override
    public float getBreakSpeed(Player player) {
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        return this.getNMS().method_26165((class_1657)((CraftPlayer)player).getHandle(), (class_1922)this.world, this.position);
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean isPassable() {
        return this.getNMS().method_26220((class_1922)this.world, this.position).method_1110();
    }

    @Override
    public RayTraceResult rayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"Location start cannot be null");
        Preconditions.checkArgument((boolean)this.getWorld().equals(start.getWorld()), (Object)"Location start cannot be a different world");
        start.checkFinite();
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"Vector direction cannot be null");
        direction.checkFinite();
        Preconditions.checkArgument((direction.lengthSquared() > 0.0 ? 1 : 0) != 0, (String)"Direction's magnitude (%s) must be greater than 0", (Object)direction.lengthSquared());
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"FluidCollisionMode cannot be null");
        if (maxDistance < 0.0) {
            return null;
        }
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        class_243 startPos = CraftLocation.toVec3D(start);
        class_243 endPos = startPos.method_1031(dir.getX(), dir.getY(), dir.getZ());
        class_3965 nmsHitResult = this.world.clip(new class_3959(startPos, endPos, class_3959.class_3960.field_17559, CraftFluidCollisionMode.toNMS(fluidCollisionMode), null), this.position);
        return CraftRayTraceResult.fromNMS(this.getWorld(), (class_239)nmsHitResult);
    }

    @Override
    public BoundingBox getBoundingBox() {
        class_265 shape = this.getNMS().method_26218((class_1922)this.world, this.position);
        if (shape.method_1110()) {
            return new BoundingBox();
        }
        class_238 aabb = shape.method_1107();
        return new BoundingBox((double)this.getX() + aabb.field_1323, (double)this.getY() + aabb.field_1322, (double)this.getZ() + aabb.field_1321, (double)this.getX() + aabb.field_1320, (double)this.getY() + aabb.field_1325, (double)this.getZ() + aabb.field_1324);
    }

    @Override
    public VoxelShape getCollisionShape() {
        class_265 shape = this.getNMS().method_26220((class_1922)this.world, this.position);
        return new CraftVoxelShape(shape);
    }

    @Override
    public boolean canPlace(@NotNull BlockData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"BlockData cannot be null");
        class_2680 iblockdata = ((CraftBlockData)data).getState();
        class_3218 world = this.world.getMinecraftWorld();
        return iblockdata.method_26184((class_4538)world, this.position);
    }

    @Override
    public String getTranslationKey() {
        return this.getNMS().method_26204().method_9539();
    }
}

