/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2515;
import net.minecraft.class_2633;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2776;
import org.apache.commons.lang3.Validate;
import org.bukkit.World;
import org.bukkit.block.Structure;
import org.bukkit.block.structure.Mirror;
import org.bukkit.block.structure.StructureRotation;
import org.bukkit.block.structure.UsageMode;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftBlockVector;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.BlockVector;

public class CraftStructureBlock
extends CraftBlockEntityState<class_2633>
implements Structure {
    private static final int MAX_SIZE = 48;

    public CraftStructureBlock(World world, class_2633 structure) {
        super(world, structure);
    }

    @Override
    public String getStructureName() {
        return ((class_2633)this.getSnapshot()).method_11362();
    }

    @Override
    public void setStructureName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Structure name cannot be null");
        ((class_2633)this.getSnapshot()).method_11343(name);
    }

    @Override
    public String getAuthor() {
        return ((class_2633)this.getSnapshot()).field_12104;
    }

    @Override
    public void setAuthor(String author) {
        Preconditions.checkArgument((author != null ? 1 : 0) != 0, (Object)"Author name cannot be null");
        Preconditions.checkArgument((!author.isEmpty() ? 1 : 0) != 0, (Object)"Author name cannot be empty");
        ((class_2633)this.getSnapshot()).field_12104 = author;
    }

    @Override
    public void setAuthor(LivingEntity entity) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"Structure Block author entity cannot be null");
        ((class_2633)this.getSnapshot()).method_11373(((CraftLivingEntity)entity).getHandle());
    }

    @Override
    public BlockVector getRelativePosition() {
        return CraftBlockVector.toBukkit((class_2382)((class_2633)this.getSnapshot()).field_12092);
    }

    @Override
    public void setRelativePosition(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), -48, 48), (String)"Structure Size (X) must be between -48 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), -48, 48), (String)"Structure Size (Y) must be between -48 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), -48, 48), (String)"Structure Size (Z) must be between -48 and 48", (Object[])new Object[0]);
        ((class_2633)this.getSnapshot()).field_12092 = CraftBlockVector.toBlockPosition(vector);
    }

    @Override
    public BlockVector getStructureSize() {
        return CraftBlockVector.toBukkit(((class_2633)this.getSnapshot()).field_12100);
    }

    @Override
    public void setStructureSize(BlockVector vector) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockX(), 0, 48), (String)"Structure Size (X) must be between 0 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockY(), 0, 48), (String)"Structure Size (Y) must be between 0 and 48", (Object[])new Object[0]);
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(vector.getBlockZ(), 0, 48), (String)"Structure Size (Z) must be between 0 and 48", (Object[])new Object[0]);
        ((class_2633)this.getSnapshot()).field_12100 = CraftBlockVector.toBlockPosition(vector);
    }

    @Override
    public void setMirror(Mirror mirror) {
        ((class_2633)this.getSnapshot()).field_12093 = class_2415.valueOf((String)mirror.name());
    }

    @Override
    public Mirror getMirror() {
        return Mirror.valueOf(((class_2633)this.getSnapshot()).field_12093.name());
    }

    @Override
    public void setRotation(StructureRotation rotation) {
        ((class_2633)this.getSnapshot()).field_12105 = class_2470.valueOf((String)rotation.name());
    }

    @Override
    public StructureRotation getRotation() {
        return StructureRotation.valueOf(((class_2633)this.getSnapshot()).field_12105.name());
    }

    @Override
    public void setUsageMode(UsageMode mode) {
        ((class_2633)this.getSnapshot()).field_12094 = class_2776.valueOf((String)mode.name());
    }

    @Override
    public UsageMode getUsageMode() {
        return UsageMode.valueOf(((class_2633)this.getSnapshot()).method_11374().name());
    }

    @Override
    public void setIgnoreEntities(boolean flag) {
        ((class_2633)this.getSnapshot()).field_12099 = flag;
    }

    @Override
    public boolean isIgnoreEntities() {
        return ((class_2633)this.getSnapshot()).field_12099;
    }

    @Override
    public void setShowAir(boolean showAir) {
        ((class_2633)this.getSnapshot()).field_12096 = showAir;
    }

    @Override
    public boolean isShowAir() {
        return ((class_2633)this.getSnapshot()).field_12096;
    }

    @Override
    public void setBoundingBoxVisible(boolean showBoundingBox) {
        ((class_2633)this.getSnapshot()).field_12095 = showBoundingBox;
    }

    @Override
    public boolean isBoundingBoxVisible() {
        return ((class_2633)this.getSnapshot()).field_12095;
    }

    @Override
    public void setIntegrity(float integrity) {
        Validate.isTrue((boolean)CraftStructureBlock.isBetween(integrity, 0.0f, 1.0f), (String)"Integrity must be between 0.0f and 1.0f", (Object[])new Object[0]);
        ((class_2633)this.getSnapshot()).field_12101 = integrity;
    }

    @Override
    public float getIntegrity() {
        return ((class_2633)this.getSnapshot()).field_12101;
    }

    @Override
    public void setSeed(long seed) {
        ((class_2633)this.getSnapshot()).field_12103 = seed;
    }

    @Override
    public long getSeed() {
        return ((class_2633)this.getSnapshot()).field_12103;
    }

    @Override
    public void setMetadata(String metadata) {
        Validate.notNull((Object)metadata, (String)"Structure metadata cannot be null", (Object[])new Object[0]);
        if (this.getUsageMode() == UsageMode.DATA) {
            ((class_2633)this.getSnapshot()).field_12098 = metadata;
        }
    }

    @Override
    public String getMetadata() {
        return ((class_2633)this.getSnapshot()).field_12098;
    }

    @Override
    protected void applyTo(class_2633 tileEntity) {
        class_2680 data;
        super.applyTo(tileEntity);
        class_1936 access = this.getWorldHandle();
        if (access instanceof class_1937) {
            tileEntity.method_11381(tileEntity.method_11374());
        } else if (access != null && (data = access.method_8320(this.getPosition())).method_27852(class_2246.field_10465)) {
            access.method_8652(this.getPosition(), (class_2680)data.method_11657((class_2769)class_2515.field_11586, (Comparable)tileEntity.method_11374()), 2);
        }
    }

    private static boolean isBetween(int num, int min, int max) {
        return num >= min && num <= max;
    }

    private static boolean isBetween(float num, float min, float max) {
        return num >= min && num <= max;
    }
}

