/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.craftbukkit.v1_20_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;

public class CraftAreaEffectCloud
extends CraftEntity
implements AreaEffectCloud {
    public CraftAreaEffectCloud(CraftServer server, class_1295 entity) {
        super(server, (class_1297)entity);
    }

    public class_1295 getHandle() {
        return (class_1295)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftAreaEffectCloud";
    }

    @Override
    public EntityType getType() {
        return EntityType.AREA_EFFECT_CLOUD;
    }

    @Override
    public int getDuration() {
        return this.getHandle().method_5605();
    }

    @Override
    public void setDuration(int duration) {
        this.getHandle().method_5604(duration);
    }

    @Override
    public int getWaitTime() {
        return this.getHandle().field_5941;
    }

    @Override
    public void setWaitTime(int waitTime) {
        this.getHandle().method_5595(waitTime);
    }

    @Override
    public int getReapplicationDelay() {
        return this.getHandle().field_5937;
    }

    @Override
    public void setReapplicationDelay(int delay) {
        this.getHandle().field_5937 = delay;
    }

    @Override
    public int getDurationOnUse() {
        return this.getHandle().field_5932;
    }

    @Override
    public void setDurationOnUse(int duration) {
        this.getHandle().field_5932 = duration;
    }

    @Override
    public float getRadius() {
        return this.getHandle().method_5599();
    }

    @Override
    public void setRadius(float radius) {
        this.getHandle().method_5603(radius);
    }

    @Override
    public float getRadiusOnUse() {
        return this.getHandle().field_5929;
    }

    @Override
    public void setRadiusOnUse(float radius) {
        this.getHandle().method_5609(radius);
    }

    @Override
    public float getRadiusPerTick() {
        return this.getHandle().field_5930;
    }

    @Override
    public void setRadiusPerTick(float radius) {
        this.getHandle().method_5596(radius);
    }

    @Override
    public Particle getParticle() {
        return CraftParticle.toBukkit(this.getHandle().method_5600());
    }

    @Override
    public void setParticle(Particle particle) {
        this.setParticle(particle, null);
    }

    @Override
    public <T> void setParticle(Particle particle, T data) {
        this.getHandle().method_5608(CraftParticle.toNMS(particle, data));
    }

    @Override
    public Color getColor() {
        return Color.fromRGB(this.getHandle().method_5606());
    }

    @Override
    public void setColor(Color color) {
        this.getHandle().method_5602(color.asRGB());
    }

    @Override
    public boolean addCustomEffect(PotionEffect effect, boolean override) {
        int effectId = effect.getType().getId();
        class_1293 existing = null;
        for (class_1293 mobEffect : this.getHandle().field_5934) {
            if (class_1291.method_5554((class_1291)mobEffect.method_5579()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing != null) {
            if (!override) {
                return false;
            }
            this.getHandle().field_5934.remove(existing);
        }
        this.getHandle().method_5610(CraftPotionUtil.fromBukkit(effect));
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void clearCustomEffects() {
        this.getHandle().field_5934.clear();
        this.getHandle().refreshEffects();
    }

    @Override
    public List<PotionEffect> getCustomEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_1293 effect : this.getHandle().field_5934) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public boolean hasCustomEffect(PotionEffectType type) {
        for (class_1293 effect : this.getHandle().field_5934) {
            if (!CraftPotionUtil.equals(effect.method_5579(), type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCustomEffects() {
        return !this.getHandle().field_5934.isEmpty();
    }

    @Override
    public boolean removeCustomEffect(PotionEffectType effect) {
        int effectId = effect.getId();
        class_1293 existing = null;
        for (class_1293 mobEffect : this.getHandle().field_5934) {
            if (class_1291.method_5554((class_1291)mobEffect.method_5579()) != effectId) continue;
            existing = mobEffect;
        }
        if (existing == null) {
            return false;
        }
        this.getHandle().field_5934.remove(existing);
        this.getHandle().refreshEffects();
        return true;
    }

    @Override
    public void setBasePotionData(PotionData data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"PotionData cannot be null");
        this.getHandle().setPotionType(CraftPotionUtil.fromBukkit(data));
    }

    @Override
    public PotionData getBasePotionData() {
        return CraftPotionUtil.toBukkit(this.getHandle().getPotionType());
    }

    @Override
    public ProjectileSource getSource() {
        class_1309 source = this.getHandle().method_5601();
        return source == null ? null : (LivingEntity)((Object)source.getBukkitEntity());
    }

    @Override
    public void setSource(ProjectileSource shooter) {
        if (shooter instanceof CraftLivingEntity) {
            CraftLivingEntity craftLivingEntity = (CraftLivingEntity)shooter;
            this.getHandle().method_5607(craftLivingEntity.getHandle());
        } else {
            this.getHandle().method_5607(null);
        }
    }
}

