/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.mappings;

import com.mohistmc.banner.stackdeobf.mappings.CachedMappings;
import com.mohistmc.banner.stackdeobf.mappings.RemappedThrowable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RemappingUtil {
    static final Pattern CLASS_PATTERN = Pattern.compile("(net\\.minecraft\\.|net/minecraft/)?class_(\\d+)");
    private static final Pattern METHOD_PATTERN = Pattern.compile("method_(\\d+)");
    private static final Pattern FIELD_PATTERN = Pattern.compile("field_(\\d+)");

    private RemappingUtil() {
    }

    public static String remapClasses(String string) {
        return CLASS_PATTERN.matcher(string).replaceAll(result -> {
            int classId = Integer.parseInt(result.group(2));
            String className = CachedMappings.remapClass(classId);
            if (className == null) {
                return result.group();
            }
            String packageName = result.group(1);
            if (packageName != null) {
                if (packageName.indexOf(46) == -1) {
                    return className.replace('.', '/');
                }
                return className;
            }
            int packageIndex = className.lastIndexOf(46);
            if (packageIndex != -1) {
                className = className.substring(packageIndex + 1);
            }
            return className;
        });
    }

    public static String remapMethods(String string) {
        return METHOD_PATTERN.matcher(string).replaceAll(result -> {
            int methodId = Integer.parseInt(result.group(1));
            String methodName = CachedMappings.remapMethod(methodId);
            return methodName == null ? result.group() : Matcher.quoteReplacement(methodName);
        });
    }

    public static String remapFields(String string) {
        return FIELD_PATTERN.matcher(string).replaceAll(result -> {
            int fieldId = Integer.parseInt(result.group(1));
            String fieldName = CachedMappings.remapField(fieldId);
            return fieldName == null ? result.group() : fieldName;
        });
    }

    public static String remapString(String string) {
        if (string.contains("class_")) {
            string = RemappingUtil.remapClasses(string);
        }
        if (string.contains("method_")) {
            string = RemappingUtil.remapMethods(string);
        }
        if (string.contains("field_")) {
            string = RemappingUtil.remapFields(string);
        }
        return string;
    }

    public static Throwable remapThrowable(Throwable throwable) {
        String throwableName;
        String message;
        if (throwable instanceof RemappedThrowable) {
            return throwable;
        }
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        RemappingUtil.remapStackTraceElements(stackTrace);
        Throwable cause = throwable.getCause();
        if (cause != null) {
            cause = RemappingUtil.remapThrowable(cause);
        }
        if ((message = throwable.getMessage()) != null) {
            message = RemappingUtil.remapString(message);
        }
        if ((throwableName = throwable.getClass().getName()).startsWith("net.minecraft.class_")) {
            throwableName = RemappingUtil.remapClasses(throwableName);
        }
        RemappedThrowable remapped = new RemappedThrowable(message, cause, throwable, throwableName);
        remapped.setStackTrace(stackTrace);
        for (Throwable suppressed : throwable.getSuppressed()) {
            remapped.addSuppressed(RemappingUtil.remapThrowable(suppressed));
        }
        return remapped;
    }

    public static void remapStackTraceElements(StackTraceElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = RemappingUtil.remapStackTraceElement(elements[i]);
        }
    }

    public static StackTraceElement remapStackTraceElement(StackTraceElement element) {
        String methodName;
        String fileName;
        String className = element.getClassName();
        boolean remappedClass = false;
        if (className.startsWith("net.minecraft.class_")) {
            className = RemappingUtil.remapClasses(className);
            remappedClass = true;
        }
        if ((fileName = element.getFileName()) != null && fileName.startsWith("class_")) {
            fileName = RemappingUtil.remapClasses(fileName);
        }
        if ((methodName = element.getMethodName()).startsWith("method_")) {
            methodName = RemappingUtil.remapMethods(methodName);
        }
        Object classLoaderName = element.getClassLoaderName();
        if (remappedClass) {
            classLoaderName = classLoaderName == null ? "MC" : (String)classLoaderName + "//MC";
        }
        return new StackTraceElement((String)classLoaderName, element.getModuleName(), element.getModuleVersion(), className, methodName, fileName, element.getLineNumber());
    }
}

