/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1952;
import net.minecraft.class_2487;
import net.minecraft.class_2636;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import org.bukkit.World;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockEntityState;
import org.bukkit.entity.EntityType;

public class CraftCreatureSpawner
extends CraftBlockEntityState<class_2636>
implements CreatureSpawner {
    public CraftCreatureSpawner(World world, class_2636 tileEntity) {
        super(world, tileEntity);
    }

    @Override
    public EntityType getSpawnedType() {
        class_1952 spawnData = ((class_2636)this.getSnapshot()).method_11390().field_9155;
        if (spawnData == null) {
            return null;
        }
        Optional type = class_1299.method_17684((class_2487)spawnData.method_38093());
        return type.map(entityTypes -> EntityType.fromName(class_1299.method_5890((class_1299)entityTypes).method_12832())).orElse(null);
    }

    @Override
    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            ((class_2636)this.getSnapshot()).method_11390().field_9152 = class_6005.method_38062();
            ((class_2636)this.getSnapshot()).method_11390().field_9155 = null;
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        class_5819 rand = this.isPlaced() ? this.getWorldHandle().method_8409() : class_5819.method_43047();
        ((class_2636)this.getSnapshot()).method_46408((class_1299)class_1299.method_5898((String)entityType.getName()).get(), rand);
    }

    @Override
    public String getCreatureTypeName() {
        class_1952 spawnData = ((class_2636)this.getSnapshot()).method_11390().field_9155;
        if (spawnData == null) {
            return null;
        }
        Optional type = class_1299.method_17684((class_2487)spawnData.method_38093());
        return type.map(entityTypes -> class_1299.method_5890((class_1299)entityTypes).method_12832()).orElse(null);
    }

    @Override
    public void setCreatureTypeByName(String creatureType) {
        EntityType type = EntityType.fromName(creatureType);
        if (type == null) {
            this.setSpawnedType(null);
            return;
        }
        this.setSpawnedType(type);
    }

    @Override
    public int getDelay() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9154;
    }

    @Override
    public void setDelay(int delay) {
        ((class_2636)this.getSnapshot()).method_11390().field_9154 = delay;
    }

    @Override
    public int getMinSpawnDelay() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9151;
    }

    @Override
    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        ((class_2636)this.getSnapshot()).method_11390().field_9151 = spawnDelay;
    }

    @Override
    public int getMaxSpawnDelay() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9150;
    }

    @Override
    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        ((class_2636)this.getSnapshot()).method_11390().field_9150 = spawnDelay;
    }

    @Override
    public int getMaxNearbyEntities() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9160;
    }

    @Override
    public void setMaxNearbyEntities(int maxNearbyEntities) {
        ((class_2636)this.getSnapshot()).method_11390().field_9160 = maxNearbyEntities;
    }

    @Override
    public int getSpawnCount() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9149;
    }

    @Override
    public void setSpawnCount(int count) {
        ((class_2636)this.getSnapshot()).method_11390().field_9149 = count;
    }

    @Override
    public int getRequiredPlayerRange() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9158;
    }

    @Override
    public void setRequiredPlayerRange(int requiredPlayerRange) {
        ((class_2636)this.getSnapshot()).method_11390().field_9158 = requiredPlayerRange;
    }

    @Override
    public int getSpawnRange() {
        return ((class_2636)this.getSnapshot()).method_11390().field_9157;
    }

    @Override
    public void setSpawnRange(int spawnRange) {
        ((class_2636)this.getSnapshot()).method_11390().field_9157 = spawnRange;
    }
}

