/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import com.mohistmc.banner.bukkit.BannerLecternInventory;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1725;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_2387;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2601;
import net.minecraft.class_2608;
import net.minecraft.class_2609;
import net.minecraft.class_2615;
import net.minecraft.class_2627;
import net.minecraft.class_3719;
import net.minecraft.class_3720;
import net.minecraft.class_3722;
import net.minecraft.class_3723;
import net.minecraft.class_3962;
import net.minecraft.class_7716;
import net.minecraft.class_8566;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryCartography;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryEnchanting;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryGrindstone;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryLoom;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventorySmithing;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventorySmithingNew;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.InventoryIterator;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLegacy;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftInventory
implements Inventory {
    protected final class_1263 inventory;

    public CraftInventory(class_1263 inventory) {
        this.inventory = inventory;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    @Override
    public int getSize() {
        return this.getInventory().method_5439();
    }

    @Override
    public ItemStack getItem(int index) {
        class_1799 item = this.getInventory().method_5438(index);
        return item.method_7960() ? null : CraftItemStack.asCraftMirror(item);
    }

    protected ItemStack[] asCraftMirror(List<class_1799> mcItems) {
        int size = mcItems.size();
        ItemStack[] items = new ItemStack[size];
        for (int i = 0; i < size; ++i) {
            class_1799 mcItem = mcItems.get(i);
            items[i] = mcItem.method_7960() ? null : CraftItemStack.asCraftMirror(mcItem);
        }
        return items;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.getContents();
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setContents(items);
    }

    @Override
    public ItemStack[] getContents() {
        List mcItems = this.getInventory().getContents();
        return this.asCraftMirror(mcItems);
    }

    @Override
    public void setContents(ItemStack[] items) {
        Preconditions.checkArgument((items.length <= this.getSize() ? 1 : 0) != 0, (String)"Invalid inventory size (%s); expected %s or less", (int)items.length, (int)this.getSize());
        for (int i = 0; i < this.getSize(); ++i) {
            if (i >= items.length) {
                this.setItem(i, null);
                continue;
            }
            this.setItem(i, items[i]);
        }
    }

    @Override
    public void setItem(int index, ItemStack item) {
        this.getInventory().method_5447(index, CraftItemStack.asNMSCopy(item));
    }

    @Override
    public boolean contains(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        for (ItemStack item : this.getStorageContents()) {
            if (item == null || item.getType() != material) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.equals(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Material material, int amount) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        if (amount <= 0) {
            return true;
        }
        for (ItemStack item : this.getStorageContents()) {
            if (item == null || item.getType() != material || (amount -= item.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.equals(i) || --amount > 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAtLeast(ItemStack item, int amount) {
        if (item == null) {
            return false;
        }
        if (amount <= 0) {
            return true;
        }
        for (ItemStack i : this.getStorageContents()) {
            if (!item.isSimilar(i) || (amount -= i.getAmount()) > 0) continue;
            return true;
        }
        return false;
    }

    public HashMap<Integer, ItemStack> all(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material) continue;
            slots.put(i, item);
        }
        return slots;
    }

    public HashMap<Integer, ItemStack> all(ItemStack item) {
        HashMap<Integer, ItemStack> slots = new HashMap<Integer, ItemStack>();
        if (item != null) {
            ItemStack[] inventory = this.getStorageContents();
            for (int i = 0; i < inventory.length; ++i) {
                if (!item.equals(inventory[i])) continue;
                slots.put(i, inventory[i]);
            }
        }
        return slots;
    }

    @Override
    public int first(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int first(ItemStack item) {
        return this.first(item, true);
    }

    private int first(ItemStack item, boolean withAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null || !(withAmount ? item.equals(inventory[i]) : item.isSimilar(inventory[i]))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int firstEmpty() {
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] != null) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.inventory.method_5442();
    }

    public int firstPartial(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] inventory = this.getStorageContents();
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack item = inventory[i];
            if (item == null || item.getType() != material || item.getAmount() >= item.getMaxStackSize()) continue;
            return i;
        }
        return -1;
    }

    private int firstPartial(ItemStack item) {
        ItemStack[] inventory = this.getStorageContents();
        CraftItemStack filteredItem = CraftItemStack.asCraftCopy(item);
        if (item == null) {
            return -1;
        }
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack cItem = inventory[i];
            if (cItem == null || cItem.getAmount() >= cItem.getMaxStackSize() || !cItem.isSimilar(filteredItem)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HashMap<Integer, ItemStack> addItem(ItemStack ... items) {
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
            while (true) {
                int maxAmount;
                int partialAmount;
                int firstPartial;
                if ((firstPartial = this.firstPartial(item)) == -1) {
                    int firstFree = this.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i, item);
                        continue block0;
                    }
                    if (item.getAmount() > this.getMaxItemStack()) {
                        CraftItemStack stack = CraftItemStack.asCraftCopy(item);
                        stack.setAmount(this.getMaxItemStack());
                        this.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - this.getMaxItemStack());
                        continue;
                    }
                    this.setItem(firstFree, item);
                    continue block0;
                }
                ItemStack partialItem = this.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= (maxAmount = partialItem.getMaxStackSize())) {
                    partialItem.setAmount(amount + partialAmount);
                    this.setItem(firstPartial, partialItem);
                    continue block0;
                }
                partialItem.setAmount(maxAmount);
                this.setItem(firstPartial, partialItem);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return leftover;
    }

    @Override
    public HashMap<Integer, ItemStack> removeItem(ItemStack ... items) {
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items cannot be null");
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        block0: for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            Preconditions.checkArgument((item != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
            int toDelete = item.getAmount();
            do {
                int first;
                if ((first = this.first(item, false)) == -1) {
                    item.setAmount(toDelete);
                    leftover.put(i, item);
                    continue block0;
                }
                ItemStack itemStack = this.getItem(first);
                int amount = itemStack.getAmount();
                if (amount <= toDelete) {
                    toDelete -= amount;
                    this.clear(first);
                    continue;
                }
                itemStack.setAmount(amount - toDelete);
                this.setItem(first, itemStack);
                toDelete = 0;
            } while (toDelete > 0);
        }
        return leftover;
    }

    private int getMaxItemStack() {
        return this.getInventory().method_5444();
    }

    @Override
    public void remove(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        material = CraftLegacy.fromLegacy(material);
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != material) continue;
            this.clear(i);
        }
    }

    @Override
    public void remove(ItemStack item) {
        ItemStack[] items = this.getStorageContents();
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null || !items[i].equals(item)) continue;
            this.clear(i);
        }
    }

    @Override
    public void clear(int index) {
        this.setItem(index, null);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.getSize(); ++i) {
            this.clear(i);
        }
    }

    @Override
    public ListIterator<ItemStack> iterator() {
        return new InventoryIterator(this);
    }

    @Override
    public ListIterator<ItemStack> iterator(int index) {
        if (index < 0) {
            index += this.getSize() + 1;
        }
        return new InventoryIterator(this, index);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.inventory.getViewers();
    }

    @Override
    public InventoryType getType() {
        if (this.inventory.getClass().getDeclaringClass() == class_3722.class) {
            return InventoryType.LECTERN;
        }
        if (this.inventory instanceof class_8566) {
            return this.inventory.method_5439() >= 9 ? InventoryType.WORKBENCH : InventoryType.CRAFTING;
        }
        if (this.inventory instanceof class_1661) {
            return InventoryType.PLAYER;
        }
        if (this.inventory instanceof class_2608) {
            return InventoryType.DROPPER;
        }
        if (this.inventory instanceof class_2601) {
            return InventoryType.DISPENSER;
        }
        if (this.inventory instanceof class_3720) {
            return InventoryType.BLAST_FURNACE;
        }
        if (this.inventory instanceof class_3723) {
            return InventoryType.SMOKER;
        }
        if (this.inventory instanceof class_2609) {
            return InventoryType.FURNACE;
        }
        if (this instanceof CraftInventoryEnchanting) {
            return InventoryType.ENCHANTING;
        }
        if (this.inventory instanceof class_2589) {
            return InventoryType.BREWING;
        }
        if (this.inventory instanceof CraftInventoryCustom.MinecraftInventory) {
            return ((CraftInventoryCustom.MinecraftInventory)this.inventory).getType();
        }
        if (this.inventory instanceof class_1730) {
            return InventoryType.ENDER_CHEST;
        }
        if (this.inventory instanceof class_1725) {
            return InventoryType.MERCHANT;
        }
        if (this instanceof CraftInventoryBeacon) {
            return InventoryType.BEACON;
        }
        if (this instanceof CraftInventoryAnvil) {
            return InventoryType.ANVIL;
        }
        if (this instanceof CraftInventorySmithing) {
            return InventoryType.SMITHING;
        }
        if (this.inventory instanceof class_2615) {
            return InventoryType.HOPPER;
        }
        if (this.inventory instanceof class_2627) {
            return InventoryType.SHULKER_BOX;
        }
        if (this.inventory instanceof class_3719) {
            return InventoryType.BARREL;
        }
        if (this.inventory instanceof BannerLecternInventory) {
            return InventoryType.LECTERN;
        }
        if (this.inventory instanceof class_7716) {
            return InventoryType.CHISELED_BOOKSHELF;
        }
        if (this instanceof CraftInventoryLoom) {
            return InventoryType.LOOM;
        }
        if (this instanceof CraftInventoryCartography) {
            return InventoryType.CARTOGRAPHY;
        }
        if (this instanceof CraftInventoryGrindstone) {
            return InventoryType.GRINDSTONE;
        }
        if (this instanceof CraftInventoryStonecutter) {
            return InventoryType.STONECUTTER;
        }
        if (this.inventory instanceof class_3962.class_3925 || this.inventory instanceof class_3962.class_3963 || this.inventory instanceof class_3962.class_3964) {
            return InventoryType.COMPOSTER;
        }
        if (this.inventory instanceof class_2387) {
            return InventoryType.JUKEBOX;
        }
        if (this instanceof CraftInventorySmithingNew) {
            return InventoryType.SMITHING_NEW;
        }
        return InventoryType.CHEST;
    }

    @Override
    public InventoryHolder getHolder() {
        return this.inventory.getOwner();
    }

    @Override
    public int getMaxStackSize() {
        return this.inventory.method_5444();
    }

    @Override
    public void setMaxStackSize(int size) {
        this.inventory.setMaxStackSize(size);
    }

    public int hashCode() {
        return this.inventory.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftInventory && ((CraftInventory)obj).inventory.equals(this.inventory);
    }

    @Override
    public Location getLocation() {
        try {
            return this.inventory.getLocation();
        }
        catch (AbstractMethodError e) {
            class_1263 class_12632 = this.inventory;
            if (class_12632 instanceof class_2586) {
                class_2586 tileEntity = (class_2586)class_12632;
                return new Location(tileEntity.method_10997().getWorld(), tileEntity.method_11016().method_10263(), tileEntity.method_11016().method_10264(), tileEntity.method_11016().method_10260());
            }
            return null;
        }
    }
}

