/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.config;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class BannerConfig {
    private static File CONFIG_FILE;
    private static final String HEADER = "This is the main configuration file for Banner.\nAs you can see, there's tons to configure. Some options may impact gameplay, so use\nwith caution, and make sure you know what each option does before configuring.\n";
    public static YamlConfiguration config;
    static int version;

    public static void init(File configFile) {
        CONFIG_FILE = configFile;
        config = new YamlConfiguration();
        try {
            config.load(CONFIG_FILE);
        }
        catch (IOException iOException) {
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not load banner.yml, please correct your syntax errors", ex);
            throw Throwables.propagate((Throwable)ex);
        }
        config.options().header(HEADER);
        config.options().copyDefaults(true);
        version = BannerConfig.getInt("config-version", 12);
        BannerConfig.set("config-version", 12);
        BannerConfig.readConfig(BannerConfig.class, null);
    }

    static void readConfig(Class<?> clazz, Object instance) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(CONFIG_FILE);
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Could not save " + CONFIG_FILE, ex);
        }
    }

    private static void set(String path, Object val) {
        config.set(path, val);
    }

    private static boolean getBoolean(String path, boolean def) {
        config.addDefault(path, def);
        return config.getBoolean(path, config.getBoolean(path));
    }

    private static int getInt(String path, int def) {
        config.addDefault(path, def);
        return config.getInt(path, config.getInt(path));
    }

    private static <T> List getList(String path, T def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static String getString(String path, String def) {
        config.addDefault(path, def);
        return config.getString(path, config.getString(path));
    }

    private static double getDouble(String path, double def) {
        config.addDefault(path, def);
        return config.getDouble(path, config.getDouble(path));
    }
}

