/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.entity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1528;
import net.minecraft.class_1531;
import net.minecraft.class_1536;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1668;
import net.minecraft.class_1670;
import net.minecraft.class_1671;
import net.minecraft.class_1673;
import net.minecraft.class_1674;
import net.minecraft.class_1677;
import net.minecraft.class_1678;
import net.minecraft.class_1679;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1682;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1685;
import net.minecraft.class_1686;
import net.minecraft.class_1687;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import org.apache.commons.lang3.Validate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftSound;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_20_R1.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, class_1309 entity) {
        super(server, (class_1297)entity);
        if (entity instanceof class_1308 || entity instanceof class_1531) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    @Override
    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().method_6032()), this.getMaxHealth());
    }

    @Override
    public void setHealth(double health) {
        if ((health = (double)((float)health)) < 0.0 || health > this.getMaxHealth()) {
            throw new IllegalArgumentException("Health must be between 0 and " + this.getMaxHealth() + "(" + health + ")");
        }
        if (this.getHandle().bridge$generation() && health == 0.0) {
            this.getHandle().method_31472();
            return;
        }
        this.getHandle().method_6033((float)health);
        if (health == 0.0) {
            this.getHandle().method_6078(this.getHandle().method_48923().method_48830());
        }
    }

    @Override
    public double getAbsorptionAmount() {
        return this.getHandle().method_6067();
    }

    @Override
    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().method_6073((float)amount);
    }

    @Override
    public double getMaxHealth() {
        return this.getHandle().method_6063();
    }

    @Override
    public void setMaxHealth(double amount) {
        Validate.isTrue((amount > 0.0 ? 1 : 0) != 0, (String)"Max health must be greater than 0", (Object[])new Object[0]);
        this.getHandle().method_5996(class_5134.field_23716).method_6192(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    @Override
    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().method_5996(class_5134.field_23716).method_6198().method_6169());
    }

    @Override
    public double getEyeHeight() {
        return this.getHandle().method_5751();
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator(this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (transparent.contains(material = block.getType())) continue;
            break;
        }
        return blocks;
    }

    @Override
    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    @Override
    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    @Override
    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    @Override
    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    @Override
    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    @Override
    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    @Override
    public int getRemainingAir() {
        return this.getHandle().method_5669();
    }

    @Override
    public void setRemainingAir(int ticks) {
        this.getHandle().method_5855(ticks);
    }

    @Override
    public int getMaximumAir() {
        return this.getHandle().bridge$maxAirTicks();
    }

    @Override
    public void setMaximumAir(int ticks) {
        this.getHandle().banner$setMaxAirTicks(ticks);
    }

    @Override
    public int getArrowCooldown() {
        return this.getHandle().field_6218;
    }

    @Override
    public void setArrowCooldown(int ticks) {
        this.getHandle().field_6218 = ticks;
    }

    @Override
    public int getArrowsInBody() {
        return this.getHandle().method_6022();
    }

    @Override
    public void setArrowsInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        this.getHandle().method_5841().method_12778(class_1309.field_6219, (Object)count);
    }

    @Override
    public void damage(double amount) {
        this.damage(amount, null);
    }

    @Override
    public void damage(double amount, Entity source) {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        class_1282 reason = this.getHandle().method_48923().method_48830();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().method_48923().method_48802(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().method_48923().method_48812(((CraftLivingEntity)source).getHandle());
        }
        this.entity.method_5643(reason, (float)amount);
    }

    @Override
    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    @Override
    public int getMaximumNoDamageTicks() {
        return this.getHandle().field_6269;
    }

    @Override
    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().field_6269 = ticks;
    }

    @Override
    public double getLastDamage() {
        return this.getHandle().field_6253;
    }

    @Override
    public void setLastDamage(double damage) {
        this.getHandle().field_6253 = (float)damage;
    }

    @Override
    public int getNoDamageTicks() {
        return this.getHandle().field_6008;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        this.getHandle().field_6008 = ticks;
    }

    public class_1309 getHandle() {
        return (class_1309)this.entity;
    }

    public void setHandle(class_1309 entity) {
        super.setHandle((class_1297)entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + "}";
    }

    @Override
    public Player getKiller() {
        return this.getHandle().field_6258 == null ? null : (Player)((Object)this.getHandle().field_6258.getBukkitEntity());
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    @Override
    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        this.getHandle().addEffect(new class_1293(class_1291.method_5569((int)effect.getType().getId()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles()), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    @Override
    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    @Override
    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().method_6059(class_1291.method_5569((int)type.getId()));
    }

    @Override
    public PotionEffect getPotionEffect(PotionEffectType type) {
        class_1293 handle = this.getHandle().method_6112(class_1291.method_5569((int)type.getId()));
        return handle == null ? null : new PotionEffect(PotionEffectType.getById(class_1291.method_5554((class_1291)handle.method_5579())), handle.method_5584(), handle.method_5578(), handle.method_5591(), handle.method_5581());
    }

    @Override
    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(class_1291.method_5569((int)type.getId()), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    @Override
    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (class_1293 handle : this.getHandle().field_6280.values()) {
            effects.add(new PotionEffect(PotionEffectType.getById(class_1291.method_5554((class_1291)handle.method_5579())), handle.method_5584(), handle.method_5578(), handle.method_5591(), handle.method_5581()));
        }
        return effects;
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        class_3218 world = ((CraftWorld)this.getWorld()).getHandle();
        Object launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new class_1680((class_1937)world, this.getHandle());
            ((class_1682)launch).method_24919((class_1297)this.getHandle(), this.getHandle().method_36455(), this.getHandle().method_36454(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new class_1681((class_1937)world, this.getHandle());
            ((class_1682)launch).method_24919((class_1297)this.getHandle(), this.getHandle().method_36455(), this.getHandle().method_36454(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new class_1684((class_1937)world, this.getHandle());
            ((class_1682)launch).method_24919((class_1297)this.getHandle(), this.getHandle().method_36455(), this.getHandle().method_36454(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new class_1667((class_1937)world, this.getHandle());
                ((class_1667)launch).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new class_1679((class_1937)world, this.getHandle()) : (Trident.class.isAssignableFrom(projectile) ? new class_1685((class_1937)world, this.getHandle(), new class_1799((class_1935)class_1802.field_8547)) : new class_1667((class_1937)world, this.getHandle()));
            }
            ((class_1665)launch).method_24919((class_1297)this.getHandle(), this.getHandle().method_36455(), this.getHandle().method_36454(), 0.0f, 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new class_1686((class_1937)world, this.getHandle());
                ((class_1686)launch).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new class_1686((class_1937)world, this.getHandle());
                ((class_1686)launch).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
            ((class_1682)launch).method_24919((class_1297)this.getHandle(), this.getHandle().method_36455(), this.getHandle().method_36454(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new class_1683((class_1937)world, this.getHandle());
            ((class_1682)launch).method_24919((class_1297)this.getHandle(), this.getHandle().method_36455(), this.getHandle().method_36454(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof class_1657) {
            launch = new class_1536((class_1657)this.getHandle(), (class_1937)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            launch = SmallFireball.class.isAssignableFrom(projectile) ? new class_1677((class_1937)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (WitherSkull.class.isAssignableFrom(projectile) ? new class_1687((class_1937)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (DragonFireball.class.isAssignableFrom(projectile) ? new class_1670((class_1937)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : new class_1674((class_1937)world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ(), 1)));
            ((class_1668)launch).banner$setProjectileSource((ProjectileSource)this);
            launch.method_5808(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = class_1299.field_6124.method_5883((class_1937)world);
            ((class_1673)launch).method_7432((class_1297)this.getHandle());
            ((class_1673)launch).method_7485(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.method_5808(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new class_1678((class_1937)world, this.getHandle(), null, null);
            launch.method_5808(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new class_1671((class_1937)world, class_1799.field_8037, this.getHandle());
            launch.method_5808(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported", (Object[])new Object[0]);
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.method_8649((class_1297)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }

    @Override
    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    @Override
    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().method_6057(((CraftEntity)other).getHandle());
    }

    @Override
    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof class_1308 && !((class_1308)this.getHandle()).method_5947();
    }

    @Override
    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof class_1308) {
            ((class_1308)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    @Override
    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    @Override
    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof class_1308) {
            ((class_1308)this.getHandle()).method_5952(pickup);
        } else {
            this.getHandle().banner$setBukkitPickUpLoot(pickup);
        }
    }

    @Override
    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof class_1308) {
            return ((class_1308)this.getHandle()).method_5936();
        }
        return this.getHandle().bridge$bukkitPickUpLoot();
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    @Override
    public boolean isLeashed() {
        if (!(this.getHandle() instanceof class_1308)) {
            return false;
        }
        return ((class_1308)this.getHandle()).method_5933() != null;
    }

    @Override
    public Entity getLeashHolder() throws IllegalStateException {
        if (!this.isLeashed()) {
            throw new IllegalStateException("Entity not leashed");
        }
        return ((class_1308)this.getHandle()).method_5933().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((class_1308)this.getHandle()).method_5932(true, false);
        return true;
    }

    @Override
    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().bridge$generation() || this.getHandle() instanceof class_1528 || !(this.getHandle() instanceof class_1308)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((class_1308)this.getHandle()).method_5954(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    @Override
    public boolean isGliding() {
        return this.getHandle().method_5795(7);
    }

    @Override
    public void setGliding(boolean gliding) {
        this.getHandle().method_5729(7, gliding);
    }

    @Override
    public boolean isSwimming() {
        return this.getHandle().method_5681();
    }

    @Override
    public void setSwimming(boolean swimming) {
        this.getHandle().method_5796(swimming);
    }

    @Override
    public boolean isRiptiding() {
        return this.getHandle().method_6123();
    }

    @Override
    public boolean isSleeping() {
        return this.getHandle().method_6113();
    }

    @Override
    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().method_6101();
    }

    @Override
    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().bridge$craftAttributes().getAttribute(attribute);
    }

    @Override
    public void setAI(boolean ai) {
        if (this.getHandle() instanceof class_1308) {
            ((class_1308)this.getHandle()).method_5977(!ai);
        }
    }

    @Override
    public boolean hasAI() {
        return this.getHandle() instanceof class_1308 ? !((class_1308)this.getHandle()).method_5987() : false;
    }

    @Override
    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof class_1657) {
            ((class_1657)this.getHandle()).method_7324(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().method_6121(((CraftEntity)target).getHandle());
        }
    }

    @Override
    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().method_23667(class_1268.field_5808, true);
    }

    @Override
    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().bridge$generation() ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().method_23667(class_1268.field_5810, true);
    }

    @Override
    public void setCollidable(boolean collidable) {
        this.getHandle().banner$setCollides(collidable);
    }

    @Override
    public boolean isCollidable() {
        return this.getHandle().bridge$collides();
    }

    @Override
    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().bridge$collidableExemptions();
    }

    @Override
    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().method_18868().method_18904(CraftMemoryKey.fromMemoryKey(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    @Override
    public <T> void setMemory(MemoryKey<T> memoryKey, T t) {
        this.getHandle().method_18868().method_18878(CraftMemoryKey.fromMemoryKey(memoryKey), CraftMemoryMapper.toNms(t));
    }

    @Override
    public Sound getHurtSound() {
        class_3414 sound = this.getHandle().getHurtSound0(this.getHandle().method_48923().method_48830());
        return sound != null ? CraftSound.getBukkit(sound) : null;
    }

    @Override
    public Sound getDeathSound() {
        class_3414 sound = this.getHandle().getDeathSound0();
        return sound != null ? CraftSound.getBukkit(sound) : null;
    }

    @Override
    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.getBukkit(this.getHandle().getFallDamageSound0(fallHeight));
    }

    @Override
    public Sound getFallDamageSoundSmall() {
        return CraftSound.getBukkit(this.getHandle().method_39760().comp_301());
    }

    @Override
    public Sound getFallDamageSoundBig() {
        return CraftSound.getBukkit(this.getHandle().method_39760().comp_302());
    }

    @Override
    public Sound getDrinkingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.getBukkit(this.getHandle().getDrinkingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    @Override
    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.getBukkit(this.getHandle().getEatingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    @Override
    public boolean canBreatheUnderwater() {
        return this.getHandle().method_6094();
    }

    @Override
    public EntityCategory getCategory() {
        class_1310 type = this.getHandle().method_6046();
        if (type == class_1310.field_6290) {
            return EntityCategory.NONE;
        }
        if (type == class_1310.field_6289) {
            return EntityCategory.UNDEAD;
        }
        if (type == class_1310.field_6293) {
            return EntityCategory.ARTHROPOD;
        }
        if (type == class_1310.field_6291) {
            return EntityCategory.ILLAGER;
        }
        if (type == class_1310.field_6292) {
            return EntityCategory.WATER;
        }
        throw new UnsupportedOperationException("Unsupported monster type: " + type + ". This is a bug, report this to Spigot.");
    }

    @Override
    public boolean isInvisible() {
        return this.getHandle().method_5767();
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.getHandle().banner$setPersistentInvisibility(invisible);
        this.getHandle().method_5729(5, invisible);
    }
}

