/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.generator;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2826;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.material.MaterialData;

@Deprecated
public final class OldCraftChunkData
implements ChunkGenerator.ChunkData {
    private final int minHeight;
    private final int maxHeight;
    private final class_2378<class_1959> biomes;
    private final class_2826[] sections;
    private Set<class_2338> tiles;
    private final Set<class_2338> lights = new HashSet<class_2338>();

    public OldCraftChunkData(int minHeight, int maxHeight, class_2378<class_1959> biomes) {
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
        this.biomes = biomes;
        this.sections = new class_2826[(maxHeight - 1 >> 4) + 1 - (minHeight >> 4)];
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        throw new UnsupportedOperationException("Unsupported, in older chunk generator api");
    }

    @Override
    public void setBlock(int x, int y, int z, Material material) {
        this.setBlock(x, y, z, material.createBlockData());
    }

    @Override
    public void setBlock(int x, int y, int z, MaterialData material) {
        this.setBlock(x, y, z, CraftMagicNumbers.getBlock(material));
    }

    @Override
    public void setBlock(int x, int y, int z, BlockData blockData) {
        this.setBlock(x, y, z, ((CraftBlockData)blockData).getState());
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, Material material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, material.createBlockData());
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, MaterialData material) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, CraftMagicNumbers.getBlock(material));
    }

    @Override
    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, BlockData blockData) {
        this.setRegion(xMin, yMin, zMin, xMax, yMax, zMax, ((CraftBlockData)blockData).getState());
    }

    @Override
    public Material getType(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z).method_26204());
    }

    @Override
    public MaterialData getTypeAndData(int x, int y, int z) {
        return CraftMagicNumbers.getMaterial(this.getTypeId(x, y, z));
    }

    @Override
    public BlockData getBlockData(int x, int y, int z) {
        return CraftBlockData.fromData(this.getTypeId(x, y, z));
    }

    public void setRegion(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, class_2680 type) {
        if (xMin > 15 || yMin >= this.maxHeight || zMin > 15) {
            return;
        }
        if (xMin < 0) {
            xMin = 0;
        }
        if (yMin < this.minHeight) {
            yMin = this.minHeight;
        }
        if (zMin < 0) {
            zMin = 0;
        }
        if (xMax > 16) {
            xMax = 16;
        }
        if (yMax > this.maxHeight) {
            yMax = this.maxHeight;
        }
        if (zMax > 16) {
            zMax = 16;
        }
        if (xMin >= xMax || yMin >= yMax || zMin >= zMax) {
            return;
        }
        for (int y = yMin; y < yMax; ++y) {
            class_2826 section = this.getChunkSection(y, true);
            int offsetBase = y & 0xF;
            for (int x = xMin; x < xMax; ++x) {
                for (int z = zMin; z < zMax; ++z) {
                    section.method_16675(x, offsetBase, z, type);
                }
            }
        }
    }

    public class_2680 getTypeId(int x, int y, int z) {
        if (x != (x & 0xF) || y < this.minHeight || y >= this.maxHeight || z != (z & 0xF)) {
            return class_2246.field_10124.method_9564();
        }
        class_2826 section = this.getChunkSection(y, false);
        if (section == null) {
            return class_2246.field_10124.method_9564();
        }
        return section.method_12254(x, y & 0xF, z);
    }

    @Override
    public byte getData(int x, int y, int z) {
        return CraftMagicNumbers.toLegacyData(this.getTypeId(x, y, z));
    }

    private void setBlock(int x, int y, int z, class_2680 type) {
        if (x != (x & 0xF) || y < this.minHeight || y >= this.maxHeight || z != (z & 0xF)) {
            return;
        }
        class_2826 section = this.getChunkSection(y, true);
        section.method_16675(x, y & 0xF, z, type);
        if (type.method_26213() > 0) {
            this.lights.add(class_2338.method_49637((double)x, (double)y, (double)z));
        } else {
            this.lights.remove(class_2338.method_49637((double)x, (double)y, (double)z));
        }
        if (type.method_31709()) {
            if (this.tiles == null) {
                this.tiles = new HashSet<class_2338>();
            }
            this.tiles.add(class_2338.method_49637((double)x, (double)y, (double)z));
        }
    }

    private class_2826 getChunkSection(int y, boolean create) {
        int offset = y - this.minHeight >> 4;
        class_2826 section = this.sections[offset];
        if (!create || section == null) {
            // empty if block
        }
        return section;
    }

    class_2826[] getRawChunkData() {
        return this.sections;
    }

    Set<class_2338> getTiles() {
        return this.tiles;
    }

    Set<class_2338> getLights() {
        return this.lights;
    }
}

