/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2735;
import net.minecraft.class_3222;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class CraftInventoryPlayer
extends CraftInventory
implements PlayerInventory,
EntityEquipment {
    public CraftInventoryPlayer(class_1661 inventory) {
        super((class_1263)inventory);
    }

    public class_1661 getInventory() {
        return (class_1661)this.inventory;
    }

    @Override
    public ItemStack[] getStorageContents() {
        return this.asCraftMirror((List<class_1799>)this.getInventory().field_7547);
    }

    @Override
    public ItemStack getItemInMainHand() {
        return CraftItemStack.asCraftMirror(this.getInventory().method_7391());
    }

    @Override
    public void setItemInMainHand(ItemStack item) {
        this.setItem(this.getHeldItemSlot(), item);
    }

    @Override
    public void setItemInMainHand(ItemStack item, boolean silent) {
        this.setItemInMainHand(item);
    }

    @Override
    public ItemStack getItemInOffHand() {
        return CraftItemStack.asCraftMirror((class_1799)this.getInventory().field_7544.get(0));
    }

    @Override
    public void setItemInOffHand(ItemStack item) {
        ItemStack[] extra = this.getExtraContents();
        extra[0] = item;
        this.setExtraContents(extra);
    }

    @Override
    public void setItemInOffHand(ItemStack item, boolean silent) {
        this.setItemInOffHand(item);
    }

    @Override
    public ItemStack getItemInHand() {
        return this.getItemInMainHand();
    }

    @Override
    public void setItemInHand(ItemStack stack) {
        this.setItemInMainHand(stack);
    }

    @Override
    public void setItem(int index, ItemStack item) {
        super.setItem(index, item);
        if (this.getHolder() == null) {
            return;
        }
        class_3222 player = ((CraftPlayer)this.getHolder()).getHandle();
        if (player.field_13987 == null) {
            return;
        }
        if (index < class_1661.method_7368()) {
            index += 36;
        } else if (index > 39) {
            index += 5;
        } else if (index > 35) {
            index = 8 - (index - 36);
        }
        player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), index, CraftItemStack.asNMSCopy(item)));
    }

    @Override
    public void setItem(EquipmentSlot slot, ItemStack item) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                this.setItemInMainHand(item);
                break;
            }
            case OFF_HAND: {
                this.setItemInOffHand(item);
                break;
            }
            case FEET: {
                this.setBoots(item);
                break;
            }
            case LEGS: {
                this.setLeggings(item);
                break;
            }
            case CHEST: {
                this.setChestplate(item);
                break;
            }
            case HEAD: {
                this.setHelmet(item);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not implemented. This is a bug");
            }
        }
    }

    @Override
    public void setItem(EquipmentSlot slot, ItemStack item, boolean silent) {
        this.setItem(slot, item);
    }

    @Override
    public ItemStack getItem(EquipmentSlot slot) {
        Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"slot must not be null");
        switch (slot) {
            case HAND: {
                return this.getItemInMainHand();
            }
            case OFF_HAND: {
                return this.getItemInOffHand();
            }
            case FEET: {
                return this.getBoots();
            }
            case LEGS: {
                return this.getLeggings();
            }
            case CHEST: {
                return this.getChestplate();
            }
            case HEAD: {
                return this.getHelmet();
            }
        }
        throw new IllegalArgumentException("Not implemented. This is a bug");
    }

    @Override
    public int getHeldItemSlot() {
        return this.getInventory().field_7545;
    }

    @Override
    public void setHeldItemSlot(int slot) {
        Validate.isTrue((slot >= 0 && slot < class_1661.method_7368() ? 1 : 0) != 0, (String)"Slot is not between 0 and 8 inclusive", (Object[])new Object[0]);
        this.getInventory().field_7545 = slot;
        ((CraftPlayer)this.getHolder()).getHandle().field_13987.method_14364((class_2596)new class_2735(slot));
    }

    @Override
    public ItemStack getHelmet() {
        return this.getItem(this.getSize() - 2);
    }

    @Override
    public ItemStack getChestplate() {
        return this.getItem(this.getSize() - 3);
    }

    @Override
    public ItemStack getLeggings() {
        return this.getItem(this.getSize() - 4);
    }

    @Override
    public ItemStack getBoots() {
        return this.getItem(this.getSize() - 5);
    }

    @Override
    public void setHelmet(ItemStack helmet) {
        this.setItem(this.getSize() - 2, helmet);
    }

    @Override
    public void setHelmet(ItemStack helmet, boolean silent) {
        this.setHelmet(helmet);
    }

    @Override
    public void setChestplate(ItemStack chestplate) {
        this.setItem(this.getSize() - 3, chestplate);
    }

    @Override
    public void setChestplate(ItemStack chestplate, boolean silent) {
        this.setChestplate(chestplate);
    }

    @Override
    public void setLeggings(ItemStack leggings) {
        this.setItem(this.getSize() - 4, leggings);
    }

    @Override
    public void setLeggings(ItemStack leggings, boolean silent) {
        this.setLeggings(leggings);
    }

    @Override
    public void setBoots(ItemStack boots) {
        this.setItem(this.getSize() - 5, boots);
    }

    @Override
    public void setBoots(ItemStack boots, boolean silent) {
        this.setBoots(boots);
    }

    @Override
    public ItemStack[] getArmorContents() {
        return this.asCraftMirror((List<class_1799>)this.getInventory().field_7548);
    }

    private void setSlots(ItemStack[] items, int baseSlot, int length) {
        if (items == null) {
            items = new ItemStack[length];
        }
        Preconditions.checkArgument((items.length <= length ? 1 : 0) != 0, (String)"items.length must be < %s", (int)length);
        for (int i = 0; i < length; ++i) {
            if (i >= items.length) {
                this.setItem(baseSlot + i, null);
                continue;
            }
            this.setItem(baseSlot + i, items[i]);
        }
    }

    @Override
    public void setStorageContents(ItemStack[] items) throws IllegalArgumentException {
        this.setSlots(items, 0, this.getInventory().field_7547.size());
    }

    @Override
    public void setArmorContents(ItemStack[] items) {
        this.setSlots(items, this.getInventory().field_7547.size(), this.getInventory().field_7548.size());
    }

    @Override
    public ItemStack[] getExtraContents() {
        return this.asCraftMirror((List<class_1799>)this.getInventory().field_7544);
    }

    @Override
    public void setExtraContents(ItemStack[] items) {
        this.setSlots(items, this.getInventory().field_7547.size() + this.getInventory().field_7548.size(), this.getInventory().field_7544.size());
    }

    @Override
    public HumanEntity getHolder() {
        return (HumanEntity)this.inventory.getOwner();
    }

    @Override
    public float getItemInHandDropChance() {
        return this.getItemInMainHandDropChance();
    }

    @Override
    public void setItemInHandDropChance(float chance) {
        this.setItemInMainHandDropChance(chance);
    }

    @Override
    public float getItemInMainHandDropChance() {
        return 1.0f;
    }

    @Override
    public void setItemInMainHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    @Override
    public float getItemInOffHandDropChance() {
        return 1.0f;
    }

    @Override
    public void setItemInOffHandDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    @Override
    public float getHelmetDropChance() {
        return 1.0f;
    }

    @Override
    public void setHelmetDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    @Override
    public float getChestplateDropChance() {
        return 1.0f;
    }

    @Override
    public void setChestplateDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    @Override
    public float getLeggingsDropChance() {
        return 1.0f;
    }

    @Override
    public void setLeggingsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }

    @Override
    public float getBootsDropChance() {
        return 1.0f;
    }

    @Override
    public void setBootsDropChance(float chance) {
        throw new UnsupportedOperationException("Cannot set drop chance for PlayerInventory");
    }
}

