/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.legacy;

import com.google.common.base.Preconditions;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1181;
import net.minecraft.class_1208;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2966;
import net.minecraft.class_3551;
import net.minecraft.class_3580;
import net.minecraft.class_7923;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.entity.EntityType;
import org.bukkit.material.MaterialData;

@Deprecated
public final class CraftLegacy {
    private static final Map<Byte, Material> SPAWN_EGGS = new HashMap<Byte, Material>();
    private static final Set<String> whitelistedStates = new HashSet<String>(Arrays.asList("explode", "check_decay", "decayable", "facing"));
    private static final Map<MaterialData, class_1792> materialToItem = new HashMap<MaterialData, class_1792>(16384);
    private static final Map<class_1792, MaterialData> itemToMaterial = new HashMap<class_1792, MaterialData>(1024);
    private static final Map<MaterialData, class_2680> materialToData = new HashMap<MaterialData, class_2680>(4096);
    private static final Map<class_2680, MaterialData> dataToMaterial = new HashMap<class_2680, MaterialData>(4096);
    private static final Map<MaterialData, class_2248> materialToBlock = new HashMap<MaterialData, class_2248>(4096);
    private static final Map<class_2248, MaterialData> blockToMaterial = new HashMap<class_2248, MaterialData>(1024);

    private CraftLegacy() {
    }

    public static Material toLegacy(Material material) {
        if (material == null || material.isLegacy()) {
            return material;
        }
        return CraftLegacy.toLegacyData(material).getItemType();
    }

    public static MaterialData toLegacyData(Material material) {
        MaterialData mappedData;
        Preconditions.checkArgument((!material.isLegacy() ? 1 : 0) != 0, (Object)"toLegacy on legacy Material");
        if (material.isBlock()) {
            class_2248 block = CraftMagicNumbers.getBlock(material);
            class_2680 blockData = block.method_9564();
            mappedData = dataToMaterial.get(blockData);
            if (mappedData == null && (mappedData = blockToMaterial.get(block)) == null) {
                mappedData = itemToMaterial.get(block.method_8389());
            }
        } else {
            class_1792 item = CraftMagicNumbers.getItem(material);
            mappedData = itemToMaterial.get(item);
        }
        return mappedData == null ? new MaterialData(Material.LEGACY_AIR) : mappedData;
    }

    public static class_2680 fromLegacyData(Material material, byte data) {
        Preconditions.checkArgument((boolean)material.isLegacy(), (Object)"fromLegacyData on modern Material");
        MaterialData materialData = new MaterialData(material, data);
        class_2680 converted = materialToData.get(materialData);
        if (converted != null) {
            return converted;
        }
        class_2248 convertedBlock = materialToBlock.get(materialData);
        if (convertedBlock != null) {
            return convertedBlock.method_9564();
        }
        return class_2246.field_10124.method_9564();
    }

    public static class_1792 fromLegacyData(Material material, short data) {
        Preconditions.checkArgument((boolean)material.isLegacy(), (Object)"fromLegacyData on modern Material. Did you forget to define a modern (1.13+) api-version in your plugin.yml?");
        MaterialData materialData = new MaterialData(material, (byte)data);
        class_1792 convertedItem = materialToItem.get(materialData);
        if (convertedItem != null) {
            return convertedItem;
        }
        if (material.isBlock()) {
            class_2680 converted = materialToData.get(materialData);
            if (converted != null) {
                return converted.method_26204().method_8389();
            }
            class_2248 convertedBlock = materialToBlock.get(materialData);
            if (convertedBlock != null) {
                return convertedBlock.method_8389();
            }
        }
        return class_1802.field_8162;
    }

    public static byte toLegacyData(class_2680 blockData) {
        return CraftLegacy.toLegacy(blockData).getData();
    }

    public static Material toLegacyMaterial(class_2680 blockData) {
        return CraftLegacy.toLegacy(blockData).getItemType();
    }

    public static MaterialData toLegacy(class_2680 blockData) {
        MaterialData mappedData = dataToMaterial.get(blockData);
        if (mappedData == null) {
            mappedData = blockToMaterial.get(blockData.method_26204());
        }
        return mappedData == null ? new MaterialData(Material.LEGACY_AIR) : mappedData;
    }

    public static Material fromLegacy(Material material) {
        if (material == null || !material.isLegacy()) {
            return material;
        }
        return CraftLegacy.fromLegacy(new MaterialData(material));
    }

    public static Material fromLegacy(MaterialData materialData) {
        return CraftLegacy.fromLegacy(materialData, false);
    }

    public static Material fromLegacy(MaterialData materialData, boolean itemPriority) {
        class_1792 item;
        Material material = materialData.getItemType();
        if (material == null || !material.isLegacy()) {
            return material;
        }
        Material mappedData = null;
        if (itemPriority && (item = materialToItem.get(materialData)) != null) {
            mappedData = CraftMagicNumbers.getMaterial(item);
        }
        if (mappedData == null && material.isBlock()) {
            class_2248 block;
            class_2680 iblock = materialToData.get(materialData);
            if (iblock != null) {
                mappedData = CraftMagicNumbers.getMaterial(iblock.method_26204());
            }
            if (mappedData == null && (block = materialToBlock.get(materialData)) != null) {
                mappedData = CraftMagicNumbers.getMaterial(block);
            }
        }
        if (!itemPriority && mappedData == null && (item = materialToItem.get(materialData)) != null) {
            mappedData = CraftMagicNumbers.getMaterial(item);
        }
        return mappedData == null ? Material.AIR : mappedData;
    }

    public static Material[] values() {
        Material[] values = Material.values();
        return Arrays.copyOfRange(values, Material.LEGACY_AIR.ordinal(), values.length);
    }

    public static Material valueOf(String name) {
        return name.startsWith("LEGACY_") ? Material.valueOf(name) : Material.valueOf("LEGACY_" + name);
    }

    public static Material getMaterial(String name) {
        return name.startsWith("LEGACY_") ? Material.getMaterial(name) : Material.getMaterial("LEGACY_" + name);
    }

    public static Material matchMaterial(String name) {
        return name.startsWith("LEGACY_") ? Material.matchMaterial(name) : Material.matchMaterial("LEGACY_" + name);
    }

    public static int ordinal(Material material) {
        Preconditions.checkArgument((boolean)material.isLegacy(), (Object)"ordinal on modern Material");
        return material.ordinal() - Material.LEGACY_AIR.ordinal();
    }

    public static String name(Material material) {
        return material.name().substring("LEGACY_".length());
    }

    public static String toString(Material material) {
        return CraftLegacy.name(material);
    }

    public static void init() {
    }

    public static void main(String[] args) {
        System.err.println("");
    }

    static {
        System.err.println("Initializing Legacy Material Support. Unless you have legacy plugins and/or data this is a bug!");
        if (BukkitExtraConstants.getServer() != null && BukkitExtraConstants.getServer().isDebugging()) {
            new Exception().printStackTrace();
        }
        SPAWN_EGGS.put((byte)0, Material.PIG_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.BAT.getTypeId(), Material.BAT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.BLAZE.getTypeId(), Material.BLAZE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.CAVE_SPIDER.getTypeId(), Material.CAVE_SPIDER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.CHICKEN.getTypeId(), Material.CHICKEN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.COD.getTypeId(), Material.COD_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.COW.getTypeId(), Material.COW_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.CREEPER.getTypeId(), Material.CREEPER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.DOLPHIN.getTypeId(), Material.DOLPHIN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.DONKEY.getTypeId(), Material.DONKEY_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ELDER_GUARDIAN.getTypeId(), Material.ELDER_GUARDIAN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ENDERMAN.getTypeId(), Material.ENDERMAN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ENDERMITE.getTypeId(), Material.ENDERMITE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.EVOKER.getTypeId(), Material.EVOKER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.GHAST.getTypeId(), Material.GHAST_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.GUARDIAN.getTypeId(), Material.GUARDIAN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.HORSE.getTypeId(), Material.HORSE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.HUSK.getTypeId(), Material.HUSK_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.LLAMA.getTypeId(), Material.LLAMA_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.MAGMA_CUBE.getTypeId(), Material.MAGMA_CUBE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.MUSHROOM_COW.getTypeId(), Material.MOOSHROOM_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.MULE.getTypeId(), Material.MULE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.OCELOT.getTypeId(), Material.OCELOT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PARROT.getTypeId(), Material.PARROT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PIG.getTypeId(), Material.PIG_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PHANTOM.getTypeId(), Material.PHANTOM_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.POLAR_BEAR.getTypeId(), Material.POLAR_BEAR_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.PUFFERFISH.getTypeId(), Material.PUFFERFISH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.RABBIT.getTypeId(), Material.RABBIT_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SALMON.getTypeId(), Material.SALMON_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SHEEP.getTypeId(), Material.SHEEP_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SHULKER.getTypeId(), Material.SHULKER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SILVERFISH.getTypeId(), Material.SILVERFISH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SKELETON.getTypeId(), Material.SKELETON_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SKELETON_HORSE.getTypeId(), Material.SKELETON_HORSE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SLIME.getTypeId(), Material.SLIME_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SPIDER.getTypeId(), Material.SPIDER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.SQUID.getTypeId(), Material.SQUID_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.STRAY.getTypeId(), Material.STRAY_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.TROPICAL_FISH.getTypeId(), Material.TROPICAL_FISH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.TURTLE.getTypeId(), Material.TURTLE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.VEX.getTypeId(), Material.VEX_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.VILLAGER.getTypeId(), Material.VILLAGER_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.VINDICATOR.getTypeId(), Material.VINDICATOR_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.WITCH.getTypeId(), Material.WITCH_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.WITHER_SKELETON.getTypeId(), Material.WITHER_SKELETON_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.WOLF.getTypeId(), Material.WOLF_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ZOMBIE.getTypeId(), Material.ZOMBIE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ZOMBIE_HORSE.getTypeId(), Material.ZOMBIE_HORSE_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ZOMBIFIED_PIGLIN.getTypeId(), Material.ZOMBIFIED_PIGLIN_SPAWN_EGG);
        SPAWN_EGGS.put((byte)EntityType.ZOMBIE_VILLAGER.getTypeId(), Material.ZOMBIE_VILLAGER_SPAWN_EGG);
        class_155.method_36208();
        class_2966.method_12851();
        for (Material material : Material.values()) {
            byte maxData;
            if (!material.isLegacy()) continue;
            if (material.isBlock()) {
                for (byte data = 0; data < 16; data = (byte)(data + 1)) {
                    String name;
                    class_2248 block;
                    MaterialData matData = new MaterialData(material, data);
                    Dynamic blockTag = class_3580.method_15594((int)(material.getId() << 4 | data));
                    blockTag = class_3551.method_15450().update(class_1208.field_5720, blockTag, 100, CraftMagicNumbers.INSTANCE.getDataVersion());
                    if (blockTag.get("Name").asString("").contains("%%FILTER_ME%%") || (block = (class_2248)class_7923.field_41175.method_10223(new class_2960(name = blockTag.get("Name").asString("")))) == null) continue;
                    class_2680 blockData = block.method_9564();
                    class_2689 states = block.method_9595();
                    Optional propMap = blockTag.getElement("Properties").result();
                    if (propMap.isPresent()) {
                        class_2487 properties = (class_2487)propMap.get();
                        for (String dataKey : properties.method_10541()) {
                            class_2769 state = states.method_11663(dataKey);
                            if (state == null) {
                                if (whitelistedStates.contains(dataKey)) continue;
                                throw new IllegalStateException("No state for " + dataKey);
                            }
                            Preconditions.checkState((!properties.method_10558(dataKey).isEmpty() ? 1 : 0) != 0, (Object)"Empty data string");
                            Optional opt = state.method_11900(properties.method_10558(dataKey));
                            if (!opt.isPresent()) {
                                throw new IllegalStateException("No state value " + properties.method_10558(dataKey) + " for " + dataKey);
                            }
                            blockData = (class_2680)blockData.method_11657(state, (Comparable)opt.get());
                        }
                    }
                    if (block == class_2246.field_10124) continue;
                    materialToData.put(matData, blockData);
                    if (!dataToMaterial.containsKey(blockData)) {
                        dataToMaterial.put(blockData, matData);
                    }
                    materialToBlock.put(matData, block);
                    if (blockToMaterial.containsKey(block)) continue;
                    blockToMaterial.put(block, matData);
                }
            }
            byte by = maxData = material.getMaxDurability() == 0 ? (byte)16 : 1;
            if (material == Material.LEGACY_MONSTER_EGG) {
                maxData = 121;
            }
            for (byte data = 0; data < maxData; data = (byte)((byte)(data + 1))) {
                class_1792 newMaterial;
                if (material == Material.LEGACY_MONSTER_EGG || class_1181.method_5018((int)material.getId()) == null) continue;
                MaterialData matData = new MaterialData(material, data);
                class_2487 stack = new class_2487();
                stack.method_10569("id", material.getId());
                stack.method_10575("Damage", (short)data);
                Dynamic converted = class_3551.method_15450().update(class_1208.field_5712, new Dynamic((DynamicOps)class_2509.field_11560, (Object)stack), -1, CraftMagicNumbers.INSTANCE.getDataVersion());
                String newId = converted.get("id").asString("");
                if (newId.equals("minecraft:spawn_egg")) {
                    newId = "minecraft:pig_spawn_egg";
                }
                if ((newMaterial = (class_1792)class_7923.field_41178.method_10223(new class_2960(newId))) == class_1802.field_8162) continue;
                materialToItem.put(matData, newMaterial);
                if (itemToMaterial.containsKey(newMaterial)) continue;
                itemToMaterial.put(newMaterial, matData);
            }
            for (Map.Entry<Byte, Material> entry : SPAWN_EGGS.entrySet()) {
                MaterialData matData = new MaterialData(Material.LEGACY_MONSTER_EGG, entry.getKey());
                class_1792 newMaterial = CraftMagicNumbers.getItem(entry.getValue());
                materialToItem.put(matData, newMaterial);
                itemToMaterial.put(newMaterial, matData);
            }
        }
    }
}

