/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.map;

import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.class_22;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.map.CraftMapCanvas;
import org.bukkit.craftbukkit.v1_20_R1.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_20_R1.map.RenderData;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public final class CraftMapView
implements MapView {
    private final Map<CraftPlayer, RenderData> renderCache = new HashMap<CraftPlayer, RenderData>();
    private final List<MapRenderer> renderers = new ArrayList<MapRenderer>();
    private final Map<MapRenderer, Map<CraftPlayer, CraftMapCanvas>> canvases = new HashMap<MapRenderer, Map<CraftPlayer, CraftMapCanvas>>();
    protected final class_22 worldMap;

    public CraftMapView(class_22 worldMap) {
        this.worldMap = worldMap;
        this.addRenderer(new CraftMapRenderer(this, worldMap));
    }

    @Override
    public int getId() {
        String text = this.worldMap.bridge$id();
        if (text.startsWith("map_")) {
            try {
                return Integer.parseInt(text.substring("map_".length()));
            }
            catch (NumberFormatException ex) {
                throw new IllegalStateException("Map has non-numeric ID");
            }
        }
        throw new IllegalStateException("Map has invalid ID");
    }

    @Override
    public boolean isVirtual() {
        return this.renderers.size() > 0 && !(this.renderers.get(0) instanceof CraftMapRenderer);
    }

    @Override
    public MapView.Scale getScale() {
        return MapView.Scale.valueOf(this.worldMap.field_119);
    }

    @Override
    public void setScale(MapView.Scale scale) {
        this.worldMap.field_119 = scale.getValue();
    }

    @Override
    public World getWorld() {
        class_5321 dimension = this.worldMap.field_118;
        class_3218 world = BukkitExtraConstants.getServer().method_3847(dimension);
        if (world != null) {
            return world.getWorld();
        }
        if (this.worldMap.bridge$uniqueId() != null) {
            return Bukkit.getServer().getWorld(this.worldMap.bridge$uniqueId());
        }
        return null;
    }

    @Override
    public void setWorld(World world) {
        this.worldMap.field_118 = ((CraftWorld)world).getHandle().method_27983();
        this.worldMap.banner$setUniqueId(world.getUID());
    }

    @Override
    public int getCenterX() {
        return this.worldMap.field_116;
    }

    @Override
    public int getCenterZ() {
        return this.worldMap.field_115;
    }

    @Override
    public void setCenterX(int x) {
        this.worldMap.field_116 = x;
    }

    @Override
    public void setCenterZ(int z) {
        this.worldMap.field_115 = z;
    }

    @Override
    public List<MapRenderer> getRenderers() {
        return new ArrayList<MapRenderer>(this.renderers);
    }

    @Override
    public void addRenderer(MapRenderer renderer) {
        if (!this.renderers.contains(renderer)) {
            this.renderers.add(renderer);
            this.canvases.put(renderer, new HashMap());
            renderer.initialize(this);
        }
    }

    @Override
    public boolean removeRenderer(MapRenderer renderer) {
        if (this.renderers.contains(renderer)) {
            this.renderers.remove(renderer);
            for (Map.Entry<CraftPlayer, CraftMapCanvas> entry : this.canvases.get(renderer).entrySet()) {
                for (int x = 0; x < 128; ++x) {
                    for (int y = 0; y < 128; ++y) {
                        entry.getValue().setPixel(x, y, (byte)-1);
                    }
                }
            }
            this.canvases.remove(renderer);
            return true;
        }
        return false;
    }

    private boolean isContextual() {
        for (MapRenderer renderer : this.renderers) {
            if (!renderer.isContextual()) continue;
            return true;
        }
        return false;
    }

    public RenderData render(CraftPlayer player) {
        boolean context = this.isContextual();
        RenderData render = this.renderCache.get(context ? player : null);
        if (render == null) {
            render = new RenderData();
            this.renderCache.put(context ? player : null, render);
        }
        if (context && this.renderCache.containsKey(null)) {
            this.renderCache.remove(null);
        }
        Arrays.fill(render.buffer, (byte)0);
        render.cursors.clear();
        Iterator<MapRenderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            int i;
            MapRenderer renderer;
            CraftMapCanvas canvas = this.canvases.get(renderer).get((renderer = iterator.next()).isContextual() ? player : null);
            if (canvas == null) {
                canvas = new CraftMapCanvas(this);
                this.canvases.get(renderer).put(renderer.isContextual() ? player : null, canvas);
            }
            canvas.setBase(render.buffer);
            try {
                renderer.render(this, canvas, player);
            }
            catch (Throwable ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Could not render map using renderer " + renderer.getClass().getName(), ex);
            }
            byte[] buf = canvas.getBuffer();
            for (i = 0; i < buf.length; ++i) {
                byte color = buf[i];
                if (color < 0 && color > -9) continue;
                render.buffer[i] = color;
            }
            for (i = 0; i < canvas.getCursors().size(); ++i) {
                render.cursors.add(canvas.getCursors().getCursor(i));
            }
        }
        return render;
    }

    @Override
    public boolean isTrackingPosition() {
        return this.worldMap.field_114;
    }

    @Override
    public void setTrackingPosition(boolean trackingPosition) {
        this.worldMap.field_114 = trackingPosition;
    }

    @Override
    public boolean isUnlimitedTracking() {
        return this.worldMap.field_113;
    }

    @Override
    public void setUnlimitedTracking(boolean unlimited) {
        this.worldMap.field_113 = unlimited;
    }

    @Override
    public boolean isLocked() {
        return this.worldMap.field_17403;
    }

    @Override
    public void setLocked(boolean locked) {
        this.worldMap.field_17403 = locked;
    }
}

