/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.projectiles;

import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1668;
import net.minecraft.class_1676;
import net.minecraft.class_1677;
import net.minecraft.class_1679;
import net.minecraft.class_1680;
import net.minecraft.class_1681;
import net.minecraft.class_1682;
import net.minecraft.class_1683;
import net.minecraft.class_1684;
import net.minecraft.class_1686;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2345;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2601;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.WitherSkull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class CraftBlockProjectileSource
implements BlockProjectileSource {
    private final class_2601 dispenserBlock;

    public CraftBlockProjectileSource(class_2601 dispenserBlock) {
        this.dispenserBlock = dispenserBlock;
    }

    @Override
    public Block getBlock() {
        return this.dispenserBlock.method_10997().getWorld().getBlockAt(this.dispenserBlock.method_11016().method_10263(), this.dispenserBlock.method_11016().method_10264(), this.dispenserBlock.method_11016().method_10260());
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    @Override
    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        Validate.isTrue((this.getBlock().getType() == Material.DISPENSER ? 1 : 0) != 0, (String)"Block is no longer dispenser", (Object[])new Object[0]);
        class_2345 isourceblock = new class_2345((class_3218)this.dispenserBlock.method_10997(), this.dispenserBlock.method_11016());
        class_2374 iposition = class_2315.method_10010((class_2342)isourceblock);
        class_2350 enumdirection = (class_2350)isourceblock.method_10120().method_11654((class_2769)class_2315.field_10918);
        class_1937 world = this.dispenserBlock.method_10997();
        class_1680 launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new class_1680(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new class_1681(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new class_1684(world, null);
            launch.method_5814(iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new class_1683(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new class_1686(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
                ((class_1686)launch).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new class_1686(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
                ((class_1686)launch).method_16940(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new class_1667(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
                ((class_1667)launch).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new class_1679(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215()) : new class_1679(world, iposition.method_10216(), iposition.method_10214(), iposition.method_10215());
            }
            ((class_1665)launch).field_7572 = class_1665.class_1666.field_7593;
            ((class_1665)launch).banner$setProjectileSource((ProjectileSource)this);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            double d0 = iposition.method_10216() + (double)((float)enumdirection.method_10148() * 0.3f);
            double d1 = iposition.method_10214() + (double)((float)enumdirection.method_10164() * 0.3f);
            double d2 = iposition.method_10215() + (double)((float)enumdirection.method_10165() * 0.3f);
            class_5819 random = world.field_9229;
            double d3 = random.method_43059() * 0.05 + (double)enumdirection.method_10148();
            double d4 = random.method_43059() * 0.05 + (double)enumdirection.method_10164();
            double d5 = random.method_43059() * 0.05 + (double)enumdirection.method_10165();
            if (SmallFireball.class.isAssignableFrom(projectile)) {
                launch = new class_1677(world, null, d0, d1, d2);
            } else if (WitherSkull.class.isAssignableFrom(projectile)) {
                launch = class_1299.field_6130.method_5883(world);
                launch.method_5814(d0, d1, d2);
                double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                ((class_1668)launch).field_7601 = d3 / d6 * 0.1;
                ((class_1668)launch).field_7600 = d4 / d6 * 0.1;
                ((class_1668)launch).field_7599 = d5 / d6 * 0.1;
            } else {
                launch = class_1299.field_6066.method_5883(world);
                launch.method_5814(d0, d1, d2);
                double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                ((class_1668)launch).field_7601 = d3 / d6 * 0.1;
                ((class_1668)launch).field_7600 = d4 / d6 * 0.1;
                ((class_1668)launch).field_7599 = d5 / d6 * 0.1;
            }
            ((class_1668)launch).banner$setProjectileSource((ProjectileSource)this);
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported", (Object[])new Object[0]);
        if (launch instanceof class_1676) {
            if (launch instanceof class_1682) {
                ((class_1682)launch).banner$setProjectileSource((ProjectileSource)this);
            }
            float a = 6.0f;
            float b = 1.1f;
            if (launch instanceof ThrownPotion || launch instanceof ThrownExpBottle) {
                a *= 0.5f;
                b *= 1.25f;
            }
            ((class_1676)launch).method_7485((double)enumdirection.method_10148(), (double)((float)enumdirection.method_10164() + 0.1f), (double)enumdirection.method_10165(), b, a);
        }
        if (velocity != null) {
            ((Projectile)((Object)launch.getBukkitEntity())).setVelocity(velocity);
        }
        world.method_8649((class_1297)launch);
        return (T)((Projectile)((Object)launch.getBukkitEntity()));
    }
}

