/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.scoreboard;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_269;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftTeam;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements Scoreboard {
    final class_269 board;

    CraftScoreboard(class_269 board) {
        this.board = board;
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name);
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria, String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, CraftCriteria.getFromBukkit(criteria), displayName, RenderType.INTEGER);
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        return this.registerNewObjective(name, CraftCriteria.getFromBukkit(criteria), displayName, renderType);
    }

    @Override
    public CraftObjective registerNewObjective(String name, Criteria criteria, String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @Override
    public CraftObjective registerNewObjective(String name, Criteria criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Objective name cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)displayName, (String)"Display name cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)renderType), (String)"RenderType cannot be null", (Object[])new Object[0]);
        Validate.isTrue((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("The name '" + name + "' is longer than the limit of 32767 characters"), (Object[])new Object[0]);
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)("The display name '" + displayName + "' is longer than the limit of 128 characters"), (Object[])new Object[0]);
        Validate.isTrue((this.board.method_1170(name) == null ? 1 : 0) != 0, (String)("An objective of name '" + name + "' already exists"), (Object[])new Object[0]);
        class_266 objective = this.board.method_1168(name, ((CraftCriteria)criteria).criteria, CraftChatMessage.fromStringOrNull(displayName), CraftScoreboardTranslations.fromBukkitRender(renderType));
        return new CraftObjective(this, objective);
    }

    @Override
    public Objective getObjective(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        class_266 nms = this.board.method_1170(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null", (Object[])new Object[0]);
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (class_266 netObjective : this.board.method_1151()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(Criteria criteria) throws IllegalArgumentException {
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null", (Object[])new Object[0]);
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (class_266 netObjective : this.board.method_1151()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getTrackedCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.board.method_1151(), (Function)new Function<class_266, Objective>(){

            public Objective apply(class_266 input) {
                return new CraftObjective(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public Objective getObjective(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Display slot cannot be null", (Object[])new Object[0]);
        class_266 objective = this.board.method_1189(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        return this.getScores(player.getName());
    }

    public ImmutableSet<Score> getScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (class_266 objective : this.board.method_1151()) {
            scores.add((Object)new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    @Override
    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        this.resetScores(player.getName());
    }

    @Override
    public void resetScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        for (class_266 objective : this.board.method_1151()) {
            this.board.method_1155(entry, objective);
        }
    }

    @Override
    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        class_268 team = this.board.method_1164(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        class_268 team = this.board.method_1164(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getTeam(String teamName) throws IllegalArgumentException {
        Validate.notNull((Object)teamName, (String)"Team name cannot be null", (Object[])new Object[0]);
        class_268 team = this.board.method_1153(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.board.method_1159(), (Function)new Function<class_268, Team>(){

            public Team apply(class_268 input) {
                return new CraftTeam(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public Team registerNewTeam(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Team name cannot be null", (Object[])new Object[0]);
        Validate.isTrue((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("Team name '" + name + "' is longer than the limit of 32767 characters"), (Object[])new Object[0]);
        Validate.isTrue((this.board.method_1153(name) == null ? 1 : 0) != 0, (String)("Team name '" + name + "' is already in use"), (Object[])new Object[0]);
        return new CraftTeam(this, this.board.method_1171(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (Object playerName : this.board.method_1178()) {
            players.add((Object)Bukkit.getOfflinePlayer(playerName.toString()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (Object entry : this.board.method_1178()) {
            entries.add((Object)entry.toString());
        }
        return entries.build();
    }

    @Override
    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Slot cannot be null", (Object[])new Object[0]);
        this.board.method_1158(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public class_269 getHandle() {
        return this.board;
    }
}

