/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.structure;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2960;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import org.apache.commons.lang3.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.structure.Structure;
import org.bukkit.structure.StructureManager;

public class CraftStructureManager
implements StructureManager {
    private final class_3485 structureManager;

    public CraftStructureManager(class_3485 structureManager) {
        this.structureManager = structureManager;
    }

    @Override
    public Map<NamespacedKey, Structure> getStructures() {
        HashMap cachedStructures = new HashMap();
        for (Map.Entry entry : this.structureManager.field_15513.entrySet()) {
            ((Optional)entry.getValue()).ifPresent(definedStructure -> cachedStructures.put(CraftNamespacedKey.fromMinecraft((class_2960)entry.getKey()), new CraftStructure((class_3499)definedStructure)));
        }
        return Collections.unmodifiableMap(cachedStructures);
    }

    @Override
    public Structure getStructure(NamespacedKey structureKey) {
        Validate.notNull((Object)structureKey, (String)"structureKey cannot be null", (Object[])new Object[0]);
        Optional definedStructure = (Optional)this.structureManager.field_15513.get(CraftNamespacedKey.toMinecraft(structureKey));
        if (definedStructure == null) {
            return null;
        }
        return definedStructure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public Structure loadStructure(NamespacedKey structureKey, boolean register) {
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional structure = (Optional)this.structureManager.field_15513.get(minecraftKey);
        structure = structure == null ? Optional.empty() : structure;
        structure = structure.isPresent() ? structure : this.structureManager.method_15092(minecraftKey);
        Optional optional = structure = structure.isPresent() ? structure : this.structureManager.loadFromResource0(minecraftKey);
        if (register) {
            this.structureManager.field_15513.put(minecraftKey, structure);
        }
        return structure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public Structure loadStructure(NamespacedKey structureKey) {
        return this.loadStructure(structureKey, true);
    }

    @Override
    public void saveStructure(NamespacedKey structureKey) {
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        this.structureManager.method_15093(minecraftKey);
    }

    @Override
    public void saveStructure(NamespacedKey structureKey, Structure structure) throws IOException {
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        File structureFile = this.getStructureFile(structureKey);
        Files.createDirectories(structureFile.toPath().getParent(), new FileAttribute[0]);
        this.saveStructure(structureFile, structure);
    }

    @Override
    public Structure registerStructure(NamespacedKey structureKey, Structure structure) {
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional<class_3499> optionalDefinedStructure = Optional.of(((CraftStructure)structure).getHandle());
        Optional<class_3499> previousStructure = this.structureManager.field_15513.put(minecraftKey, optionalDefinedStructure);
        return previousStructure == null ? null : (Structure)previousStructure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public Structure unregisterStructure(NamespacedKey structureKey) {
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        Optional previousStructure = (Optional)this.structureManager.field_15513.remove(minecraftKey);
        return previousStructure == null ? null : (Structure)previousStructure.map(CraftStructure::new).orElse(null);
    }

    @Override
    public void deleteStructure(NamespacedKey structureKey) throws IOException {
        this.deleteStructure(structureKey, true);
    }

    @Override
    public void deleteStructure(NamespacedKey structureKey, boolean unregister) throws IOException {
        class_2960 key = CraftNamespacedKey.toMinecraft(structureKey);
        if (unregister) {
            this.structureManager.field_15513.remove(key);
        }
        Path path = this.structureManager.method_44228(key, ".nbt");
        Files.deleteIfExists(path);
    }

    @Override
    public File getStructureFile(NamespacedKey structureKey) {
        class_2960 minecraftKey = this.createAndValidateMinecraftStructureKey(structureKey);
        return this.structureManager.method_44228(minecraftKey, ".nbt").toFile();
    }

    @Override
    public Structure loadStructure(File file) throws IOException {
        Validate.notNull((Object)file, (String)"file cannot be null", (Object[])new Object[0]);
        FileInputStream fileinputstream = new FileInputStream(file);
        return this.loadStructure(fileinputstream);
    }

    @Override
    public Structure loadStructure(InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream, (String)"inputStream cannot be null", (Object[])new Object[0]);
        return new CraftStructure(this.structureManager.method_15090(inputStream));
    }

    @Override
    public void saveStructure(File file, Structure structure) throws IOException {
        Validate.notNull((Object)file, (String)"file cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        FileOutputStream fileoutputstream = new FileOutputStream(file);
        this.saveStructure(fileoutputstream, structure);
    }

    @Override
    public void saveStructure(OutputStream outputStream, Structure structure) throws IOException {
        Validate.notNull((Object)outputStream, (String)"outputStream cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)structure, (String)"structure cannot be null", (Object[])new Object[0]);
        class_2487 nbttagcompound = ((CraftStructure)structure).getHandle().method_15175(new class_2487());
        class_2507.method_10634((class_2487)nbttagcompound, (OutputStream)outputStream);
    }

    @Override
    public Structure createStructure() {
        return new CraftStructure(new class_3499());
    }

    private class_2960 createAndValidateMinecraftStructureKey(NamespacedKey structureKey) {
        Validate.notNull((Object)structureKey, (String)"structureKey cannot be null", (Object[])new Object[0]);
        class_2960 minecraftkey = CraftNamespacedKey.toMinecraft(structureKey);
        if (minecraftkey.method_12832().contains("//")) {
            throw new IllegalArgumentException("Resource key for Structures can not contain \"//\"");
        }
        return minecraftkey;
    }

    @Override
    public Structure copy(Structure structure) {
        return new CraftStructure(this.structureManager.method_21891(((CraftStructure)structure).getHandle().method_15175(new class_2487())));
    }
}

