/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.command;

import com.mohistmc.banner.api.ServerAPI;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mohistmc.banner.fabric.FabricInjectBukkit;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.apache.commons.io.FileUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class DumpCommand
extends BukkitCommand {
    private final List<String> tab_cmd = Arrays.asList("potions", "enchants", "cbcmds", "entitytypes", "biomes", "pattern", "worldtype", "bukkit_material", "vanilla_material", "profession", "advancements");
    private final List<String> tab_mode = List.of("file");

    public DumpCommand(String name) {
        super(name);
        this.description = "Universal Dump, which will print the information you need locally!";
        this.usageMessage = "/dump <file> [potions|enchants|cbcmds|entitytypes|biomes|pattern|worldtype|bukkit_material|vanilla_material|profession|advancements]";
        this.setPermission("banner.command.dump");
    }

    @Override
    @NotNull
    public List<String> tabComplete(CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        if (sender.isOp() || this.testPermission(sender)) {
            switch (args.length) {
                case 2: {
                    for (String param : this.tab_cmd) {
                        if (!param.toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        list.add(param);
                    }
                    break;
                }
                case 1: {
                    for (String param : this.tab_mode) {
                        if (!param.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                        list.add(param);
                    }
                    break;
                }
            }
        }
        return list;
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        if (args.length == 2) {
            String mode = args[0];
            switch (args[1].toLowerCase(Locale.ENGLISH)) {
                case "potions": {
                    this.dumpPotions(sender, mode);
                    break;
                }
                case "enchants": {
                    this.dumpEnchant(sender, mode);
                    break;
                }
                case "cbcmds": {
                    this.dumpCBCommands(sender, mode);
                    break;
                }
                case "entitytypes": {
                    this.dumpEntityTypes(sender, mode);
                    break;
                }
                case "biomes": {
                    this.dumpBiomes(sender, mode);
                    break;
                }
                case "pattern": {
                    this.dumpPattern(sender, mode);
                    break;
                }
                case "worldtype": {
                    this.dumpWorldType(sender, mode);
                    break;
                }
                case "bukkit_material": {
                    this.dumpBukkitMaterial(sender, mode);
                    break;
                }
                case "vanilla_material": {
                    this.dumpVanillaMaterial(sender, mode);
                    break;
                }
                case "profession": {
                    this.dumpVillageProfession(sender, mode);
                    break;
                }
                case "advancements": {
                    this.dumpAdvancements(sender, mode);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    private void dumpPotions(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (PotionEffectType potionEffectType : PotionEffectType.values()) {
            if (potionEffectType == null) continue;
            sb.append(potionEffectType).append("\n");
        }
        for (PotionType potionType : PotionType.values()) {
            if (potionType == null) continue;
            sb.append((Object)potionType).append("\n");
        }
        this.dump(sender, "potions", sb, mode);
    }

    private void dumpEnchant(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Enchantment ench : Enchantment.values()) {
            sb.append(ench).append("\n");
        }
        this.dump(sender, "enchants", sb, mode);
    }

    private void dumpEntityTypes(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (EntityType ent : EntityType.values()) {
            sb.append(ent.toString()).append("\n");
        }
        this.dump(sender, "entitytypes", sb, mode);
    }

    private void dumpCBCommands(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Command per : Objects.requireNonNull(BukkitExtraConstants.getServer()).bridge$server().getCommandMap().getCommands()) {
            if (per.getPermission() == null) continue;
            sb.append(per.getName()).append(": ").append(per.getPermission()).append("\n");
        }
        this.dump(sender, "cbcommands", sb, mode);
    }

    private void dumpBiomes(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Biome biome : Biome.values()) {
            sb.append(biome.toString()).append("\n");
        }
        this.dump(sender, "biomes", sb, mode);
    }

    private void dumpPattern(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (PatternType patternType : PatternType.values()) {
            String key = patternType.getIdentifier();
            sb.append(key).append("_").append((Object)PatternType.getByIdentifier(key)).append("\n");
        }
        this.dump(sender, "pattern", sb, mode);
    }

    private void dumpWorldType(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (WorldType type : WorldType.values()) {
            String key = type.getName();
            sb.append((Object)type).append("-").append(key).append("\n");
        }
        this.dump(sender, "worldtype", sb, mode);
    }

    private void dumpBukkitMaterial(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Material material : Material.values()) {
            String key = material.name();
            sb.append(material).append("-").append(key).append("\n");
        }
        this.dump(sender, "bukkit_material", sb, mode);
    }

    private void dumpVillageProfession(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (Villager.Profession profession : Villager.Profession.values()) {
            String key = profession.name();
            sb.append(profession).append("-").append(key).append("\n");
        }
        this.dump(sender, "profession", sb, mode);
    }

    private void dumpVanillaMaterial(CommandSender sender, String mode) {
        class_2960 resourceLocation;
        StringBuilder sb = new StringBuilder();
        class_7922 vanilla_item = class_7923.field_41178;
        for (class_1792 item : vanilla_item) {
            resourceLocation = vanilla_item.method_10221((Object)item);
            if (!FabricInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            sb.append(item).append("\n");
        }
        class_7922 vanilla_block = class_7923.field_41175;
        for (class_2248 block : vanilla_block) {
            resourceLocation = vanilla_block.method_10221((Object)block);
            if (!FabricInjectBukkit.isMINECRAFT(resourceLocation)) continue;
            sb.append(block).append("\n");
        }
        this.dump(sender, "vanilla_material", sb, mode);
    }

    private void dumpAdvancements(CommandSender sender, String mode) {
        StringBuilder sb = new StringBuilder();
        for (class_161 channel : ServerAPI.getNMSServer().method_3851().method_12893()) {
            sb.append(channel.method_688()).append("\n");
        }
        this.dump(sender, "advancements", sb, mode);
    }

    private void dumpmsg(CommandSender sender, File file, String type) {
        sender.sendMessage("Successfully dump " + type + ", output path: " + file.getAbsolutePath());
    }

    private void dump(CommandSender sender, String type, StringBuilder sb, String mode) {
        if (mode.equals("file")) {
            this.saveToF(type + ".txt", sb, sender);
        }
    }

    private void saveToF(String child, StringBuilder sb, CommandSender sender) {
        File file = new File("dump", child);
        this.writeByteArrayToFile(file, sb);
        this.dumpmsg(sender, file, child.replace(".txt", ""));
    }

    protected void writeByteArrayToFile(File file, StringBuilder sb) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])sb.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

