/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.mohistmc.banner.BannerMCStart;
import com.mohistmc.banner.api.ServerAPI;
import com.mohistmc.banner.bukkit.BukkitExtraConstants;
import com.mohistmc.banner.bukkit.nms.utils.RemapUtils;
import com.mohistmc.banner.injection.world.item.crafting.InjectionRecipe;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.class_1263;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1419;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1715;
import net.minecraft.class_1731;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1860;
import net.minecraft.class_1893;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_1959;
import net.minecraft.class_20;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_269;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_29;
import net.minecraft.class_2960;
import net.minecraft.class_2976;
import net.minecraft.class_2995;
import net.minecraft.class_3002;
import net.minecraft.class_3004;
import net.minecraft.class_31;
import net.minecraft.class_3174;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3327;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.class_3340;
import net.minecraft.class_3518;
import net.minecraft.class_3551;
import net.minecraft.class_3611;
import net.minecraft.class_3769;
import net.minecraft.class_3806;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3990;
import net.minecraft.class_4274;
import net.minecraft.class_4317;
import net.minecraft.class_4543;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_60;
import net.minecraft.class_6862;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7237;
import net.minecraft.class_7723;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8566;
import net.minecraft.class_8579;
import net.minecraft.server.MinecraftServer;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Fluid;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.StructureType;
import org.bukkit.Tag;
import org.bukkit.UnsafeValues;
import org.bukkit.Warning;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.data.BlockData;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.conversations.Conversable;
import org.bukkit.craftbukkit.Main;
import org.bukkit.craftbukkit.v1_20_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R1.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_20_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_20_R1.ban.CraftIpBanList;
import org.bukkit.craftbukkit.v1_20_R1.ban.CraftProfileBanList;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_20_R1.boss.CraftKeyedBossbar;
import org.bukkit.craftbukkit.v1_20_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_20_R1.command.CraftCommandMap;
import org.bukkit.craftbukkit.v1_20_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_20_R1.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_20_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftBlastingRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftCampfireRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftFurnaceRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMerchantCustom;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftShapedRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftShapelessRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftSmithingTransformRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftSmithingTrimRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftSmokingRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftStonecuttingRecipe;
import org.bukkit.craftbukkit.v1_20_R1.inventory.RecipeIterator;
import org.bukkit.craftbukkit.v1_20_R1.inventory.util.CraftInventoryCreator;
import org.bukkit.craftbukkit.v1_20_R1.map.CraftMapColorCache;
import org.bukkit.craftbukkit.v1_20_R1.map.CraftMapView;
import org.bukkit.craftbukkit.v1_20_R1.metadata.EntityMetadataStore;
import org.bukkit.craftbukkit.v1_20_R1.metadata.PlayerMetadataStore;
import org.bukkit.craftbukkit.v1_20_R1.metadata.WorldMetadataStore;
import org.bukkit.craftbukkit.v1_20_R1.packs.CraftDataPackManager;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionBrewer;
import org.bukkit.craftbukkit.v1_20_R1.profile.CraftPlayerProfile;
import org.bukkit.craftbukkit.v1_20_R1.scheduler.CraftScheduler;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_20_R1.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_20_R1.structure.CraftStructureManager;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftEntityTag;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftFluidTag;
import org.bukkit.craftbukkit.v1_20_R1.tag.CraftItemTag;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftIconCache;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftSpawnCategory;
import org.bukkit.craftbukkit.v1_20_R1.util.DatFileFilter;
import org.bukkit.craftbukkit.v1_20_R1.util.Versioning;
import org.bukkit.craftbukkit.v1_20_R1.util.permissions.CraftDefaultPermissions;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerChatTabCompleteEvent;
import org.bukkit.event.server.BroadcastMessageEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.server.TabCompleteEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.help.HelpMap;
import org.bukkit.inventory.BlastingRecipe;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingTransformRecipe;
import org.bukkit.inventory.SmithingTrimRecipe;
import org.bukkit.inventory.SmokingRecipe;
import org.bukkit.inventory.StonecuttingRecipe;
import org.bukkit.loot.LootTable;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;
import org.bukkit.packs.DataPackManager;
import org.bukkit.permissions.Permissible;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginLoadOrder;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.SimpleServicesManager;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.potion.Potion;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.scheduler.BukkitWorker;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.structure.StructureManager;
import org.bukkit.util.StringUtil;
import org.bukkit.util.permissions.DefaultPermissions;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.RestartCommand;
import org.spigotmc.SpigotConfig;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public final class CraftServer
implements Server {
    private final String serverName = "Banner";
    public static String serverVersion;
    private final String bukkitVersion = Versioning.getBukkitVersion();
    private final Logger logger = Logger.getLogger("Minecraft");
    private final ServicesManager servicesManager = new SimpleServicesManager();
    private final CraftScheduler scheduler = new CraftScheduler();
    private final CraftCommandMap commandMap = new CraftCommandMap(this);
    public final SimpleHelpMap helpMap = new SimpleHelpMap(this);
    private final StandardMessenger messenger = new StandardMessenger();
    private final SimplePluginManager pluginManager = new SimplePluginManager(this, this.commandMap);
    private final StructureManager structureManager;
    protected final class_3176 console;
    protected final class_3174 playerList;
    private final Map<String, World> worlds = new LinkedHashMap<String, World>();
    private final Map<Class<?>, Registry<?>> registries = new HashMap();
    private YamlConfiguration configuration;
    private YamlConfiguration commandsConfiguration;
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
    private final Map<UUID, OfflinePlayer> offlinePlayers = new MapMaker().weakValues().makeMap();
    private final EntityMetadataStore entityMetadata = new EntityMetadataStore();
    private final PlayerMetadataStore playerMetadata = new PlayerMetadataStore();
    private final WorldMetadataStore worldMetadata = new WorldMetadataStore();
    private final Object2IntOpenHashMap<SpawnCategory> spawnCategoryLimit = new Object2IntOpenHashMap();
    private File container;
    private Warning.WarningState warningState = Warning.WarningState.DEFAULT;
    public String minimumAPI;
    public CraftScoreboardManager scoreboardManager;
    public CraftDataPackManager dataPackManager;
    public boolean playerCommandState;
    private boolean printSaveWarning;
    private CraftIconCache icon;
    private boolean overrideAllCommandBlockCommands = false;
    public boolean ignoreVanillaPermissions = false;
    private List<CraftPlayer> playerView;
    public int reloadCount;
    private final Server.Spigot spigot = new Server.Spigot(){

        @Override
        public YamlConfiguration getConfig() {
            return SpigotConfig.config;
        }

        @Override
        public void restart() {
            RestartCommand.restart();
        }

        @Override
        public void broadcast(BaseComponent component) {
            for (Player player : CraftServer.this.getOnlinePlayers()) {
                player.spigot().sendMessage(component);
            }
        }

        @Override
        public void broadcast(BaseComponent ... components) {
            for (Player player : CraftServer.this.getOnlinePlayers()) {
                player.spigot().sendMessage(components);
            }
        }
    };

    public CraftServer(class_3176 console, class_3324 playerList) {
        this.console = console;
        this.playerList = (class_3174)playerList;
        this.playerView = Collections.unmodifiableList(Lists.transform((List)playerList.field_14351, (Function)new Function<class_3222, CraftPlayer>(){

            public CraftPlayer apply(class_3222 player) {
                return player.getBukkitEntity();
            }
        }));
        serverVersion = BannerMCStart.getVersion();
        this.structureManager = new CraftStructureManager(console.method_27727());
        this.scoreboardManager = new CraftScoreboardManager((MinecraftServer)console, (class_269)new class_2995((MinecraftServer)console));
        this.dataPackManager = new CraftDataPackManager(this.getServer().method_3836());
        Bukkit.setServer(this);
        class_1893.field_9118.getClass();
        Potion.setPotionBrewer(new CraftPotionBrewer());
        class_1294.field_5919.getClass();
        if (!Main.useConsole) {
            this.getLogger().info("Console input is disabled due to --noconsole command argument");
        }
        this.configuration = YamlConfiguration.loadConfiguration(this.getConfigFile());
        this.configuration.options().copyDefaults(true);
        this.configuration.setDefaults(YamlConfiguration.loadConfiguration(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/bukkit.yml"), Charsets.UTF_8)));
        ConfigurationSection legacyAlias = null;
        if (!this.configuration.isString("aliases")) {
            legacyAlias = this.configuration.getConfigurationSection("aliases");
            this.configuration.set("aliases", "now-in-commands.yml");
        }
        this.saveConfig();
        if (this.getCommandsConfigFile().isFile()) {
            legacyAlias = null;
        }
        this.commandsConfiguration = YamlConfiguration.loadConfiguration(this.getCommandsConfigFile());
        this.commandsConfiguration.options().copyDefaults(true);
        this.commandsConfiguration.setDefaults(YamlConfiguration.loadConfiguration(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("configurations/commands.yml"), Charsets.UTF_8)));
        this.saveCommandsConfig();
        if (legacyAlias != null) {
            ConfigurationSection aliases = this.commandsConfiguration.createSection("aliases");
            for (String key : legacyAlias.getKeys(false)) {
                ArrayList<CallSite> commands = new ArrayList<CallSite>();
                if (legacyAlias.isList(key)) {
                    for (String command : legacyAlias.getStringList(key)) {
                        commands.add((CallSite)((Object)(command + " $1-")));
                    }
                } else {
                    commands.add((CallSite)((Object)(legacyAlias.getString(key) + " $1-")));
                }
                aliases.set(key, commands);
            }
        }
        this.saveCommandsConfig();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        this.pluginManager.useTimings(this.configuration.getBoolean("settings.plugin-profiling"));
        this.overrideSpawnLimits();
        BukkitExtraConstants.bridge$autosavePeriod = this.configuration.getInt("ticks-per.autosave");
        this.warningState = Warning.WarningState.value(this.configuration.getString("settings.deprecated-verbose"));
        BukkitExtraConstants.PLUGIN.field_19348 = this.configuration.getInt("chunk-gc.period-in-ticks");
        this.minimumAPI = this.configuration.getString("settings.minimum-api");
        this.loadIcon();
        if (this.configuration.getBoolean("settings.use-map-color-cache")) {
            MapPalette.setMapColorCache(new CraftMapColorCache(this.logger));
        }
    }

    public boolean getCommandBlockOverride(String command) {
        return this.overrideAllCommandBlockCommands || this.commandsConfiguration.getStringList("command-block-overrides").contains(command);
    }

    private File getConfigFile() {
        return (File)this.console.bridge$options().valueOf("bukkit-settings");
    }

    private File getCommandsConfigFile() {
        return (File)this.console.bridge$options().valueOf("commands-settings");
    }

    private void overrideSpawnLimits() {
        for (SpawnCategory spawnCategory : SpawnCategory.values()) {
            if (!CraftSpawnCategory.isValidForLimits(spawnCategory)) continue;
            this.spawnCategoryLimit.put((Object)spawnCategory, this.configuration.getInt(CraftSpawnCategory.getConfigNameSpawnLimit(spawnCategory)));
        }
    }

    private void saveConfig() {
        try {
            this.configuration.save(this.getConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getConfigFile(), ex);
        }
    }

    private void saveCommandsConfig() {
        try {
            this.commandsConfiguration.save(this.getCommandsConfigFile());
        }
        catch (IOException ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, "Could not save " + this.getCommandsConfigFile(), ex);
        }
    }

    public void loadPlugins() {
        this.pluginManager.registerInterface(JavaPluginLoader.class);
        RemapUtils.init();
        File pluginFolder = (File)this.console.bridge$options().valueOf("plugins");
        if (pluginFolder.exists()) {
            Plugin[] plugins;
            for (Plugin plugin : plugins = this.pluginManager.loadPlugins(pluginFolder)) {
                try {
                    String message = String.format(BannerMCStart.I18N.get("bukkit.plugin.loading"), plugin.getDescription().getFullName());
                    plugin.getLogger().info(message);
                    plugin.onLoad();
                }
                catch (Throwable ex) {
                    Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " initializing " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
                }
            }
        } else {
            pluginFolder.mkdir();
        }
    }

    public void enablePlugins(PluginLoadOrder type) {
        Plugin[] plugins;
        if (type == PluginLoadOrder.STARTUP) {
            this.helpMap.clear();
            this.helpMap.initializeGeneralTopics();
        }
        for (Plugin plugin : plugins = this.pluginManager.getPlugins()) {
            if (plugin.isEnabled() || plugin.getDescription().getLoad() != type) continue;
            this.enablePlugin(plugin);
        }
        if (type == PluginLoadOrder.POSTWORLD) {
            this.setVanillaCommands(true);
            this.commandMap.setFallbackCommands();
            this.setVanillaCommands(false);
            this.commandMap.registerServerAliases();
            DefaultPermissions.registerCorePermissions();
            CraftDefaultPermissions.registerCorePermissions();
            this.loadCustomPermissions();
            this.helpMap.initializeCommands();
            this.syncCommands();
        }
    }

    public void disablePlugins() {
        this.pluginManager.disablePlugins();
    }

    private void setVanillaCommands(boolean first) {
        class_2170 dispatcher = this.console.bridge$getVanillaCommands();
        for (CommandNode cmd : dispatcher.method_9235().getRoot().getChildren()) {
            this.commandMap.register("minecraft", new VanillaCommandWrapper(dispatcher, (CommandNode<class_2168>)cmd));
        }
    }

    public void syncCommands() {
        class_2170 dispatcher = this.console.field_25318.comp_353().field_25336;
        for (Map.Entry<String, Command> entry : this.commandMap.getKnownCommands().entrySet()) {
            String label = entry.getKey();
            Command command = entry.getValue();
            if (command instanceof VanillaCommandWrapper) {
                LiteralCommandNode node = (LiteralCommandNode)((VanillaCommandWrapper)command).vanillaCommand;
                if (!node.getLiteral().equals(label)) {
                    LiteralCommandNode clone = new LiteralCommandNode(label, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
                    for (CommandNode child : node.getChildren()) {
                        clone.addChild(child);
                    }
                    node = clone;
                }
                dispatcher.method_9235().getRoot().addChild((CommandNode)node);
                continue;
            }
            new BukkitCommandWrapper(this, entry.getValue()).register((CommandDispatcher<class_2168>)dispatcher.method_9235(), label);
        }
        for (class_3222 player : this.getHandle().field_14351) {
            dispatcher.method_9241(player);
        }
    }

    private void enablePlugin(Plugin plugin) {
        try {
            List<Permission> perms = plugin.getDescription().getPermissions();
            for (Permission perm : perms) {
                try {
                    this.pluginManager.addPermission(perm, false);
                }
                catch (IllegalArgumentException ex) {
                    this.getLogger().log(Level.WARNING, "Plugin " + plugin.getDescription().getFullName() + " tried to register permission '" + perm.getName() + "' but it's already registered", ex);
                }
            }
            this.pluginManager.dirtyPermissibles();
            this.pluginManager.enablePlugin(plugin);
        }
        catch (Throwable ex) {
            Logger.getLogger(CraftServer.class.getName()).log(Level.SEVERE, ex.getMessage() + " loading " + plugin.getDescription().getFullName() + " (Is it up to date?)", ex);
        }
    }

    @Override
    public String getName() {
        return "Banner";
    }

    @Override
    public String getVersion() {
        return serverVersion + " (MC: " + this.console.method_3827() + ")";
    }

    @Override
    public String getBukkitVersion() {
        return this.bukkitVersion;
    }

    public List<CraftPlayer> getOnlinePlayers() {
        this.playerView = Collections.unmodifiableList(Lists.transform((List)this.playerList.field_14351, (Function)new Function<class_3222, CraftPlayer>(){

            public CraftPlayer apply(class_3222 player) {
                return player.getBukkitEntity();
            }
        }));
        return this.playerView;
    }

    @Override
    @Deprecated
    public Player getPlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Player found = this.getPlayerExact(name);
        if (found != null) {
            return found;
        }
        String lowerName = name.toLowerCase(Locale.ENGLISH);
        int delta = Integer.MAX_VALUE;
        for (Player player : this.getOnlinePlayers()) {
            if (!player.getName().toLowerCase(Locale.ENGLISH).startsWith(lowerName)) continue;
            int curDelta = Math.abs(player.getName().length() - lowerName.length());
            if (curDelta < delta) {
                found = player;
                delta = curDelta;
            }
            if (curDelta != 0) continue;
            break;
        }
        return found;
    }

    @Override
    @Deprecated
    public Player getPlayerExact(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        class_3222 player = this.playerList.method_14566(name);
        return player != null ? player.getBukkitEntity() : null;
    }

    @Override
    public Player getPlayer(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        class_3222 player = this.playerList.method_14602(id);
        if (player != null) {
            return player.getBukkitEntity();
        }
        return null;
    }

    @Override
    public int broadcastMessage(String message) {
        return this.broadcast(message, "bukkit.broadcast.user");
    }

    @Override
    @Deprecated
    public List<Player> matchPlayer(String partialName) {
        Preconditions.checkArgument((partialName != null ? 1 : 0) != 0, (Object)"partialName cannot be null");
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : this.getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(partialName.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    @Override
    public int getMaxPlayers() {
        return this.playerList.method_14592();
    }

    @Override
    public void setMaxPlayers(int maxPlayers) {
        Preconditions.checkArgument((maxPlayers >= 0 ? 1 : 0) != 0, (Object)"maxPlayers must be >= 0");
        this.playerList.field_14347 = maxPlayers;
    }

    @Override
    public int getPort() {
        return this.getServer().method_3756();
    }

    @Override
    public int getViewDistance() {
        return this.getProperties().field_16844;
    }

    @Override
    public int getSimulationDistance() {
        return this.getProperties().field_34883;
    }

    @Override
    public String getIp() {
        return this.getServer().method_3819();
    }

    @Override
    public String getWorldType() {
        return this.getProperties().field_16848.getProperty("level-type");
    }

    @Override
    public boolean getGenerateStructures() {
        return this.getServer().method_27728().method_28057().method_28029();
    }

    @Override
    public int getMaxWorldSize() {
        return this.getProperties().field_16812;
    }

    @Override
    public boolean getAllowEnd() {
        return this.configuration.getBoolean("settings.allow-end");
    }

    @Override
    public boolean getAllowNether() {
        return this.getServer().method_3839();
    }

    public boolean getWarnOnOverload() {
        return this.configuration.getBoolean("settings.warn-on-overload");
    }

    public boolean getQueryPlugins() {
        return this.configuration.getBoolean("settings.query-plugins");
    }

    @Override
    public List<String> getInitialEnabledPacks() {
        return Collections.unmodifiableList(this.getProperties().field_39981.method_29547());
    }

    @Override
    public List<String> getInitialDisabledPacks() {
        return Collections.unmodifiableList(this.getProperties().field_39981.method_29550());
    }

    @Override
    public DataPackManager getDataPackManager() {
        return this.dataPackManager;
    }

    @Override
    public String getResourcePack() {
        return this.getServer().method_43659().map(MinecraftServer.class_7460::comp_784).orElse("");
    }

    @Override
    public String getResourcePackHash() {
        return this.getServer().method_43659().map(MinecraftServer.class_7460::comp_785).orElse("").toUpperCase(Locale.ROOT);
    }

    @Override
    public String getResourcePackPrompt() {
        return this.getServer().method_43659().map(MinecraftServer.class_7460::comp_787).map(CraftChatMessage::fromComponent).orElse("");
    }

    @Override
    public boolean isResourcePackRequired() {
        return this.getServer().method_32303();
    }

    @Override
    public boolean hasWhitelist() {
        return (Boolean)this.getProperties().field_16804.get();
    }

    private class_3806 getProperties() {
        return this.console.method_16705();
    }

    @Override
    public String getUpdateFolder() {
        return this.configuration.getString("settings.update-folder", "update");
    }

    @Override
    public File getUpdateFolderFile() {
        return new File((File)this.console.bridge$options().valueOf("plugins"), this.configuration.getString("settings.update-folder", "update"));
    }

    @Override
    public long getConnectionThrottle() {
        if (SpigotConfig.bungee) {
            return -1L;
        }
        return this.configuration.getInt("settings.connection-throttle");
    }

    @Override
    @Deprecated
    public int getTicksPerAnimalSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.ANIMAL);
    }

    @Override
    @Deprecated
    public int getTicksPerMonsterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.MONSTER);
    }

    @Override
    @Deprecated
    public int getTicksPerWaterSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_ANIMAL);
    }

    @Override
    @Deprecated
    public int getTicksPerWaterAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_AMBIENT);
    }

    @Override
    @Deprecated
    public int getTicksPerWaterUndergroundCreatureSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Override
    @Deprecated
    public int getTicksPerAmbientSpawns() {
        return this.getTicksPerSpawns(SpawnCategory.AMBIENT);
    }

    @Override
    public int getTicksPerSpawns(SpawnCategory spawnCategory) {
        Preconditions.checkArgument((spawnCategory != null ? 1 : 0) != 0, (Object)"SpawnCategory cannot be null");
        Preconditions.checkArgument((boolean)CraftSpawnCategory.isValidForLimits(spawnCategory), (String)"SpawnCategory.%s are not supported", (Object)((Object)spawnCategory));
        return this.configuration.getInt(CraftSpawnCategory.getConfigNameTicksPerSpawn(spawnCategory));
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public CraftScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Override
    public List<World> getWorlds() {
        return new ArrayList<World>(this.worlds.values());
    }

    public class_3174 getHandle() {
        return this.playerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchServerCommand(CommandSender sender, class_2976 serverCommand) {
        Conversable conversable2;
        if (sender instanceof Conversable && (conversable2 = (Conversable)((Object)sender)).isConversing()) {
            conversable2.acceptConversationInput(serverCommand.field_13377);
            return true;
        }
        try {
            this.playerCommandState = true;
            boolean conversable2 = this.dispatchCommand(sender, serverCommand.field_13377);
            return conversable2;
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Unexpected exception while parsing console command \"" + serverCommand.field_13377 + "\"", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            this.playerCommandState = false;
        }
    }

    @Override
    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"sender cannot be null");
        Preconditions.checkArgument((commandLine != null ? 1 : 0) != 0, (Object)"commandLine cannot be null");
        commandLine = this.commandLine(sender, commandLine);
        if (commandLine == null) {
            return false;
        }
        if (this.commandMap.dispatch(sender, commandLine)) {
            return true;
        }
        if (!SpigotConfig.unknownCommandMessage.isEmpty()) {
            sender.sendMessage(SpigotConfig.unknownCommandMessage);
        }
        return false;
    }

    public String commandLine(CommandSender sender, String commandLine) {
        if (sender instanceof CraftEntity) {
            class_2168 commandSource = ((CraftEntity)sender).getHandle().method_5671();
        } else if (sender == Bukkit.getConsoleSender()) {
            class_2168 commandSource = ServerAPI.getNMSServer().method_3739();
        } else if (sender instanceof CraftBlockCommandSender) {
            class_2168 commandSource = ((CraftBlockCommandSender)sender).getWrapper();
        } else {
            return commandLine;
        }
        StringReader stringreader = new StringReader("/" + commandLine);
        if (stringreader.canRead() && stringreader.peek() == '/') {
            stringreader.skip();
        }
        return commandLine;
    }

    @Override
    public void reload() {
        ++this.reloadCount;
        this.configuration = YamlConfiguration.loadConfiguration(this.getConfigFile());
        this.commandsConfiguration = YamlConfiguration.loadConfiguration(this.getCommandsConfigFile());
        try {
            this.playerList.method_14585().method_14630();
        }
        catch (IOException var12) {
            this.logger.log(Level.WARNING, "Failed to load banned-ips.json, " + var12.getMessage());
        }
        try {
            this.playerList.method_14563().method_14630();
        }
        catch (IOException var11) {
            this.logger.log(Level.WARNING, "Failed to load banned-players.json, " + var11.getMessage());
        }
        this.pluginManager.clearPlugins();
        this.commandMap.clearCommands();
        this.reloadData();
        SpigotConfig.registerCommands();
        this.overrideAllCommandBlockCommands = this.commandsConfiguration.getStringList("command-block-overrides").contains("*");
        this.ignoreVanillaPermissions = this.commandsConfiguration.getBoolean("ignore-vanilla-permissions");
        for (int pollCount = 0; pollCount < 50 && this.getScheduler().getActiveWorkers().size() > 0; ++pollCount) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        List<BukkitWorker> overdueWorkers = this.getScheduler().getActiveWorkers();
        for (BukkitWorker worker : overdueWorkers) {
            Plugin plugin = worker.getOwner();
            this.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getDescription().getAuthors(), plugin.getDescription().getFullName(), "This plugin is not properly shutting down its async tasks when it is being reloaded.  This may cause conflicts with the newly loaded version of the plugin"));
        }
        this.loadPlugins();
        this.enablePlugins(PluginLoadOrder.STARTUP);
        this.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.getPluginManager().callEvent(new ServerLoadEvent(ServerLoadEvent.LoadType.RELOAD));
    }

    @Override
    public void reloadData() {
        BukkitExtraConstants.reload((MinecraftServer)this.console);
    }

    private void loadIcon() {
        this.icon = new CraftIconCache(null);
        try {
            File file = new File(new File("."), "server-icon.png");
            if (file.isFile()) {
                this.icon = CraftServer.loadServerIcon0(file);
            }
        }
        catch (Exception ex) {
            this.getLogger().log(Level.WARNING, "Couldn't load server icon", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCustomPermissions() {
        Map perms;
        FileInputStream stream;
        File file = new File(this.configuration.getString("settings.permissions-file"));
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            try {
                file.createNewFile();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            perms = (Map)this.yaml.load((InputStream)stream);
        }
        catch (MarkedYAMLException ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML: " + ex.toString());
            return;
        }
        catch (Throwable ex) {
            this.getLogger().log(Level.WARNING, "Server permissions file " + file + " is not valid YAML.", ex);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        if (perms == null) {
            this.getLogger().log(Level.INFO, "Server permissions file " + file + " is empty, ignoring it");
            return;
        }
        List<Permission> permsList = Permission.loadPermissions(perms, "Permission node '%s' in " + file + " is invalid", Permission.DEFAULT_PERMISSION);
        for (Permission perm : permsList) {
            try {
                this.pluginManager.addPermission(perm);
            }
            catch (IllegalArgumentException ex) {
                this.getLogger().log(Level.SEVERE, "Permission in " + file + " was already defined", ex);
            }
        }
    }

    public String toString() {
        return "CraftServer{serverName=Banner,serverVersion=" + serverVersion + ",minecraftVersion=" + this.console.method_3827() + "}";
    }

    public World createWorld(String name, World.Environment environment) {
        return WorldCreator.name(name).environment(environment).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed) {
        return WorldCreator.name(name).environment(environment).seed(seed).createWorld();
    }

    public World createWorld(String name, World.Environment environment, ChunkGenerator generator) {
        return WorldCreator.name(name).environment(environment).generator(generator).createWorld();
    }

    public World createWorld(String name, World.Environment environment, long seed, ChunkGenerator generator) {
        return WorldCreator.name(name).environment(environment).seed(seed).generator(generator).createWorld();
    }

    @Override
    public World createWorld(WorldCreator creator) {
        String levelName;
        class_31 worlddata;
        class_32.class_5143 worldSession;
        Preconditions.checkState((boolean)this.console.method_3738().iterator().hasNext(), (Object)"Cannot create additional worlds on STARTUP");
        Preconditions.checkArgument((creator != null ? 1 : 0) != 0, (Object)"WorldCreator cannot be null");
        String name = creator.name();
        ChunkGenerator generator = creator.generator();
        BiomeProvider biomeProvider = creator.biomeProvider();
        File folder = new File(this.getWorldContainer(), name);
        World world = this.getWorld(name);
        if (world != null) {
            return world;
        }
        if (folder.exists()) {
            Preconditions.checkArgument((boolean)folder.isDirectory(), (String)"File (%s) exists and isn't a folder", (Object)name);
        }
        if (generator == null) {
            generator = this.getGenerator(name);
        }
        if (biomeProvider == null) {
            biomeProvider = this.getBiomeProvider(name);
        }
        class_5321 actualDimension = switch (creator.environment()) {
            case World.Environment.NORMAL -> class_5363.field_25412;
            case World.Environment.NETHER -> class_5363.field_25413;
            case World.Environment.THE_END -> class_5363.field_25414;
            default -> throw new IllegalArgumentException("Illegal dimension (" + creator.environment() + ")");
        };
        try {
            worldSession = class_32.method_26999((Path)this.getWorldContainer().toPath()).validateAndCreateAccess(name, actualDimension);
        }
        catch (IOException | class_8579 ex) {
            throw new RuntimeException(ex);
        }
        boolean hardcore = creator.hardcore();
        class_7237.class_7660 worldloader_a = this.console.bridge$worldLoader();
        class_2378 iregistry = worldloader_a.comp_990().method_30530(class_7924.field_41224);
        class_6903 dynamicops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)worldloader_a.comp_989());
        Pair pair = worldSession.method_27013((DynamicOps)dynamicops, worldloader_a.comp_988(), iregistry, worldloader_a.comp_989().method_41201());
        if (pair != null) {
            worlddata = (class_31)pair.getFirst();
            iregistry = ((class_7723.class_7725)pair.getSecond()).comp_1017();
        } else {
            class_5285 worldoptions = new class_5285(creator.seed(), creator.generateStructures(), false);
            class_3806.class_7044 properties = new class_3806.class_7044(class_3518.method_15285((String)(creator.generatorSettings().isEmpty() ? "{}" : creator.generatorSettings())), creator.type().name().toLowerCase(Locale.ROOT));
            class_1940 worldsettings = new class_1940(name, class_1934.method_8384((int)this.getDefaultGameMode().getValue()), hardcore, class_1267.field_5805, false, new class_1928(), worldloader_a.comp_988());
            class_7723 worlddimensions = properties.method_41242((class_5455)worldloader_a.comp_989());
            class_7723.class_7725 worlddimensions_b = worlddimensions.method_45518(iregistry);
            Lifecycle lifecycle = worlddimensions_b.method_45536().add(worldloader_a.comp_989().method_41201());
            worlddata = new class_31(worldsettings, worldoptions, worlddimensions_b.comp_1018(), lifecycle);
            iregistry = worlddimensions_b.comp_1017();
        }
        worlddata.banner$setCustomDimensions(iregistry);
        worlddata.checkName(name);
        worlddata.method_24285(this.console.getServerModName(), this.console.method_24307().method_39029());
        if (this.console.bridge$options().has("forceUpgrade")) {
            net.minecraft.server.Main.method_29173((class_32.class_5143)worldSession, (DataFixer)class_3551.method_15450(), (boolean)this.console.bridge$options().has("eraseCache"), () -> true, (class_2378)iregistry);
        }
        long j = class_4543.method_27984((long)creator.seed());
        ImmutableList list = ImmutableList.of((Object)new class_3769(), (Object)new class_3769(), (Object)new class_4274(), (Object)new class_1419(), (Object)new class_3990((class_5268)worlddata));
        class_5363 worlddimension = (class_5363)iregistry.method_29107(actualDimension);
        CraftWorldInfo worldInfo = new CraftWorldInfo((class_5268)worlddata, worldSession, creator.environment(), (class_2874)worlddimension.comp_1012().comp_349());
        if (biomeProvider == null && generator != null) {
            biomeProvider = generator.getDefaultBiomeProvider(worldInfo);
        }
        class_5321 worldKey = name.equals((levelName = this.getServer().method_16705().field_16820) + "_nether") ? class_1937.field_25180 : (name.equals(levelName + "_the_end") ? class_1937.field_25181 : class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(name.toLowerCase(Locale.ENGLISH))));
        class_3218 internal = new class_3218((MinecraftServer)this.console, this.console.field_17200, worldSession, (class_5268)worlddata, worldKey, worlddimension, this.getServer().field_17439.create(11), worlddata.method_45556(), j, (List)(creator.environment() == World.Environment.NORMAL ? list : ImmutableList.of()), true, this.console.method_30002().method_52168());
        if (name.contains("/")) {
            String[] strings = name.split("/");
            name = strings[strings.length - 1];
        }
        internal.banner$setGenerator(generator);
        internal.banner$setBiomeProvider(biomeProvider);
        if (!this.worlds.containsKey(name.toLowerCase(Locale.ENGLISH))) {
            return null;
        }
        this.console.initWorld(internal, (class_5268)worlddata, (class_5219)worlddata, worlddata.method_28057());
        internal.method_8424(true, true);
        this.console.addLevel(internal);
        this.getServer().prepareLevels(internal.method_14178().field_17254.field_17442, internal);
        internal.field_26935.method_31809();
        this.pluginManager.callEvent(new WorldLoadEvent(internal.getWorld()));
        return internal.getWorld();
    }

    @Override
    public boolean unloadWorld(String name, boolean save) {
        return this.unloadWorld(this.getWorld(name), save);
    }

    @Override
    public boolean unloadWorld(World world, boolean save) {
        if (world == null) {
            return false;
        }
        class_3218 handle = ((CraftWorld)world).getHandle();
        if (this.console.method_3847(handle.method_27983()) == null) {
            return false;
        }
        if (handle.method_27983() == class_1937.field_25179) {
            return false;
        }
        if (handle.method_18456().size() > 0) {
            return false;
        }
        WorldUnloadEvent e = new WorldUnloadEvent(handle.getWorld());
        this.pluginManager.callEvent(e);
        if (e.isCancelled()) {
            return false;
        }
        try {
            if (save) {
                handle.method_14176(null, true, true);
            }
            handle.method_14178().close(save);
            handle.field_26935.close(save);
            handle.bridge$convertable().close();
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, null, ex);
        }
        this.worlds.remove(world.getName().toLowerCase(Locale.ROOT));
        this.console.removeLevel(handle);
        return true;
    }

    public void removeWorld(class_3218 world) {
        if (world == null) {
            return;
        }
        this.worlds.remove(world.getWorld().getName().toLowerCase(Locale.ROOT));
    }

    public class_3176 getServer() {
        return this.console;
    }

    @Override
    public World getWorld(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        return this.worlds.get(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public World getWorld(UUID uid) {
        for (World world : this.worlds.values()) {
            if (!world.getUID().equals(uid)) continue;
            return world;
        }
        return null;
    }

    public void addWorld(World world) {
        if (this.getWorld(world.getUID()) != null) {
            return;
        }
        this.worlds.put(world.getName().toLowerCase(Locale.ENGLISH), world);
    }

    @Override
    public WorldBorder createWorldBorder() {
        return new CraftWorldBorder(new class_2784());
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public PluginCommand getPluginCommand(String name) {
        Command command = this.commandMap.getCommand(name);
        if (command instanceof PluginCommand) {
            return (PluginCommand)command;
        }
        return null;
    }

    @Override
    public void savePlayers() {
        this.checkSaveState();
        this.playerList.method_14617();
    }

    @Override
    public boolean addRecipe(Recipe recipe) {
        CraftRecipe toAdd;
        if (recipe instanceof CraftRecipe) {
            toAdd = (CraftRecipe)recipe;
        } else if (recipe instanceof ShapedRecipe) {
            toAdd = CraftShapedRecipe.fromBukkitRecipe((ShapedRecipe)recipe);
        } else if (recipe instanceof ShapelessRecipe) {
            toAdd = CraftShapelessRecipe.fromBukkitRecipe((ShapelessRecipe)recipe);
        } else if (recipe instanceof FurnaceRecipe) {
            toAdd = CraftFurnaceRecipe.fromBukkitRecipe((FurnaceRecipe)recipe);
        } else if (recipe instanceof BlastingRecipe) {
            toAdd = CraftBlastingRecipe.fromBukkitRecipe((BlastingRecipe)recipe);
        } else if (recipe instanceof CampfireRecipe) {
            toAdd = CraftCampfireRecipe.fromBukkitRecipe((CampfireRecipe)recipe);
        } else if (recipe instanceof SmokingRecipe) {
            toAdd = CraftSmokingRecipe.fromBukkitRecipe((SmokingRecipe)recipe);
        } else if (recipe instanceof StonecuttingRecipe) {
            toAdd = CraftStonecuttingRecipe.fromBukkitRecipe((StonecuttingRecipe)recipe);
        } else if (recipe instanceof SmithingTransformRecipe) {
            toAdd = CraftSmithingTransformRecipe.fromBukkitRecipe((SmithingTransformRecipe)recipe);
        } else if (recipe instanceof SmithingTrimRecipe) {
            toAdd = CraftSmithingTrimRecipe.fromBukkitRecipe((SmithingTrimRecipe)recipe);
        } else {
            if (recipe instanceof ComplexRecipe) {
                throw new UnsupportedOperationException("Cannot add custom complex recipe");
            }
            return false;
        }
        toAdd.addToCraftingManager();
        return true;
    }

    @Override
    public List<Recipe> getRecipesFor(ItemStack result) {
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"ItemStack cannot be null");
        ArrayList<Recipe> results = new ArrayList<Recipe>();
        Iterator<Recipe> iter = this.recipeIterator();
        while (iter.hasNext()) {
            Recipe recipe = iter.next();
            ItemStack stack = recipe.getResult();
            if (stack.getType() != result.getType() || result.getDurability() != -1 && result.getDurability() != stack.getDurability()) continue;
            results.add(recipe);
        }
        return results;
    }

    @Override
    public Recipe getRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"NamespacedKey recipeKey cannot be null");
        return this.getServer().method_3772().method_8130(CraftNamespacedKey.toMinecraft(recipeKey)).map(InjectionRecipe::toBukkitRecipe).orElse(null);
    }

    @Override
    public Recipe getCraftingRecipe(ItemStack[] craftingMatrix, World world) {
        class_1703 container = new class_1703(null, -1){

            public InventoryView getBukkitView() {
                return null;
            }

            public boolean method_7597(class_1657 p_38874_) {
                return false;
            }

            public class_1799 method_7601(class_1657 entityhuman, int i) {
                return class_1799.field_8037;
            }
        };
        class_1715 inventoryCrafting = new class_1715(container, 3, 3);
        return this.getNMSRecipe(craftingMatrix, (class_8566)inventoryCrafting, (CraftWorld)world).map(InjectionRecipe::toBukkitRecipe).orElse(null);
    }

    @Override
    public ItemStack craftItem(ItemStack[] craftingMatrix, World world, Player player) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world cannot be null");
        Preconditions.checkArgument((player != null ? 1 : 0) != 0, (Object)"player cannot be null");
        CraftWorld craftWorld = (CraftWorld)world;
        CraftPlayer craftPlayer = (CraftPlayer)player;
        class_1714 container = new class_1714(-1, craftPlayer.getHandle().method_31548());
        class_8566 inventoryCrafting = container.field_7801;
        class_1731 craftResult = container.field_7800;
        Optional<class_3955> recipe = this.getNMSRecipe(craftingMatrix, inventoryCrafting, craftWorld);
        class_1799 itemstack = class_1799.field_8037;
        if (recipe.isPresent()) {
            class_3955 recipeCrafting = recipe.get();
            if (craftResult.method_7665((class_1937)craftWorld.getHandle(), craftPlayer.getHandle(), (class_1860)recipeCrafting)) {
                itemstack = recipeCrafting.method_8116((class_1263)inventoryCrafting, craftWorld.getHandle().method_30349());
            }
        }
        class_1799 result = CraftEventFactory.callPreCraftEvent((class_1263)inventoryCrafting, (class_1263)craftResult, itemstack, container.getBukkitView(), recipe.orElse(null) instanceof class_4317);
        for (int i = 0; i < craftingMatrix.length; ++i) {
            class_1792 remaining = ((class_1799)inventoryCrafting.getContents().get(i)).method_7909().method_7858();
            craftingMatrix[i] = remaining != null ? CraftItemStack.asBukkitCopy(remaining.method_7854()) : null;
        }
        return CraftItemStack.asBukkitCopy(result);
    }

    private Optional<class_3955> getNMSRecipe(ItemStack[] craftingMatrix, class_8566 inventoryCrafting, CraftWorld world) {
        Preconditions.checkArgument((craftingMatrix != null ? 1 : 0) != 0, (Object)"craftingMatrix must not be null");
        Preconditions.checkArgument((craftingMatrix.length == 9 ? 1 : 0) != 0, (Object)"craftingMatrix must be an array of length 9");
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"world must not be null");
        for (int i = 0; i < craftingMatrix.length; ++i) {
            inventoryCrafting.method_5447(i, CraftItemStack.asNMSCopy(craftingMatrix[i]));
        }
        return this.getServer().method_3772().method_8132(class_3956.field_17545, (class_1263)inventoryCrafting, (class_1937)world.getHandle());
    }

    @Override
    public Iterator<Recipe> recipeIterator() {
        return new RecipeIterator();
    }

    @Override
    public void clearRecipes() {
        this.console.method_3772().clearRecipes();
    }

    @Override
    public void resetRecipes() {
        this.reloadData();
    }

    @Override
    public boolean removeRecipe(NamespacedKey recipeKey) {
        Preconditions.checkArgument((recipeKey != null ? 1 : 0) != 0, (Object)"recipeKey == null");
        class_2960 mcKey = CraftNamespacedKey.toMinecraft(recipeKey);
        return this.getServer().method_3772().removeRecipe(mcKey);
    }

    @Override
    public Map<String, String[]> getCommandAliases() {
        ConfigurationSection section = this.commandsConfiguration.getConfigurationSection("aliases");
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        if (section != null) {
            for (String key : section.getKeys(false)) {
                ImmutableList commands = section.isList(key) ? section.getStringList(key) : ImmutableList.of((Object)section.getString(key));
                result.put(key, commands.toArray(new String[commands.size()]));
            }
        }
        return result;
    }

    public void removeBukkitSpawnRadius() {
        this.configuration.set("settings.spawn-radius", null);
        this.saveConfig();
    }

    public int getBukkitSpawnRadius() {
        return this.configuration.getInt("settings.spawn-radius", -1);
    }

    @Override
    public String getShutdownMessage() {
        return this.configuration.getString("settings.shutdown-message");
    }

    @Override
    public int getSpawnRadius() {
        return this.getServer().method_3841();
    }

    @Override
    public void setSpawnRadius(int value) {
        this.configuration.set("settings.spawn-radius", value);
        this.saveConfig();
    }

    @Override
    public boolean shouldSendChatPreviews() {
        return false;
    }

    @Override
    public boolean isEnforcingSecureProfiles() {
        return this.getServer().method_43500();
    }

    @Override
    public boolean getHideOnlinePlayers() {
        return this.console.method_39424();
    }

    @Override
    public boolean getOnlineMode() {
        return this.console.method_3828();
    }

    @Override
    public boolean getAllowFlight() {
        return this.console.method_3718();
    }

    @Override
    public boolean isHardcore() {
        return this.console.method_3754();
    }

    public ChunkGenerator getGenerator(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        ChunkGenerator result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("generator")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultWorldGenerator(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world generator");
                    }
                }
                catch (Throwable t) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set generator for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t);
                }
            }
        }
        return result;
    }

    public BiomeProvider getBiomeProvider(String world) {
        String name;
        ConfigurationSection section = this.configuration.getConfigurationSection("worlds");
        BiomeProvider result = null;
        if (section != null && (section = section.getConfigurationSection(world)) != null && (name = section.getString("biome-provider")) != null && !name.equals("")) {
            String[] split = name.split(":", 2);
            String id = split.length > 1 ? split[1] : null;
            Plugin plugin = this.pluginManager.getPlugin(split[0]);
            if (plugin == null) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + split[0] + "' does not exist");
            } else if (!plugin.isEnabled()) {
                this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' is not enabled yet (is it load:STARTUP?)");
            } else {
                try {
                    result = plugin.getDefaultBiomeProvider(world, id);
                    if (result == null) {
                        this.getLogger().severe("Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName() + "' lacks a default world biome provider");
                    }
                }
                catch (Throwable t) {
                    plugin.getLogger().log(Level.SEVERE, "Could not set biome provider for default world '" + world + "': Plugin '" + plugin.getDescription().getFullName(), t);
                }
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public CraftMapView getMap(int id) {
        class_22 worldmap = this.console.method_3847(class_1937.field_25179).method_17891("map_" + id);
        if (worldmap == null) {
            return null;
        }
        return worldmap.bridge$mapView();
    }

    @Override
    public CraftMapView createMap(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        class_3218 minecraftWorld = ((CraftWorld)world).getHandle();
        int newId = class_1806.method_32349((class_1937)minecraftWorld, (int)minecraftWorld.method_8401().method_215(), (int)minecraftWorld.method_8401().method_166(), (int)3, (boolean)false, (boolean)false, (class_5321)minecraftWorld.method_27983());
        return minecraftWorld.method_17891(class_1806.method_17440((int)newId)).bridge$mapView();
    }

    @Override
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType) {
        return this.createExplorerMap(world, location, structureType, 100, true);
    }

    @Override
    public ItemStack createExplorerMap(World world, Location location, StructureType structureType, int radius, boolean findUnexplored) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        Preconditions.checkArgument((structureType != null ? 1 : 0) != 0, (Object)"StructureType cannot be null");
        Preconditions.checkArgument((structureType.getMapIcon() != null ? 1 : 0) != 0, (String)"Cannot create explorer maps for StructureType %s", (Object)structureType.getName());
        class_3218 worldServer = ((CraftWorld)world).getHandle();
        Location structureLocation = world.locateNearestStructure(location, structureType, radius, findUnexplored);
        class_2338 structurePosition = CraftLocation.toBlockPosition(structureLocation);
        class_1799 stack = class_1806.method_8005((class_1937)worldServer, (int)structurePosition.method_10263(), (int)structurePosition.method_10260(), (byte)MapView.Scale.NORMAL.getValue(), (boolean)true, (boolean)true);
        class_1806.method_8002((class_3218)worldServer, (class_1799)stack);
        class_1806.method_8001((class_1799)stack, (class_1937)worldServer);
        class_22.method_110((class_1799)stack, (class_2338)structurePosition, (String)"+", (class_20.class_21)class_20.class_21.method_99((byte)structureType.getMapIcon().getValue()));
        return CraftItemStack.asBukkitCopy(stack);
    }

    @Override
    public void shutdown() {
        this.console.method_3747(false);
    }

    @Override
    public int broadcast(String message, String permission) {
        HashSet<CommandSender> recipients = new HashSet<CommandSender>();
        for (Permissible permissible : this.getPluginManager().getPermissionSubscriptions(permission)) {
            if (!(permissible instanceof CommandSender) || !permissible.hasPermission(permission)) continue;
            recipients.add((CommandSender)permissible);
        }
        BroadcastMessageEvent broadcastMessageEvent = new BroadcastMessageEvent(!Bukkit.isPrimaryThread(), message, recipients);
        this.getPluginManager().callEvent(broadcastMessageEvent);
        if (broadcastMessageEvent.isCancelled()) {
            return 0;
        }
        message = broadcastMessageEvent.getMessage();
        for (CommandSender recipient : recipients) {
            recipient.sendMessage(message);
        }
        return recipients.size();
    }

    @Override
    @Deprecated
    public OfflinePlayer getOfflinePlayer(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name cannot be null");
        Preconditions.checkArgument((!name.isBlank() ? 1 : 0) != 0, (Object)"name cannot be empty");
        OfflinePlayer result = this.getPlayerExact(name);
        if (result == null) {
            GameProfile profile = null;
            if (this.getOnlineMode() || SpigotConfig.bungee) {
                profile = this.console.method_3793().method_14515(name).orElse(null);
            }
            result = profile == null ? this.getOfflinePlayer(new GameProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)), name)) : this.getOfflinePlayer(profile);
        } else {
            this.offlinePlayers.remove(result.getUniqueId());
        }
        return result;
    }

    @Override
    public OfflinePlayer getOfflinePlayer(UUID id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        OfflinePlayer result = this.getPlayer(id);
        if (result == null) {
            result = this.offlinePlayers.get(id);
            if (result == null) {
                result = new CraftOfflinePlayer(this, new GameProfile(id, null));
                this.offlinePlayers.put(id, result);
            }
        } else {
            this.offlinePlayers.remove(id);
        }
        return result;
    }

    @Override
    public PlayerProfile createPlayerProfile(UUID uniqueId, String name) {
        return new CraftPlayerProfile(uniqueId, name);
    }

    @Override
    public PlayerProfile createPlayerProfile(UUID uniqueId) {
        return new CraftPlayerProfile(uniqueId, null);
    }

    @Override
    public PlayerProfile createPlayerProfile(String name) {
        return new CraftPlayerProfile(null, name);
    }

    public OfflinePlayer getOfflinePlayer(GameProfile profile) {
        CraftOfflinePlayer player = new CraftOfflinePlayer(this, profile);
        this.offlinePlayers.put(profile.getId(), player);
        return player;
    }

    @Override
    public Set<String> getIPBans() {
        return this.playerList.method_14585().method_14632().stream().map(class_3330::method_14626).collect(Collectors.toSet());
    }

    @Override
    public void banIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).addBan((String)address, (String)null, (Date)null, (String)null);
    }

    @Override
    public void unbanIP(String address) {
        Preconditions.checkArgument((address != null && !address.isBlank() ? 1 : 0) != 0, (Object)"Address cannot be null or blank.");
        this.getBanList(BanList.Type.IP).pardon(address);
    }

    @Override
    public void banIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).addBan(address, (String)null, (Date)null, (String)null);
    }

    @Override
    public void unbanIP(InetAddress address) {
        Preconditions.checkArgument((address != null ? 1 : 0) != 0, (Object)"Address cannot be null.");
        ((CraftIpBanList)this.getBanList(BanList.Type.IP)).pardon(address);
    }

    @Override
    public Set<OfflinePlayer> getBannedPlayers() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (class_3336 entry : this.playerList.method_14563().method_14632()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.method_14626()));
        }
        return result;
    }

    @Override
    public <T extends BanList<?>> T getBanList(BanList.Type type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"BanList.Type cannot be null");
        return (T)(switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case BanList.Type.IP -> new CraftIpBanList(this.playerList.method_14585());
            case BanList.Type.PROFILE, BanList.Type.NAME -> new CraftProfileBanList(this.playerList.method_14563());
        });
    }

    @Override
    public void setWhitelist(boolean value) {
        this.playerList.method_14557(value);
        this.console.method_16712(value);
    }

    @Override
    public boolean isWhitelistEnforced() {
        return this.console.method_3729();
    }

    @Override
    public void setWhitelistEnforced(boolean value) {
        this.console.method_3731(value);
    }

    @Override
    public Set<OfflinePlayer> getWhitelistedPlayers() {
        LinkedHashSet<OfflinePlayer> result = new LinkedHashSet<OfflinePlayer>();
        for (class_3340 entry : this.playerList.method_14590().method_14632()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.method_14626()));
        }
        return result;
    }

    @Override
    public Set<OfflinePlayer> getOperators() {
        HashSet<OfflinePlayer> result = new HashSet<OfflinePlayer>();
        for (class_3327 entry : this.playerList.method_14603().method_14632()) {
            result.add(this.getOfflinePlayer((GameProfile)entry.method_14626()));
        }
        return result;
    }

    @Override
    public void reloadWhitelist() {
        this.playerList.method_14599();
    }

    @Override
    public GameMode getDefaultGameMode() {
        return GameMode.getByValue(this.console.method_3847((class_5321)class_1937.field_25179).field_24456.method_210().method_8379());
    }

    @Override
    public void setDefaultGameMode(GameMode mode) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"GameMode cannot be null");
        for (World world : this.getWorlds()) {
            ((CraftWorld)world).getHandle().field_24456.method_193(class_1934.method_8384((int)mode.getValue()));
        }
    }

    @Override
    public ConsoleCommandSender getConsoleSender() {
        return this.console.bridge$console();
    }

    public EntityMetadataStore getEntityMetadata() {
        return this.entityMetadata;
    }

    public PlayerMetadataStore getPlayerMetadata() {
        return this.playerMetadata;
    }

    public WorldMetadataStore getWorldMetadata() {
        return this.worldMetadata;
    }

    @Override
    public File getWorldContainer() {
        return this.getServer().field_23784.method_27424(class_1937.field_25179).getParent().toFile();
    }

    @Override
    public OfflinePlayer[] getOfflinePlayers() {
        class_29 storage = this.console.field_24371;
        String[] files = storage.getPlayerDir().list(new DatFileFilter());
        HashSet<OfflinePlayer> players = new HashSet<OfflinePlayer>();
        for (String file : files) {
            try {
                players.add(this.getOfflinePlayer(UUID.fromString(file.substring(0, file.length() - 4))));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        players.addAll(this.getOnlinePlayers());
        return players.toArray(new OfflinePlayer[players.size()]);
    }

    @Override
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.getMessenger(), source, channel, message);
        for (Player player : this.getOnlinePlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getOnlinePlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)((Object)type));
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, InventoryType type, String title) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"InventoryType cannot be null");
        Preconditions.checkArgument((boolean)type.isCreatable(), (String)"InventoryType.%s cannot be used to create a inventory", (Object)((Object)type));
        Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"title cannot be null");
        return CraftInventoryCreator.INSTANCE.createInventory(owner, type, title);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, int size) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size);
    }

    @Override
    public Inventory createInventory(InventoryHolder owner, int size, String title) throws IllegalArgumentException {
        Preconditions.checkArgument((9 <= size && size <= 54 && size % 9 == 0 ? 1 : 0) != 0, (String)"Size for custom inventory must be a multiple of 9 between 9 and 54 slots (got %s)", (int)size);
        return CraftInventoryCreator.INSTANCE.createInventory(owner, size, title);
    }

    @Override
    public Merchant createMerchant(String title) {
        return new CraftMerchantCustom(title == null ? InventoryType.MERCHANT.getDefaultTitle() : title);
    }

    @Override
    public int getMaxChainedNeighborUpdates() {
        return this.getServer().method_41239();
    }

    @Override
    public HelpMap getHelpMap() {
        return this.helpMap;
    }

    public SimpleCommandMap getCommandMap() {
        return this.commandMap;
    }

    @Override
    @Deprecated
    public int getMonsterSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.MONSTER);
    }

    @Override
    @Deprecated
    public int getAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.ANIMAL);
    }

    @Override
    @Deprecated
    public int getWaterAnimalSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_ANIMAL);
    }

    @Override
    @Deprecated
    public int getWaterAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_AMBIENT);
    }

    @Override
    @Deprecated
    public int getWaterUndergroundCreatureSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.WATER_UNDERGROUND_CREATURE);
    }

    @Override
    @Deprecated
    public int getAmbientSpawnLimit() {
        return this.getSpawnLimit(SpawnCategory.AMBIENT);
    }

    @Override
    public int getSpawnLimit(SpawnCategory spawnCategory) {
        return this.spawnCategoryLimit.getOrDefault((Object)spawnCategory, -1);
    }

    @Override
    public boolean isPrimaryThread() {
        return Thread.currentThread().equals(this.console.field_16257);
    }

    @Override
    public String getMotd() {
        return this.console.method_3818();
    }

    @Override
    public void setMotd(String motd) {
        this.console.method_3834(motd);
    }

    @Override
    public Warning.WarningState getWarningState() {
        return this.warningState;
    }

    public List<String> tabComplete(CommandSender sender, String message, class_3218 world, class_243 pos, boolean forceCommand) {
        if (!(sender instanceof Player)) {
            return ImmutableList.of();
        }
        Player player = (Player)sender;
        List<String> offers = message.startsWith("/") || forceCommand ? this.tabCompleteCommand(player, message, world, pos) : this.tabCompleteChat(player, message);
        TabCompleteEvent tabEvent = new TabCompleteEvent(player, message, offers);
        this.getPluginManager().callEvent(tabEvent);
        return tabEvent.isCancelled() ? Collections.EMPTY_LIST : tabEvent.getCompletions();
    }

    public List<String> tabCompleteCommand(Player player, String message, class_3218 world, class_243 pos) {
        if (!(SpigotConfig.tabComplete >= 0 && message.length() > SpigotConfig.tabComplete || message.contains(" "))) {
            return ImmutableList.of();
        }
        List<String> completions = null;
        try {
            if (message.startsWith("/")) {
                message = message.substring(1);
            }
            completions = pos == null ? this.getCommandMap().tabComplete(player, message) : this.getCommandMap().tabComplete(player, message, CraftLocation.toBukkit(pos, (World)world.getWorld()));
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to tab-complete this command");
            this.getLogger().log(Level.SEVERE, "Exception when " + player.getName() + " attempted to tab complete " + message, ex);
        }
        return completions == null ? ImmutableList.of() : completions;
    }

    public List<String> tabCompleteChat(Player player, String message) {
        ArrayList<String> completions = new ArrayList<String>();
        PlayerChatTabCompleteEvent event = new PlayerChatTabCompleteEvent(player, message, completions);
        String token = event.getLastToken();
        for (Player p : this.getOnlinePlayers()) {
            if (!player.canSee(p) || !StringUtil.startsWithIgnoreCase(p.getName(), token)) continue;
            completions.add(p.getName());
        }
        this.pluginManager.callEvent(event);
        Iterator it = completions.iterator();
        while (it.hasNext()) {
            Object current = it.next();
            if (current instanceof String) continue;
            it.remove();
        }
        Collections.sort(completions, String.CASE_INSENSITIVE_ORDER);
        return completions;
    }

    @Override
    public CraftItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    @Override
    public CraftScoreboardManager getScoreboardManager() {
        return this.scoreboardManager;
    }

    @Override
    public Criteria getScoreboardCriteria(String name) {
        return CraftCriteria.getFromBukkit(name);
    }

    public void checkSaveState() {
        if (this.playerCommandState || this.printSaveWarning) {
            return;
        }
        this.printSaveWarning = true;
        this.getLogger().log(Level.WARNING, "A manual (plugin-induced) save has been detected while server is configured to auto-save. This may affect performance.", this.warningState == Warning.WarningState.ON ? new Throwable() : null);
    }

    @Override
    public CraftIconCache getServerIcon() {
        return this.icon;
    }

    @Override
    public CraftIconCache loadServerIcon(File file) throws Exception {
        Preconditions.checkArgument((file != null ? 1 : 0) != 0, (Object)"File cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (String)"File (%s) is not a valid file", (Object)file);
        return CraftServer.loadServerIcon0(file);
    }

    static CraftIconCache loadServerIcon0(File file) throws Exception {
        return CraftServer.loadServerIcon0(ImageIO.read(file));
    }

    @Override
    public CraftIconCache loadServerIcon(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)"BufferedImage image cannot be null");
        return CraftServer.loadServerIcon0(image);
    }

    static CraftIconCache loadServerIcon0(BufferedImage image) throws Exception {
        Preconditions.checkArgument((image.getWidth() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels wide (%s)", (int)image.getWidth());
        Preconditions.checkArgument((image.getHeight() == 64 ? 1 : 0) != 0, (String)"BufferedImage must be 64 pixels high (%s)", (int)image.getHeight());
        ByteArrayOutputStream bytebuf = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", bytebuf);
        return new CraftIconCache(bytebuf.toByteArray());
    }

    @Override
    public void setIdleTimeout(int threshold) {
        this.console.method_3803(threshold);
    }

    @Override
    public int getIdleTimeout() {
        return this.console.method_3862();
    }

    @Override
    public ChunkGenerator.ChunkData createChunkData(World world) {
        Preconditions.checkArgument((world != null ? 1 : 0) != 0, (Object)"World cannot be null");
        class_3218 handle = ((CraftWorld)world).getHandle();
        return new OldCraftChunkData(world.getMinHeight(), world.getMaxHeight(), (class_2378<class_1959>)handle.method_30349().method_30530(class_7924.field_41236));
    }

    @Override
    public BossBar createBossBar(String title, BarColor color, BarStyle style, BarFlag ... flags) {
        return new CraftBossBar(title, color, style, flags);
    }

    @Override
    public KeyedBossBar createBossBar(NamespacedKey key, String title, BarColor barColor, BarStyle barStyle, BarFlag ... barFlags) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        Preconditions.checkArgument((barColor != null ? 1 : 0) != 0, (Object)"BarColor key cannot be null");
        Preconditions.checkArgument((barStyle != null ? 1 : 0) != 0, (Object)"BarStyle key cannot be null");
        class_3002 bossBattleCustom = this.getServer().method_3837().method_12970(CraftNamespacedKey.toMinecraft(key), CraftChatMessage.fromString(title, true)[0]);
        CraftKeyedBossbar craftKeyedBossbar = new CraftKeyedBossbar(bossBattleCustom);
        craftKeyedBossbar.setColor(barColor);
        craftKeyedBossbar.setStyle(barStyle);
        for (BarFlag flag : barFlags) {
            if (flag == null) continue;
            craftKeyedBossbar.addFlag(flag);
        }
        return craftKeyedBossbar;
    }

    @Override
    public Iterator<KeyedBossBar> getBossBars() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.getServer().method_3837().method_12969().iterator(), (Function)new Function<class_3002, KeyedBossBar>(){

            public KeyedBossBar apply(class_3002 bossBattleCustom) {
                return bossBattleCustom.getBukkitEntity();
            }
        }));
    }

    @Override
    public KeyedBossBar getBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        class_3002 bossBattleCustom = this.getServer().method_3837().method_12971(CraftNamespacedKey.toMinecraft(key));
        return bossBattleCustom == null ? null : bossBattleCustom.getBukkitEntity();
    }

    @Override
    public boolean removeBossBar(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key");
        class_3004 bossBattleCustomData = this.getServer().method_3837();
        class_3002 bossBattleCustom = bossBattleCustomData.method_12971(CraftNamespacedKey.toMinecraft(key));
        if (bossBattleCustom != null) {
            bossBattleCustomData.method_12973(bossBattleCustom);
            return true;
        }
        return false;
    }

    @Override
    public Entity getEntity(UUID uuid) {
        Preconditions.checkArgument((uuid != null ? 1 : 0) != 0, (Object)"UUID id cannot be null");
        for (class_3218 world : this.getServer().method_3738()) {
            class_1297 entity = world.method_14190(uuid);
            if (entity == null) continue;
            return entity.getBukkitEntity();
        }
        return null;
    }

    @Override
    @NotNull
    public double[] getTPS() {
        return new double[0];
    }

    @Override
    public Advancement getAdvancement(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        class_161 advancement = this.console.method_3851().method_12896(CraftNamespacedKey.toMinecraft(key));
        return advancement == null ? null : advancement.bridge$bukkit();
    }

    @Override
    public Iterator<Advancement> advancementIterator() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.transform(this.console.method_3851().method_12893().iterator(), (Function)new Function<class_161, Advancement>(){

            public Advancement apply(class_161 advancement) {
                return advancement.bridge$bukkit();
            }
        }));
    }

    @Override
    public BlockData createBlockData(Material material) {
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"Material cannot be null");
        return this.createBlockData(material, (String)null);
    }

    @Override
    public BlockData createBlockData(Material material, Consumer<BlockData> consumer) {
        BlockData data = this.createBlockData(material);
        if (consumer != null) {
            consumer.accept(data);
        }
        return data;
    }

    @Override
    public BlockData createBlockData(String data) throws IllegalArgumentException {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"data cannot be null");
        return this.createBlockData(null, data);
    }

    @Override
    public BlockData createBlockData(Material material, String data) {
        Preconditions.checkArgument((material != null || data != null ? 1 : 0) != 0, (Object)"Must provide one of material or data");
        return CraftBlockData.newData(material, data);
    }

    @Override
    public <T extends Keyed> Tag<T> getTag(String registry, NamespacedKey tag, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((tag != null ? 1 : 0) != 0, (Object)"NamespacedKey tag cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        class_2960 key = CraftNamespacedKey.toMinecraft(tag);
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                class_6862 blockTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)key);
                if (!class_7923.field_41175.method_40266(blockTagKey).isPresent()) break;
                return new CraftBlockTag((class_2378<class_2248>)class_7923.field_41175, (class_6862<class_2248>)blockTagKey);
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                class_6862 itemTagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)key);
                if (!class_7923.field_41178.method_40266(itemTagKey).isPresent()) break;
                return new CraftItemTag((class_2378<class_1792>)class_7923.field_41178, (class_6862<class_1792>)itemTagKey);
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Fluid.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                class_6862 fluidTagKey = class_6862.method_40092((class_5321)class_7924.field_41270, (class_2960)key);
                if (!class_7923.field_41173.method_40266(fluidTagKey).isPresent()) break;
                return new CraftFluidTag((class_2378<class_3611>)class_7923.field_41173, (class_6862<class_3611>)fluidTagKey);
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                class_6862 entityTagKey = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)key);
                if (!class_7923.field_41177.method_40266(entityTagKey).isPresent()) break;
                return new CraftEntityTag((class_2378<class_1299<?>>)class_7923.field_41177, (class_6862<class_1299<?>>)entityTagKey);
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return null;
    }

    @Override
    public <T extends Keyed> Iterable<Tag<T>> getTags(String registry, Class<T> clazz) {
        Preconditions.checkArgument((registry != null ? 1 : 0) != 0, (Object)"registry cannot be null");
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Class clazz cannot be null");
        switch (registry) {
            case "blocks": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Block namespace (%s) must have material type", (Object)clazz.getName());
                class_7922 blockTags = class_7923.field_41175;
                return (Iterable)blockTags.method_40272().map(arg_0 -> CraftServer.lambda$getTags$1((class_2378)blockTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
            case "items": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Item namespace (%s) must have material type", (Object)clazz.getName());
                class_7922 itemTags = class_7923.field_41178;
                return (Iterable)itemTags.method_40272().map(arg_0 -> CraftServer.lambda$getTags$2((class_2378)itemTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
            case "fluids": {
                Preconditions.checkArgument((clazz == Material.class ? 1 : 0) != 0, (String)"Fluid namespace (%s) must have fluid type", (Object)clazz.getName());
                class_7922 fluidTags = class_7923.field_41173;
                return (Iterable)fluidTags.method_40272().map(arg_0 -> CraftServer.lambda$getTags$3((class_2378)fluidTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
            case "entity_types": {
                Preconditions.checkArgument((clazz == EntityType.class ? 1 : 0) != 0, (String)"Entity type namespace (%s) must have entity type", (Object)clazz.getName());
                class_7922 entityTags = class_7923.field_41177;
                return (Iterable)entityTags.method_40272().map(arg_0 -> CraftServer.lambda$getTags$4((class_2378)entityTags, arg_0)).collect(ImmutableList.toImmutableList());
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LootTable getLootTable(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"NamespacedKey key cannot be null");
        class_60 registry = this.getServer().method_3857();
        return new CraftLootTable(key, registry.getLootTable(CraftNamespacedKey.toMinecraft(key)));
    }

    @Override
    public List<Entity> selectEntities(CommandSender sender, String selector) {
        List nms;
        Preconditions.checkArgument((selector != null ? 1 : 0) != 0, (Object)"selector cannot be null");
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0, (Object)"CommandSender sender cannot be null");
        class_2186 arg = class_2186.method_9306();
        try {
            StringReader reader = new StringReader(selector);
            nms = arg.parse(reader, true).method_9816(VanillaCommandWrapper.getListener(sender));
            Preconditions.checkArgument((!reader.canRead() ? 1 : 0) != 0, (String)"Spurious trailing data in selector: %s", (Object)selector);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException("Could not parse selector: " + selector, ex);
        }
        return new ArrayList<Entity>(Lists.transform((List)nms, entity -> entity.getBukkitEntity()));
    }

    @Override
    public StructureManager getStructureManager() {
        return this.structureManager;
    }

    @Override
    public <T extends Keyed> Registry<T> getRegistry(Class<T> aClass) {
        return this.registries.computeIfAbsent(aClass, key -> CraftRegistry.createRegistry(aClass, (class_5455)this.console.method_30611()));
    }

    @Override
    @Deprecated
    public UnsafeValues getUnsafe() {
        return CraftMagicNumbers.INSTANCE;
    }

    @Override
    public Server.Spigot spigot() {
        return this.spigot;
    }

    private static /* synthetic */ Tag lambda$getTags$4(class_2378 entityTags, Pair pair) {
        return new CraftEntityTag((class_2378<class_1299<?>>)entityTags, (class_6862<class_1299<?>>)((class_6862)pair.getFirst()));
    }

    private static /* synthetic */ Tag lambda$getTags$3(class_2378 fluidTags, Pair pair) {
        return new CraftFluidTag((class_2378<class_3611>)fluidTags, (class_6862<class_3611>)((class_6862)pair.getFirst()));
    }

    private static /* synthetic */ Tag lambda$getTags$2(class_2378 itemTags, Pair pair) {
        return new CraftItemTag((class_2378<class_1792>)itemTags, (class_6862<class_1792>)((class_6862)pair.getFirst()));
    }

    private static /* synthetic */ Tag lambda$getTags$1(class_2378 blockTags, Pair pair) {
        return new CraftBlockTag((class_2378<class_2248>)blockTags, (class_6862<class_2248>)((class_6862)pair.getFirst()));
    }

    static {
        ConfigurationSerialization.registerClass(CraftOfflinePlayer.class);
        ConfigurationSerialization.registerClass(CraftPlayerProfile.class);
        CraftItemFactory.instance();
    }
}

