/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.block;

import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.TileState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftBlockEntityState<T extends class_2586>
extends CraftBlockState
implements TileState {
    private final T tileEntity;
    private final T snapshot;

    public CraftBlockEntityState(World world, T tileEntity) {
        super(world, tileEntity.method_11016(), tileEntity.method_11010());
        this.tileEntity = tileEntity;
        this.snapshot = this.createSnapshot(tileEntity);
        this.load(this.snapshot);
    }

    public void refreshSnapshot() {
        this.load(this.tileEntity);
    }

    private T createSnapshot(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        class_2487 nbtTagCompound = tileEntity.method_38242();
        class_2586 snapshot = class_2586.method_11005((class_2338)this.getPosition(), (class_2680)this.getHandle(), (class_2487)nbtTagCompound);
        return (T)snapshot;
    }

    private void copyData(T from, T to) {
        class_2487 nbtTagCompound = from.method_38242();
        to.method_11014(nbtTagCompound);
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    protected T getSnapshot() {
        return this.snapshot;
    }

    protected class_2586 getTileEntityFromWorld() {
        this.requirePlaced();
        return this.getWorldHandle().method_8321(this.getPosition());
    }

    public class_2487 getSnapshotNBT() {
        this.applyTo(this.snapshot);
        return this.snapshot.method_38242();
    }

    protected void load(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(tileEntity, this.snapshot);
        }
    }

    protected void applyTo(T tileEntity) {
        if (tileEntity != null && tileEntity != this.snapshot) {
            this.copyData(this.snapshot, tileEntity);
        }
    }

    protected boolean isApplicable(class_2586 tileEntity) {
        return tileEntity != null && this.tileEntity.getClass() == tileEntity.getClass();
    }

    @Override
    public boolean update(boolean force, boolean applyPhysics) {
        class_2586 tile;
        boolean result = super.update(force, applyPhysics);
        if (result && this.isPlaced() && this.isApplicable(tile = this.getTileEntityFromWorld())) {
            this.applyTo(tile);
            tile.method_5431();
        }
        return result;
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.getSnapshot().bridge$persistentDataContainer();
    }

    @Nullable
    public class_2596<class_2602> getUpdatePacket(@NotNull Location location) {
        class_2586 vanillaTileEntitiy = class_2586.method_11005((class_2338)CraftLocation.toBlockPosition(location), (class_2680)this.getHandle(), (class_2487)this.getSnapshotNBT());
        return class_2622.method_38585((class_2586)vanillaTileEntitiy);
    }
}

