/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_20_R1.event;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mohistmc.banner.fabric.FabricInjectBukkit;
import com.mohistmc.banner.injection.world.entity.InjectionEntity;
import com.mojang.datafixers.util.Either;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1422;
import net.minecraft.class_1427;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1510;
import net.minecraft.class_1542;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1617;
import net.minecraft.class_1621;
import net.minecraft.class_1646;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_1686;
import net.minecraft.class_1703;
import net.minecraft.class_1728;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1838;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2815;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3763;
import net.minecraft.class_3765;
import net.minecraft.class_3902;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_47;
import net.minecraft.class_4836;
import net.minecraft.class_4985;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_8103;
import net.minecraft.class_8110;
import net.minecraft.class_8111;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.Server;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_20_R1.CraftRaid;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftStatistic;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftRaider;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftSpellcaster;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftInventoryCrafting;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_20_R1.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftVector;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Animals;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Item;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BellResonateEvent;
import org.bukkit.event.block.BellRingEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.BlockShearEntityEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.MoistureChangeEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.ArrowBodyCountChangeEvent;
import org.bukkit.event.entity.BatToggleSleepEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.EntitySpellCastEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.EntityToggleGlideEvent;
import org.bukkit.event.entity.EntityToggleSwimEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.ExpBottleEvent;
import org.bukkit.event.entity.FireworkExplodeEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.HorseJumpEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemMergeEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PiglinBarterEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.event.entity.StriderTemperatureChangeEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerBucketEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerBucketFishEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerLevelChangeEvent;
import org.bukkit.event.player.PlayerRecipeDiscoverEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.event.player.PlayerStatisticIncrementEvent;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidSpawnWaveEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.LootGenerateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class CraftEventFactory {
    public static final class_5321<class_8110> MELTING = class_8111.field_42337;
    public static final class_5321<class_8110> POISON = class_8111.field_42349;
    public static Block blockDamage;
    public static class_1297 entityDamage;
    public static class_2338 sourceBlockOverride;
    private static final com.google.common.base.Function<? super Double, Double> ZERO;

    private static boolean canBuild(class_3218 world, Player player, int x, int z) {
        int spawnSize = Bukkit.getServer().getSpawnRadius();
        if (world.method_27983() != class_1937.field_25179) {
            return true;
        }
        if (spawnSize <= 0) {
            return true;
        }
        if (((CraftServer)Bukkit.getServer()).getHandle().method_14603().method_14641()) {
            return true;
        }
        if (player.isOp()) {
            return true;
        }
        class_2338 chunkcoordinates = world.method_43126();
        int distanceFromSpawn = Math.max(Math.abs(x - chunkcoordinates.method_10263()), Math.abs(z - chunkcoordinates.method_10260()));
        return distanceFromSpawn > spawnSize;
    }

    public static <T extends Event> T callEvent(T event) {
        Bukkit.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static Either<class_1657.class_1658, class_3902> callPlayerBedEnterEvent(class_1657 player, class_2338 bed, Either<class_1657.class_1658, class_3902> nmsBedResult) {
        PlayerBedEnterEvent.BedEnterResult bedEnterResult = (PlayerBedEnterEvent.BedEnterResult)((Object)nmsBedResult.mapBoth((Function)new com.google.common.base.Function<class_1657.class_1658, PlayerBedEnterEvent.BedEnterResult>(){

            public PlayerBedEnterEvent.BedEnterResult apply(class_1657.class_1658 t) {
                switch (t) {
                    case field_7528: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_HERE;
                    }
                    case field_7529: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_POSSIBLE_NOW;
                    }
                    case field_7530: {
                        return PlayerBedEnterEvent.BedEnterResult.TOO_FAR_AWAY;
                    }
                    case field_7532: {
                        return PlayerBedEnterEvent.BedEnterResult.NOT_SAFE;
                    }
                }
                return PlayerBedEnterEvent.BedEnterResult.OTHER_PROBLEM;
            }
        }, t -> PlayerBedEnterEvent.BedEnterResult.OK).map(Function.identity(), Function.identity()));
        PlayerBedEnterEvent event = new PlayerBedEnterEvent((Player)((Object)player.getBukkitEntity()), CraftBlock.at((class_1936)player.method_37908(), bed), bedEnterResult);
        Bukkit.getServer().getPluginManager().callEvent(event);
        Event.Result result = event.useBed();
        if (result == Event.Result.ALLOW) {
            return Either.right((Object)class_3902.field_17274);
        }
        if (result == Event.Result.DENY) {
            return Either.left((Object)class_1657.class_1658.field_7531);
        }
        return nmsBedResult;
    }

    public static EntityEnterLoveModeEvent callEntityEnterLoveModeEvent(class_1657 entityHuman, class_1429 entityAnimal, int loveTicks) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = new EntityEnterLoveModeEvent((Animals)((Object)entityAnimal.getBukkitEntity()), entityHuman != null ? entityHuman.getBukkitEntity() : null, loveTicks);
        Bukkit.getPluginManager().callEvent(entityEnterLoveModeEvent);
        return entityEnterLoveModeEvent;
    }

    public static PlayerHarvestBlockEvent callPlayerHarvestBlockEvent(class_1937 world, class_2338 blockposition, class_1657 who, class_1268 enumhand, List<class_1799> itemsToHarvest) {
        ArrayList<ItemStack> bukkitItemsToHarvest = new ArrayList<ItemStack>(itemsToHarvest.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Player player = (Player)((Object)who.getBukkitEntity());
        PlayerHarvestBlockEvent playerHarvestBlockEvent = new PlayerHarvestBlockEvent(player, CraftBlock.at((class_1936)world, blockposition), CraftEquipmentSlot.getHand(enumhand), bukkitItemsToHarvest);
        Bukkit.getPluginManager().callEvent(playerHarvestBlockEvent);
        return playerHarvestBlockEvent;
    }

    public static PlayerBucketEntityEvent callPlayerFishBucketEvent(class_1309 fish, class_1657 entityHuman, class_1799 originalBucket, class_1799 entityBucket, class_1268 enumhand) {
        Player player = (Player)((Object)entityHuman.getBukkitEntity());
        EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        PlayerBucketEntityEvent event = fish instanceof class_1422 ? new PlayerBucketFishEvent(player, (Fish)((Object)fish.getBukkitEntity()), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), hand) : new PlayerBucketEntityEvent(player, fish.getBukkitEntity(), CraftItemStack.asBukkitCopy(originalBucket), CraftItemStack.asBukkitCopy(entityBucket), hand);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static TradeSelectEvent callTradeSelectEvent(class_3222 player, int newIndex, class_1728 merchant) {
        TradeSelectEvent tradeSelectEvent = new TradeSelectEvent(merchant.getBukkitView(), newIndex);
        Bukkit.getPluginManager().callEvent(tradeSelectEvent);
        return tradeSelectEvent;
    }

    public static boolean handleBellRingEvent(class_1937 world, class_2338 position, class_2350 direction, class_1297 entity) {
        CraftBlock block = CraftBlock.at((class_1936)world, position);
        BlockFace bukkitDirection = CraftBlock.notchToBlockFace(direction);
        BellRingEvent event = new BellRingEvent(block, bukkitDirection, entity != null ? entity.getBukkitEntity() : null);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static Stream<class_1309> handleBellResonateEvent(class_1937 world, class_2338 position, List<LivingEntity> bukkitEntities) {
        CraftBlock block = CraftBlock.at((class_1936)world, position);
        BellResonateEvent event = new BellResonateEvent(block, bukkitEntities);
        Bukkit.getPluginManager().callEvent(event);
        return event.getResonatedEntities().stream().map(bukkitEntity -> ((CraftLivingEntity)bukkitEntity).getHandle());
    }

    public static BlockMultiPlaceEvent callBlockMultiPlaceEvent(class_3218 world, class_1657 who, class_1268 hand, List<BlockState> blockStates, int clickedX, int clickedY, int clickedZ) {
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getCraftServer();
        Player player = (Player)((Object)who.getBukkitEntity());
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        boolean canBuild = true;
        for (int i = 0; i < blockStates.size(); ++i) {
            if (CraftEventFactory.canBuild(world, player, blockStates.get(i).getX(), blockStates.get(i).getZ())) continue;
            canBuild = false;
            break;
        }
        ItemStack item = hand == class_1268.field_5808 ? player.getInventory().getItemInMainHand() : player.getInventory().getItemInOffHand();
        BlockMultiPlaceEvent event = new BlockMultiPlaceEvent(blockStates, blockClicked, item, player, canBuild);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockPlaceEvent callBlockPlaceEvent(class_3218 world, class_1657 who, class_1268 hand, BlockState replacedBlockState, int clickedX, int clickedY, int clickedZ) {
        EquipmentSlot equipmentSlot;
        ItemStack item;
        CraftWorld craftWorld = world.getWorld();
        CraftServer craftServer = world.getCraftServer();
        Player player = (Player)((Object)who.getBukkitEntity());
        Block blockClicked = craftWorld.getBlockAt(clickedX, clickedY, clickedZ);
        Block placedBlock = replacedBlockState.getBlock();
        boolean canBuild = CraftEventFactory.canBuild(world, player, placedBlock.getX(), placedBlock.getZ());
        if (hand == class_1268.field_5808) {
            item = player.getInventory().getItemInMainHand();
            equipmentSlot = EquipmentSlot.HAND;
        } else {
            item = player.getInventory().getItemInOffHand();
            equipmentSlot = EquipmentSlot.OFF_HAND;
        }
        BlockPlaceEvent event = new BlockPlaceEvent(placedBlock, replacedBlockState, blockClicked, item, player, canBuild, equipmentSlot);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static void handleBlockDropItemEvent(Block block, BlockState state, class_3222 player, List<class_1542> items) {
        BlockDropItemEvent event = new BlockDropItemEvent(block, state, player.getBukkitEntity(), Lists.transform(items, item -> (Item)((Object)item.getBukkitEntity())));
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            for (class_1542 item2 : items) {
                item2.method_37908().method_8649((class_1297)item2);
            }
        }
    }

    public static EntityPlaceEvent callEntityPlaceEvent(class_1838 itemactioncontext, class_1297 entity) {
        return CraftEventFactory.callEntityPlaceEvent(itemactioncontext.method_8045(), itemactioncontext.method_8037(), itemactioncontext.method_8038(), itemactioncontext.method_8036(), entity, itemactioncontext.method_20287());
    }

    public static EntityPlaceEvent callEntityPlaceEvent(class_1937 world, class_2338 clickPosition, class_2350 clickedFace, class_1657 human, class_1297 entity, class_1268 enumhand) {
        Player who = human == null ? null : (Player)((Object)human.getBukkitEntity());
        CraftBlock blockClicked = CraftBlock.at((class_1936)world, clickPosition);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EntityPlaceEvent event = new EntityPlaceEvent(entity.getBukkitEntity(), who, blockClicked, blockFace, CraftEquipmentSlot.getHand(enumhand));
        entity.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerBucketEmptyEvent callPlayerBucketEmptyEvent(class_3218 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemInHand, class_1268 enumhand) {
        return (PlayerBucketEmptyEvent)CraftEventFactory.getPlayerBucketEvent(false, world, who, changed, clicked, clickedFace, itemInHand, class_1802.field_8550, enumhand);
    }

    public static PlayerBucketFillEvent callPlayerBucketFillEvent(class_3218 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemInHand, class_1792 bucket, class_1268 enumhand) {
        return (PlayerBucketFillEvent)CraftEventFactory.getPlayerBucketEvent(true, world, who, clicked, changed, clickedFace, itemInHand, bucket, enumhand);
    }

    private static PlayerEvent getPlayerBucketEvent(boolean isFilling, class_3218 world, class_1657 who, class_2338 changed, class_2338 clicked, class_2350 clickedFace, class_1799 itemstack, class_1792 item, class_1268 enumhand) {
        PlayerBucketEvent event;
        Player player = (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asNewCraftStack(item);
        Material bucket = CraftMagicNumbers.getMaterial(itemstack.method_7909());
        CraftServer craftServer = (CraftServer)player.getServer();
        CraftBlock block = CraftBlock.at((class_1936)world, changed);
        CraftBlock blockClicked = CraftBlock.at((class_1936)world, clicked);
        BlockFace blockFace = CraftBlock.notchToBlockFace(clickedFace);
        EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
        if (isFilling) {
            event = new PlayerBucketFillEvent(player, block, blockClicked, blockFace, bucket, itemInHand, hand);
            event.setCancelled(!CraftEventFactory.canBuild(world, player, changed.method_10263(), changed.method_10260()));
        } else {
            event = new PlayerBucketEmptyEvent(player, block, blockClicked, blockFace, bucket, itemInHand, hand);
            ((PlayerBucketEmptyEvent)event).setCancelled(!CraftEventFactory.canBuild(world, player, changed.method_10263(), changed.method_10260()));
        }
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerInteractEvent callPlayerInteractEvent(class_1657 who, Action action, class_1799 itemstack, class_1268 hand) {
        if (action != Action.LEFT_CLICK_AIR && action != Action.RIGHT_CLICK_AIR) {
            throw new AssertionError((Object)String.format("%s performing %s with %s", new Object[]{who, action, itemstack}));
        }
        return CraftEventFactory.callPlayerInteractEvent(who, action, null, class_2350.field_11035, itemstack, hand);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(class_1657 who, Action action, class_2338 position, class_2350 direction, class_1799 itemstack, class_1268 hand) {
        return CraftEventFactory.callPlayerInteractEvent(who, action, position, direction, itemstack, false, hand, null);
    }

    public static PlayerInteractEvent callPlayerInteractEvent(class_1657 who, Action action, class_2338 position, class_2350 direction, class_1799 itemstack, boolean cancelledBlock, class_1268 hand, class_243 targetPos) {
        Player player = who == null ? null : (Player)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        Vector clickedPos = null;
        if (position != null && targetPos != null) {
            clickedPos = CraftVector.toBukkit(targetPos.method_1020(class_243.method_24954((class_2382)position)));
        }
        CraftWorld craftWorld = (CraftWorld)player.getWorld();
        CraftServer craftServer = (CraftServer)player.getServer();
        Block blockClicked = null;
        if (position != null) {
            blockClicked = craftWorld.getBlockAt(position.method_10263(), position.method_10264(), position.method_10260());
        } else {
            switch (action) {
                case LEFT_CLICK_BLOCK: {
                    action = Action.LEFT_CLICK_AIR;
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    action = Action.RIGHT_CLICK_AIR;
                }
            }
        }
        BlockFace blockFace = CraftBlock.notchToBlockFace(direction);
        if (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0) {
            itemInHand = null;
        }
        PlayerInteractEvent event = new PlayerInteractEvent(player, action, itemInHand, blockClicked, blockFace, hand == null ? null : (hand == class_1268.field_5810 ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND), clickedPos);
        if (cancelledBlock) {
            event.setUseInteractedBlock(Event.Result.DENY);
        }
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTransformEvent callEntityTransformEvent(class_1309 original, class_1309 coverted, EntityTransformEvent.TransformReason transformReason) {
        return CraftEventFactory.callEntityTransformEvent(original, Collections.singletonList(coverted), transformReason);
    }

    public static EntityTransformEvent callEntityTransformEvent(class_1309 original, List<class_1309> convertedList, EntityTransformEvent.TransformReason convertType) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (class_1309 entityLiving : convertedList) {
            list.add(entityLiving.getBukkitEntity());
        }
        EntityTransformEvent event = new EntityTransformEvent(original.getBukkitEntity(), list, convertType);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityShootBowEvent callEntityShootBowEvent(class_1309 who, class_1799 bow, class_1799 consumableItem, class_1297 entityArrow, class_1268 hand, float force, boolean consumeItem) {
        EquipmentSlot handSlot;
        LivingEntity shooter = (LivingEntity)((Object)who.getBukkitEntity());
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(bow);
        CraftItemStack itemConsumable = CraftItemStack.asCraftMirror(consumableItem);
        CraftEntity arrow = entityArrow.getBukkitEntity();
        EquipmentSlot equipmentSlot = handSlot = hand == class_1268.field_5808 ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
        if (itemInHand != null && (itemInHand.getType() == Material.AIR || itemInHand.getAmount() == 0)) {
            itemInHand = null;
        }
        EntityShootBowEvent event = new EntityShootBowEvent(shooter, itemInHand, itemConsumable, arrow, handSlot, force, consumeItem);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static VillagerCareerChangeEvent callVillagerCareerChangeEvent(class_1646 vilager, Villager.Profession future, VillagerCareerChangeEvent.ChangeReason reason) {
        VillagerCareerChangeEvent event = new VillagerCareerChangeEvent((Villager)((Object)vilager.getBukkitEntity()), future, reason);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockDamageEvent callBlockDamageEvent(class_3222 who, class_2338 pos, class_1799 itemstack, boolean instaBreak) {
        CraftPlayer player = who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftBlock blockClicked = CraftBlock.at((class_1936)who.method_51469(), pos);
        BlockDamageEvent event = new BlockDamageEvent(player, blockClicked, itemInHand, instaBreak);
        player.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockDamageAbortEvent callBlockDamageAbortEvent(class_3222 who, class_2338 pos, class_1799 itemstack) {
        CraftPlayer player = who.getBukkitEntity();
        CraftItemStack itemInHand = CraftItemStack.asCraftMirror(itemstack);
        CraftBlock blockClicked = CraftBlock.at((class_1936)who.method_51469(), pos);
        BlockDamageAbortEvent event = new BlockDamageAbortEvent(player, blockClicked, itemInHand);
        player.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static boolean doEntityAddEventCalling(class_1937 world, class_1297 entity, CreatureSpawnEvent.SpawnReason spawnReason) {
        if (entity == null) {
            return false;
        }
        Event event = null;
        if (entity instanceof class_1309 && !(entity instanceof class_3222)) {
            boolean isAnimal = entity instanceof class_1429 || entity instanceof class_1480 || entity instanceof class_1427;
            boolean isMonster = entity instanceof class_1588 || entity instanceof class_1571 || entity instanceof class_1621;
            boolean isNpc = entity instanceof class_1655;
            if (spawnReason != CreatureSpawnEvent.SpawnReason.CUSTOM && (isAnimal && !world.getWorld().getAllowAnimals() || isMonster && !world.getWorld().getAllowMonsters() || isNpc && !world.getCraftServer().getServer().method_3736())) {
                entity.method_31472();
                return false;
            }
            event = CraftEventFactory.callCreatureSpawnEvent((class_1309)entity, spawnReason);
        } else if (entity instanceof class_1542) {
            event = CraftEventFactory.callItemSpawnEvent((class_1542)entity);
        } else if (entity.getBukkitEntity() instanceof Projectile) {
            event = CraftEventFactory.callProjectileLaunchEvent(entity);
        } else if (entity.getBukkitEntity() instanceof Vehicle) {
            event = CraftEventFactory.callVehicleCreateEvent(entity);
        } else if (entity.getBukkitEntity() instanceof LightningStrike) {
            LightningStrikeEvent.Cause cause = LightningStrikeEvent.Cause.UNKNOWN;
            switch (spawnReason) {
                case COMMAND: {
                    cause = LightningStrikeEvent.Cause.COMMAND;
                    break;
                }
                case CUSTOM: {
                    cause = LightningStrikeEvent.Cause.CUSTOM;
                    break;
                }
                case SPAWNER: {
                    cause = LightningStrikeEvent.Cause.SPAWNER;
                }
            }
            if (cause == LightningStrikeEvent.Cause.UNKNOWN && spawnReason == CreatureSpawnEvent.SpawnReason.DEFAULT) {
                return true;
            }
            event = CraftEventFactory.callLightningStrikeEvent((LightningStrike)((Object)entity.getBukkitEntity()), cause);
        } else if (entity instanceof class_1303) {
            class_1303 xp = (class_1303)entity;
            double radius = world.bridge$spigotConfig().expMerge;
            if (radius > 0.0) {
                List entities = world.method_8335(entity, entity.method_5829().method_1009(radius, radius, radius));
                for (class_1297 e : entities) {
                    class_1303 loopItem;
                    if (!(e instanceof class_1303) || (loopItem = (class_1303)e).method_31481()) continue;
                    xp.field_6159 += loopItem.field_6159;
                    loopItem.method_31472();
                }
            }
        } else if (!(entity instanceof class_3222)) {
            event = CraftEventFactory.callEntitySpawnEvent(entity);
        }
        if (event != null && (event.isCancelled() || entity.method_31481())) {
            class_1297 vehicle = entity.method_5854();
            if (vehicle != null) {
                vehicle.method_31472();
            }
            for (class_1297 passenger : entity.method_5736()) {
                passenger.method_31472();
            }
            entity.method_31472();
            return false;
        }
        return true;
    }

    public static EntitySpawnEvent callEntitySpawnEvent(class_1297 entity) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        EntitySpawnEvent event = new EntitySpawnEvent(bukkitEntity);
        bukkitEntity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static CreatureSpawnEvent callCreatureSpawnEvent(class_1309 entityliving, CreatureSpawnEvent.SpawnReason spawnReason) {
        LivingEntity entity = (LivingEntity)((Object)entityliving.getBukkitEntity());
        CraftServer craftServer = (CraftServer)entity.getServer();
        CreatureSpawnEvent event = new CreatureSpawnEvent(entity, spawnReason);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTameEvent callEntityTameEvent(class_1308 entity, class_1657 tamer) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        CraftHumanEntity bukkitTamer = tamer != null ? tamer.getBukkitEntity() : null;
        CraftServer craftServer = (CraftServer)bukkitEntity.getServer();
        EntityTameEvent event = new EntityTameEvent((LivingEntity)((Object)bukkitEntity), bukkitTamer);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static ItemSpawnEvent callItemSpawnEvent(class_1542 entityitem) {
        Item entity = (Item)((Object)entityitem.getBukkitEntity());
        CraftServer craftServer = (CraftServer)entity.getServer();
        ItemSpawnEvent event = new ItemSpawnEvent(entity);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    public static ItemDespawnEvent callItemDespawnEvent(class_1542 entityitem) {
        Item entity = (Item)((Object)entityitem.getBukkitEntity());
        ItemDespawnEvent event = new ItemDespawnEvent(entity, entity.getLocation());
        entity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callItemMergeEvent(class_1542 merging, class_1542 mergingWith) {
        Item entityMerging = (Item)((Object)merging.getBukkitEntity());
        Item entityMergingWith = (Item)((Object)mergingWith.getBukkitEntity());
        ItemMergeEvent event = new ItemMergeEvent(entityMerging, entityMergingWith);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static PotionSplashEvent callPotionSplashEvent(class_1686 potion, Map<LivingEntity, Double> affectedEntities) {
        ThrownPotion thrownPotion = (ThrownPotion)((Object)potion.getBukkitEntity());
        PotionSplashEvent event = new PotionSplashEvent(thrownPotion, affectedEntities);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static LingeringPotionSplashEvent callLingeringPotionSplashEvent(class_1686 potion, class_1295 cloud) {
        ThrownPotion thrownPotion = (ThrownPotion)((Object)potion.getBukkitEntity());
        AreaEffectCloud effectCloud = (AreaEffectCloud)((Object)cloud.getBukkitEntity());
        LingeringPotionSplashEvent event = new LingeringPotionSplashEvent(thrownPotion, effectCloud);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockFadeEvent callBlockFadeEvent(class_1936 world, class_2338 pos, class_2680 newBlock) {
        CraftBlockState state = CraftBlockStates.getBlockState(world, pos);
        state.setData(newBlock);
        BlockFadeEvent event = new BlockFadeEvent(state.getBlock(), state);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean handleMoistureChangeEvent(class_1937 world, class_2338 pos, class_2680 newBlock, int flag) {
        CraftBlockState state = CraftBlockStates.getBlockState((class_1936)world, pos, flag);
        state.setData(newBlock);
        MoistureChangeEvent event = new MoistureChangeEvent(state.getBlock(), state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBlockSpreadEvent(class_1937 world, class_2338 source, class_2338 target, class_2680 block) {
        return CraftEventFactory.handleBlockSpreadEvent((class_1936)world, source, target, block, 2);
    }

    public static boolean handleBlockSpreadEvent(class_1936 world, class_2338 source, class_2338 target, class_2680 block, int flag) {
        if (!(world instanceof class_1937)) {
            world.method_8652(target, block, flag);
            return true;
        }
        CraftBlockState state = CraftBlockStates.getBlockState(world, target, flag);
        state.setData(block);
        BlockSpreadEvent event = new BlockSpreadEvent(state.getBlock(), CraftBlock.at(world, sourceBlockOverride != null ? sourceBlockOverride : source), state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static EntityDeathEvent callEntityDeathEvent(class_1309 victim) {
        return CraftEventFactory.callEntityDeathEvent(victim, new ArrayList<ItemStack>(0));
    }

    public static EntityDeathEvent callEntityDeathEvent(class_1309 victim, List<ItemStack> drops) {
        CraftLivingEntity entity = (CraftLivingEntity)victim.getBukkitEntity();
        EntityDeathEvent event = new EntityDeathEvent(entity, drops, victim.getExpReward());
        CraftWorld world = (CraftWorld)entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent(event);
        victim.banner$setExpToDrop(event.getDroppedExp());
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR || stack.getAmount() == 0) continue;
            world.dropItem(entity.getLocation(), stack);
        }
        return event;
    }

    public static PlayerDeathEvent callPlayerDeathEvent(class_3222 victim, List<ItemStack> drops, String deathMessage, boolean keepInventory) {
        CraftPlayer entity = victim.getBukkitEntity();
        PlayerDeathEvent event = new PlayerDeathEvent(entity, drops, victim.getExpReward(), 0, deathMessage);
        event.setKeepInventory(keepInventory);
        event.setKeepLevel(victim.bridge$keepLevel());
        World world = entity.getWorld();
        Bukkit.getServer().getPluginManager().callEvent(event);
        victim.banner$setKeepLevel(event.getKeepLevel());
        victim.banner$setNewLevel(event.getNewLevel());
        victim.banner$setNewTotalExp(event.getNewTotalExp());
        victim.banner$setExpToDrop(event.getDroppedExp());
        victim.banner$setNewExp(event.getNewExp());
        for (ItemStack stack : event.getDrops()) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            world.dropItem(entity.getLocation(), stack);
        }
        return event;
    }

    public static ServerListPingEvent callServerListPingEvent(Server craftServer, InetAddress address, String motd, int numPlayers, int maxPlayers) {
        ServerListPingEvent event = new ServerListPingEvent("", address, motd, numPlayers, maxPlayers);
        craftServer.getPluginManager().callEvent(event);
        return event;
    }

    private static EntityDamageEvent handleEntityDamageEvent(class_1297 entity, class_1282 source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent handleEntityDamageEvent(class_1297 entity, class_1282 source, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        if (source.method_48789(class_8103.field_42249)) {
            EntityDamageEvent event;
            class_1297 damager = entityDamage;
            entityDamage = null;
            if (damager == null) {
                event = new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, modifiers, modifierFunctions);
            } else {
                if (entity instanceof class_1510) {
                    // empty if block
                }
                EntityDamageEvent.DamageCause damageCause = damager instanceof TNTPrimed ? EntityDamageEvent.DamageCause.BLOCK_EXPLOSION : EntityDamageEvent.DamageCause.ENTITY_EXPLOSION;
                event = new EntityDamageByEntityEvent(damager.getBukkitEntity(), entity.getBukkitEntity(), damageCause, modifiers, modifierFunctions);
            }
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            } else {
                entity.banner$setLastDamageCancelled(true);
            }
            return event;
        }
        if (source.method_5529() != null || source.method_5526() != null) {
            EntityDamageEvent.DamageCause cause;
            class_1297 damager = source.method_5529();
            EntityDamageEvent.DamageCause damageCause = cause = source.isSweep() ? EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK : EntityDamageEvent.DamageCause.ENTITY_ATTACK;
            if (source.method_48790() && source.method_5526() != null) {
                damager = source.method_5526();
            }
            if (damager instanceof class_1676) {
                if (damager.getBukkitEntity() instanceof ThrownPotion) {
                    cause = EntityDamageEvent.DamageCause.MAGIC;
                } else if (damager.getBukkitEntity() instanceof Projectile) {
                    cause = EntityDamageEvent.DamageCause.PROJECTILE;
                }
            } else if (source.method_49708(class_8111.field_42330)) {
                cause = EntityDamageEvent.DamageCause.THORNS;
            } else if (source.method_49708(class_8111.field_42333)) {
                cause = EntityDamageEvent.DamageCause.SONIC_BOOM;
            }
            return CraftEventFactory.callEntityDamageEvent(damager, entity, cause, modifiers, modifierFunctions, cancelled);
        }
        if (source.method_49708(class_8111.field_44868)) {
            EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(null, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.VOID, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            } else {
                entity.banner$setLastDamageCancelled(true);
            }
            return event;
        }
        if (source.method_49708(class_8111.field_42338)) {
            EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(blockDamage, entity.getBukkitEntity(), EntityDamageEvent.DamageCause.LAVA, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            Block damager = blockDamage;
            blockDamage = null;
            CraftEventFactory.callEvent(event);
            blockDamage = damager;
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            }
            return event;
        }
        if (blockDamage != null) {
            EntityDamageEvent.DamageCause cause = null;
            Block damager = blockDamage;
            cause = source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42353) || source.method_49708(class_8111.field_42355) || source.method_49708(class_8111.field_42358) || source.method_49708(class_8111.field_42357) ? EntityDamageEvent.DamageCause.CONTACT : (source.method_49708(class_8111.field_42339) ? EntityDamageEvent.DamageCause.HOT_FLOOR : (source.method_49708(class_8111.field_42349) ? EntityDamageEvent.DamageCause.MAGIC : (source.method_49708(class_8111.field_42335) ? EntityDamageEvent.DamageCause.FIRE : (source.method_49708(class_8111.field_42337) ? EntityDamageEvent.DamageCause.FIRE_TICK : (source.method_49708(class_8111.field_42338) ? EntityDamageEvent.DamageCause.LAVA : (damager instanceof LightningStrike ? EntityDamageEvent.DamageCause.LIGHTNING : (source.method_49708(MELTING) ? EntityDamageEvent.DamageCause.MELTING : (source.method_49708(POISON) ? EntityDamageEvent.DamageCause.POISON : (source.method_49708(class_8111.field_42336) ? EntityDamageEvent.DamageCause.LIGHTNING : (source.method_49708(class_8111.field_42348) ? EntityDamageEvent.DamageCause.CUSTOM : EntityDamageEvent.DamageCause.CUSTOM))))))))));
            EntityDamageByBlockEvent event = new EntityDamageByBlockEvent(damager, entity.getBukkitEntity(), cause, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            blockDamage = null;
            CraftEventFactory.callEvent(event);
            blockDamage = damager;
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            } else {
                entity.banner$setLastDamageCancelled(true);
            }
            return event;
        }
        if (entityDamage != null) {
            EntityDamageEvent.DamageCause cause = null;
            CraftEntity damager = entityDamage.getBukkitEntity();
            entityDamage = null;
            cause = source.method_49708(class_8111.field_42358) || source.method_49708(class_8111.field_42356) || source.method_49708(class_8111.field_42357) ? EntityDamageEvent.DamageCause.FALLING_BLOCK : (damager instanceof LightningStrike ? EntityDamageEvent.DamageCause.LIGHTNING : (source.method_49708(class_8111.field_42345) ? EntityDamageEvent.DamageCause.FALL : (source.method_49708(class_8111.field_42351) ? EntityDamageEvent.DamageCause.DRAGON_BREATH : (source.method_49708(class_8111.field_42349) ? EntityDamageEvent.DamageCause.MAGIC : (source.method_49708(class_8111.field_42344) ? EntityDamageEvent.DamageCause.CONTACT : (source.method_49708(class_8111.field_42335) ? EntityDamageEvent.DamageCause.FIRE : (source.method_49708(class_8111.field_42337) ? EntityDamageEvent.DamageCause.FIRE_TICK : (source.method_49708(class_8111.field_42338) ? EntityDamageEvent.DamageCause.LAVA : (source.method_49708(MELTING) ? EntityDamageEvent.DamageCause.MELTING : (source.method_49708(POISON) ? EntityDamageEvent.DamageCause.POISON : EntityDamageEvent.DamageCause.CUSTOM))))))))));
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent(damager, entity.getBukkitEntity(), cause, modifiers, modifierFunctions);
            event.setCancelled(cancelled);
            CraftEventFactory.callEvent(event);
            if (!event.isCancelled()) {
                event.getEntity().setLastDamageCause(event);
            } else {
                entity.banner$setLastDamageCancelled(true);
            }
            return event;
        }
        EntityDamageEvent.DamageCause cause = null;
        cause = source.method_49708(class_8111.field_42335) ? EntityDamageEvent.DamageCause.FIRE : (source.method_49708(class_8111.field_42343) ? EntityDamageEvent.DamageCause.STARVATION : (source.method_49708(class_8111.field_42350) ? EntityDamageEvent.DamageCause.WITHER : (source.method_49708(class_8111.field_42340) ? EntityDamageEvent.DamageCause.SUFFOCATION : (source.method_49708(class_8111.field_42342) ? EntityDamageEvent.DamageCause.DROWNING : (source.method_49708(class_8111.field_42337) ? EntityDamageEvent.DamageCause.FIRE_TICK : (source.isMelting() ? EntityDamageEvent.DamageCause.MELTING : (source.isPoison() ? EntityDamageEvent.DamageCause.POISON : (source.method_49708(class_8111.field_42349) ? EntityDamageEvent.DamageCause.MAGIC : (source.method_49708(class_8111.field_42345) ? EntityDamageEvent.DamageCause.FALL : (source.method_49708(class_8111.field_42346) ? EntityDamageEvent.DamageCause.FLY_INTO_WALL : (source.method_49708(class_8111.field_42341) ? EntityDamageEvent.DamageCause.CRAMMING : (source.method_49708(class_8111.field_42352) ? EntityDamageEvent.DamageCause.DRYOUT : (source.method_49708(class_8111.field_42354) ? EntityDamageEvent.DamageCause.FREEZE : (source.method_49708(class_8111.field_44869) ? EntityDamageEvent.DamageCause.KILL : (source.method_49708(class_8111.field_44868) ? EntityDamageEvent.DamageCause.WORLD_BORDER : EntityDamageEvent.DamageCause.CUSTOM)))))))))))))));
        if (cause != null) {
            return CraftEventFactory.callEntityDamageEvent(null, entity, cause, modifiers, modifierFunctions, cancelled);
        }
        throw new IllegalStateException(String.format("Unhandled damage of %s from %s", entity, source.method_5525()));
    }

    private static EntityDamageEvent callEntityDamageEvent(class_1297 damager, class_1297 damagee, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions) {
        return CraftEventFactory.callEntityDamageEvent(damager, damagee, cause, modifiers, modifierFunctions, false);
    }

    private static EntityDamageEvent callEntityDamageEvent(class_1297 damager, class_1297 damagee, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Double> modifiers, Map<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions, boolean cancelled) {
        EntityDamageEvent event = damager != null ? new EntityDamageByEntityEvent(damager.getBukkitEntity(), damagee.getBukkitEntity(), cause, modifiers, modifierFunctions) : new EntityDamageEvent(damagee.getBukkitEntity(), cause, modifiers, modifierFunctions);
        event.setCancelled(cancelled);
        CraftEventFactory.callEvent(event);
        if (!event.isCancelled()) {
            event.getEntity().setLastDamageCause(event);
        } else {
            damagee.banner$setLastDamageCancelled(true);
        }
        return event;
    }

    public static EntityDamageEvent handleLivingEntityDamageEvent(class_1297 damagee, class_1282 source, double rawDamage, double hardHatModifier, double blockingModifier, double armorModifier, double resistanceModifier, double magicModifier, double absorptionModifier, com.google.common.base.Function<Double, Double> hardHat, com.google.common.base.Function<Double, Double> blocking, com.google.common.base.Function<Double, Double> armor, com.google.common.base.Function<Double, Double> resistance, com.google.common.base.Function<Double, Double> magic, com.google.common.base.Function<Double, Double> absorption) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> modifierFunctions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, rawDamage);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        if (source.method_49708(class_8111.field_42356) || source.method_49708(class_8111.field_42357)) {
            modifiers.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHatModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.HARD_HAT, hardHat);
        }
        if (damagee instanceof class_1657) {
            modifiers.put(EntityDamageEvent.DamageModifier.BLOCKING, blockingModifier);
            modifierFunctions.put(EntityDamageEvent.DamageModifier.BLOCKING, blocking);
        }
        modifiers.put(EntityDamageEvent.DamageModifier.ARMOR, armorModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ARMOR, armor);
        modifiers.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistanceModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.RESISTANCE, resistance);
        modifiers.put(EntityDamageEvent.DamageModifier.MAGIC, magicModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.MAGIC, magic);
        modifiers.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorptionModifier);
        modifierFunctions.put(EntityDamageEvent.DamageModifier.ABSORPTION, absorption);
        return CraftEventFactory.handleEntityDamageEvent(damagee, source, modifiers, modifierFunctions);
    }

    public static boolean handleNonLivingEntityDamageEvent(class_1297 entity, class_1282 source, double damage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, true);
    }

    public static boolean handleNonLivingEntityDamageEvent(class_1297 entity, class_1282 source, double damage, boolean cancelOnZeroDamage) {
        return CraftEventFactory.handleNonLivingEntityDamageEvent(entity, source, damage, cancelOnZeroDamage, false);
    }

    public static EntityDamageEvent callNonLivingEntityDamageEvent(class_1297 entity, class_1282 source, double damage, boolean cancelled) {
        EnumMap<EntityDamageEvent.DamageModifier, Double> modifiers = new EnumMap<EntityDamageEvent.DamageModifier, Double>(EntityDamageEvent.DamageModifier.class);
        EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>> functions = new EnumMap<EntityDamageEvent.DamageModifier, com.google.common.base.Function<? super Double, Double>>(EntityDamageEvent.DamageModifier.class);
        modifiers.put(EntityDamageEvent.DamageModifier.BASE, damage);
        functions.put(EntityDamageEvent.DamageModifier.BASE, ZERO);
        return CraftEventFactory.handleEntityDamageEvent(entity, source, modifiers, functions, cancelled);
    }

    public static boolean handleNonLivingEntityDamageEvent(class_1297 entity, class_1282 source, double damage, boolean cancelOnZeroDamage, boolean cancelled) {
        EntityDamageEvent event = CraftEventFactory.callNonLivingEntityDamageEvent(entity, source, damage, cancelled);
        if (event == null) {
            return false;
        }
        return event.isCancelled() || cancelOnZeroDamage && event.getDamage() == 0.0;
    }

    public static PlayerLevelChangeEvent callPlayerLevelChangeEvent(Player player, int oldLevel, int newLevel) {
        PlayerLevelChangeEvent event = new PlayerLevelChangeEvent(player, oldLevel, newLevel);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerExpChangeEvent callPlayerExpChangeEvent(class_1657 entity, int expAmount) {
        Player player = (Player)((Object)entity.getBukkitEntity());
        PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, expAmount);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerExpCooldownChangeEvent callPlayerXpCooldownEvent(class_1657 entity, int newCooldown, PlayerExpCooldownChangeEvent.ChangeReason changeReason) {
        Player player = (Player)((Object)entity.getBukkitEntity());
        PlayerExpCooldownChangeEvent event = new PlayerExpCooldownChangeEvent(player, newCooldown, changeReason);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerItemMendEvent callPlayerItemMendEvent(class_1657 entity, class_1303 orb, class_1799 nmsMendedItem, class_1304 slot, int repairAmount) {
        Player player = (Player)((Object)entity.getBukkitEntity());
        CraftItemStack bukkitStack = CraftItemStack.asCraftMirror(nmsMendedItem);
        PlayerItemMendEvent event = new PlayerItemMendEvent(player, bukkitStack, CraftEquipmentSlot.getSlot(slot), (ExperienceOrb)((Object)orb.getBukkitEntity()), repairAmount);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean handleBlockGrowEvent(class_1937 world, class_2338 pos, class_2680 block) {
        return CraftEventFactory.handleBlockGrowEvent(world, pos, block, 3);
    }

    public static boolean handleBlockGrowEvent(class_1937 world, class_2338 pos, class_2680 newData, int flag) {
        Block block = world.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260());
        CraftBlockState state = (CraftBlockState)block.getState();
        state.setData(newData);
        BlockGrowEvent event = new BlockGrowEvent(block, state);
        Bukkit.getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            state.update(true);
        }
        return !event.isCancelled();
    }

    public static FluidLevelChangeEvent callFluidLevelChangeEvent(class_1937 world, class_2338 block, class_2680 newData) {
        FluidLevelChangeEvent event = new FluidLevelChangeEvent(CraftBlock.at((class_1936)world, block), CraftBlockData.fromData(newData));
        world.getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(class_1657 entity, int level) {
        return CraftEventFactory.callFoodLevelChangeEvent(entity, level, null);
    }

    public static FoodLevelChangeEvent callFoodLevelChangeEvent(class_1657 entity, int level, class_1799 item) {
        FoodLevelChangeEvent event = new FoodLevelChangeEvent(entity.getBukkitEntity(), level, item == null ? null : CraftItemStack.asBukkitCopy(item));
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PigZapEvent callPigZapEvent(class_1297 pig, class_1297 lightning, class_1297 pigzombie) {
        PigZapEvent event = new PigZapEvent((Pig)((Object)pig.getBukkitEntity()), (LightningStrike)((Object)lightning.getBukkitEntity()), (PigZombie)((Object)pigzombie.getBukkitEntity()));
        pig.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callHorseJumpEvent(class_1297 horse, float power) {
        HorseJumpEvent event = new HorseJumpEvent((AbstractHorse)((Object)horse.getBukkitEntity()), power);
        horse.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static boolean callEntityChangeBlockEvent(class_1297 entity, class_2338 position, class_2680 newBlock) {
        return CraftEventFactory.callEntityChangeBlockEvent(entity, position, newBlock, false);
    }

    public static boolean callEntityChangeBlockEvent(class_1297 entity, class_2338 position, class_2680 newBlock, boolean cancelled) {
        Block block = entity.method_37908().getWorld().getBlockAt(position.method_10263(), position.method_10264(), position.method_10260());
        EntityChangeBlockEvent event = new EntityChangeBlockEvent(entity.getBukkitEntity(), block, CraftBlockData.fromData(newBlock));
        event.setCancelled(cancelled);
        event.getEntity().getServer().getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static CreeperPowerEvent callCreeperPowerEvent(class_1297 creeper, class_1297 lightning, CreeperPowerEvent.PowerCause cause) {
        CreeperPowerEvent event = new CreeperPowerEvent((Creeper)((Object)creeper.getBukkitEntity()), (LightningStrike)((Object)lightning.getBukkitEntity()), cause);
        creeper.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTargetEvent callEntityTargetEvent(class_1297 entity, class_1297 target, EntityTargetEvent.TargetReason reason) {
        EntityTargetEvent event = new EntityTargetEvent(entity.getBukkitEntity(), target == null ? null : target.getBukkitEntity(), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityTargetLivingEntityEvent callEntityTargetLivingEvent(class_1297 entity, class_1309 target, EntityTargetEvent.TargetReason reason) {
        EntityTargetLivingEntityEvent event = new EntityTargetLivingEntityEvent((Entity)entity.getBukkitEntity(), target == null ? null : (LivingEntity)((Object)target.getBukkitEntity()), reason);
        entity.getBukkitEntity().getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityBreakDoorEvent callEntityBreakDoorEvent(class_1297 entity, class_2338 pos) {
        CraftEntity entity1 = entity.getBukkitEntity();
        CraftBlock block = CraftBlock.at((class_1936)entity.method_37908(), pos);
        EntityBreakDoorEvent event = new EntityBreakDoorEvent((LivingEntity)((Object)entity1), block);
        entity1.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static class_1703 callInventoryOpenEvent(class_3222 player, class_1703 container) {
        return CraftEventFactory.callInventoryOpenEvent(player, container, false);
    }

    public static class_1703 callInventoryOpenEvent(class_3222 player, class_1703 container, boolean cancelled) {
        if (player.field_7512 != player.field_7498) {
            player.field_13987.method_12054(new class_2815(player.field_7512.field_7763));
        }
        CraftServer server = player.method_37908().getCraftServer();
        CraftPlayer craftPlayer = player.getBukkitEntity();
        player.field_7512.transferTo(container, (CraftHumanEntity)craftPlayer);
        InventoryOpenEvent event = new InventoryOpenEvent(container.getBukkitView());
        event.setCancelled(cancelled);
        server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            container.transferTo(player.field_7512, (CraftHumanEntity)craftPlayer);
            return null;
        }
        return container;
    }

    public static class_1799 callPreCraftEvent(class_1263 matrix, class_1263 resultInventory, class_1799 result, InventoryView lastCraftView, boolean isRepair) {
        CraftInventoryCrafting inventory = new CraftInventoryCrafting(matrix, resultInventory);
        inventory.setResult(CraftItemStack.asCraftMirror(result));
        PrepareItemCraftEvent event = new PrepareItemCraftEvent(inventory, lastCraftView, isRepair);
        Bukkit.getPluginManager().callEvent(event);
        ItemStack bitem = event.getInventory().getResult();
        return CraftItemStack.asNMSCopy(bitem);
    }

    public static ProjectileLaunchEvent callProjectileLaunchEvent(class_1297 entity) {
        Projectile bukkitEntity = (Projectile)((Object)entity.getBukkitEntity());
        ProjectileLaunchEvent event = new ProjectileLaunchEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static ProjectileHitEvent callProjectileHitEvent(class_1297 entity, class_239 position) {
        if (position.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        CraftBlock hitBlock = null;
        BlockFace hitFace = null;
        if (position.method_17783() == class_239.class_240.field_1332) {
            class_3965 positionBlock = (class_3965)position;
            hitBlock = CraftBlock.at((class_1936)entity.method_37908(), positionBlock.method_17777());
            hitFace = CraftBlock.notchToBlockFace(positionBlock.method_17780());
        }
        CraftEntity hitEntity = null;
        if (position.method_17783() == class_239.class_240.field_1331) {
            hitEntity = ((class_3966)position).method_17782().getBukkitEntity();
        }
        ProjectileHitEvent event = new ProjectileHitEvent((Projectile)((Object)entity.getBukkitEntity()), hitEntity, hitBlock, hitFace);
        entity.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static ExpBottleEvent callExpBottleEvent(class_1297 entity, int exp) {
        ThrownExpBottle bottle = (ThrownExpBottle)((Object)entity.getBukkitEntity());
        ExpBottleEvent event = new ExpBottleEvent(bottle, exp);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static BlockRedstoneEvent callRedstoneChange(class_1937 world, class_2338 pos, int oldCurrent, int newCurrent) {
        BlockRedstoneEvent event = new BlockRedstoneEvent(world.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), oldCurrent, newCurrent);
        world.getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static NotePlayEvent callNotePlayEvent(class_1937 world, class_2338 pos, class_2766 instrument, int note) {
        NotePlayEvent event = new NotePlayEvent(world.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), Instrument.getByType((byte)instrument.ordinal()), new Note(note));
        world.getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static void callPlayerItemBreakEvent(class_1657 human, class_1799 brokenItem) {
        CraftItemStack item = CraftItemStack.asCraftMirror(brokenItem);
        PlayerItemBreakEvent event = new PlayerItemBreakEvent((Player)((Object)human.getBukkitEntity()), item);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static BlockIgniteEvent callBlockIgniteEvent(class_1937 world, class_2338 block, class_2338 source) {
        CraftWorld bukkitWorld = world.getWorld();
        Block igniter = bukkitWorld.getBlockAt(source.method_10263(), source.method_10264(), source.method_10260());
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(block.method_10263(), block.method_10264(), block.method_10260()), switch (igniter.getType()) {
            case Material.LAVA -> BlockIgniteEvent.IgniteCause.LAVA;
            case Material.DISPENSER -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
            default -> BlockIgniteEvent.IgniteCause.SPREAD;
        }, igniter);
        world.getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(class_1937 world, class_2338 pos, class_1297 igniter) {
        class_1297 shooter;
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity bukkitIgniter = igniter.getBukkitEntity();
        BlockIgniteEvent.IgniteCause cause = switch (bukkitIgniter.getType()) {
            case EntityType.ENDER_CRYSTAL -> BlockIgniteEvent.IgniteCause.ENDER_CRYSTAL;
            case EntityType.LIGHTNING -> BlockIgniteEvent.IgniteCause.LIGHTNING;
            case EntityType.SMALL_FIREBALL, EntityType.FIREBALL -> BlockIgniteEvent.IgniteCause.FIREBALL;
            case EntityType.ARROW -> BlockIgniteEvent.IgniteCause.ARROW;
            default -> BlockIgniteEvent.IgniteCause.FLINT_AND_STEEL;
        };
        if (igniter instanceof class_1676 && (shooter = ((class_1676)igniter).method_24921()) != null) {
            bukkitIgniter = shooter.getBukkitEntity();
        }
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), cause, bukkitIgniter);
        world.getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(class_1937 world, int x, int y, int z, class_1927 explosion) {
        CraftWorld bukkitWorld = world.getWorld();
        CraftEntity igniter = explosion.field_9185 == null ? null : explosion.field_9185.getBukkitEntity();
        BlockIgniteEvent event = new BlockIgniteEvent(bukkitWorld.getBlockAt(x, y, z), BlockIgniteEvent.IgniteCause.EXPLOSION, igniter);
        world.getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockIgniteEvent callBlockIgniteEvent(class_1937 world, class_2338 pos, BlockIgniteEvent.IgniteCause cause, class_1297 igniter) {
        BlockIgniteEvent event = new BlockIgniteEvent(world.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()), cause, igniter.getBukkitEntity());
        world.getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static void handleInventoryCloseEvent(class_1657 human) {
        InventoryCloseEvent event = new InventoryCloseEvent(human.field_7512.getBukkitView());
        human.method_37908().getCraftServer().getPluginManager().callEvent(event);
        human.field_7512.transferTo((class_1703)human.field_7498, human.getBukkitEntity());
    }

    public static class_1799 handleEditBookEvent(class_3222 player, int itemInHandIndex, class_1799 itemInHand, class_1799 newBookItem) {
        PlayerEditBookEvent editBookEvent = new PlayerEditBookEvent(player.getBukkitEntity(), itemInHandIndex >= 0 && itemInHandIndex <= 8 ? itemInHandIndex : -1, (BookMeta)CraftItemStack.getItemMeta(itemInHand), (BookMeta)CraftItemStack.getItemMeta(newBookItem), newBookItem.method_7909() == class_1802.field_8360);
        player.method_37908().getCraftServer().getPluginManager().callEvent(editBookEvent);
        if (itemInHand != null && itemInHand.method_7909() == class_1802.field_8674 && !editBookEvent.isCancelled()) {
            if (editBookEvent.isSigning()) {
                itemInHand.setItem(class_1802.field_8360);
            }
            CraftMetaBook meta = (CraftMetaBook)editBookEvent.getNewBookMeta();
            CraftItemStack.setItemMeta(itemInHand, meta);
        }
        return itemInHand;
    }

    public static PlayerUnleashEntityEvent callPlayerUnleashEntityEvent(class_1308 entity, class_1657 player, class_1268 enumhand) {
        PlayerUnleashEntityEvent event = new PlayerUnleashEntityEvent(entity.getBukkitEntity(), (Player)((Object)player.getBukkitEntity()), CraftEquipmentSlot.getHand(enumhand));
        entity.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PlayerLeashEntityEvent callPlayerLeashEntityEvent(class_1308 entity, class_1297 leashHolder, class_1657 player, class_1268 enumhand) {
        PlayerLeashEntityEvent event = new PlayerLeashEntityEvent(entity.getBukkitEntity(), leashHolder.getBukkitEntity(), (Player)((Object)player.getBukkitEntity()), CraftEquipmentSlot.getHand(enumhand));
        entity.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockShearEntityEvent callBlockShearEntityEvent(class_1297 animal, Block dispenser, CraftItemStack is) {
        BlockShearEntityEvent bse = new BlockShearEntityEvent(dispenser, animal.getBukkitEntity(), is);
        Bukkit.getPluginManager().callEvent(bse);
        return bse;
    }

    public static boolean handlePlayerShearEntityEvent(class_1657 player, class_1297 sheared, class_1799 shears, class_1268 hand) {
        if (!(player instanceof class_3222)) {
            return true;
        }
        PlayerShearEntityEvent event = new PlayerShearEntityEvent((Player)((Object)player.getBukkitEntity()), sheared.getBukkitEntity(), CraftItemStack.asCraftMirror(shears), hand == class_1268.field_5810 ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static Cancellable handleStatisticsIncrease(class_1657 entityHuman, class_3445<?> statistic, int current, int newValue) {
        PlayerStatisticIncrementEvent event;
        CraftPlayer player = ((class_3222)entityHuman).getBukkitEntity();
        Statistic stat = CraftStatistic.getBukkitStatistic(statistic);
        if (stat == null) {
            stat = FabricInjectBukkit.statisticMap.get(statistic.method_14949());
        }
        if (stat == null) {
            System.err.println("Unhandled statistic: " + statistic);
            return null;
        }
        switch (stat) {
            case FALL_ONE_CM: 
            case BOAT_ONE_CM: 
            case CLIMB_ONE_CM: 
            case WALK_ON_WATER_ONE_CM: 
            case WALK_UNDER_WATER_ONE_CM: 
            case FLY_ONE_CM: 
            case HORSE_ONE_CM: 
            case MINECART_ONE_CM: 
            case PIG_ONE_CM: 
            case PLAY_ONE_MINUTE: 
            case SWIM_ONE_CM: 
            case WALK_ONE_CM: 
            case SPRINT_ONE_CM: 
            case CROUCH_ONE_CM: 
            case TIME_SINCE_DEATH: 
            case SNEAK_TIME: 
            case TOTAL_WORLD_TIME: 
            case TIME_SINCE_REST: 
            case AVIATE_ONE_CM: 
            case STRIDER_ONE_CM: {
                return null;
            }
        }
        if (stat.getType() == Statistic.Type.UNTYPED) {
            event = new PlayerStatisticIncrementEvent(player, stat, current, newValue);
        } else if (stat.getType() == Statistic.Type.ENTITY) {
            EntityType entityType = CraftStatistic.getEntityTypeFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, entityType);
        } else {
            Material material = CraftStatistic.getMaterialFromStatistic(statistic);
            event = new PlayerStatisticIncrementEvent((Player)player, stat, current, newValue, material);
        }
        entityHuman.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static FireworkExplodeEvent callFireworkExplodeEvent(class_1671 firework) {
        FireworkExplodeEvent event = new FireworkExplodeEvent((Firework)((Object)firework.getBukkitEntity()));
        firework.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static PrepareAnvilEvent callPrepareAnvilEvent(InventoryView view, class_1799 item) {
        PrepareAnvilEvent event = new PrepareAnvilEvent(view, CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent(event);
        event.getInventory().setItem(2, event.getResult());
        return event;
    }

    public static PrepareGrindstoneEvent callPrepareGrindstoneEvent(InventoryView view, class_1799 item) {
        PrepareGrindstoneEvent event = new PrepareGrindstoneEvent(view, CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent(event);
        event.getInventory().setItem(2, event.getResult());
        return event;
    }

    public static PrepareSmithingEvent callPrepareSmithingEvent(InventoryView view, class_1799 item) {
        PrepareSmithingEvent event = new PrepareSmithingEvent(view, CraftItemStack.asCraftMirror(item).clone());
        event.getView().getPlayer().getServer().getPluginManager().callEvent(event);
        event.getInventory().setResult(event.getResult());
        return event;
    }

    public static EntityToggleGlideEvent callToggleGlideEvent(class_1309 entity, boolean gliding) {
        EntityToggleGlideEvent event = new EntityToggleGlideEvent((LivingEntity)((Object)entity.getBukkitEntity()), gliding);
        entity.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static EntityToggleSwimEvent callToggleSwimEvent(class_1309 entity, boolean swimming) {
        EntityToggleSwimEvent event = new EntityToggleSwimEvent((LivingEntity)((Object)entity.getBukkitEntity()), swimming);
        entity.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static AreaEffectCloudApplyEvent callAreaEffectCloudApplyEvent(class_1295 cloud, List<LivingEntity> entities) {
        AreaEffectCloudApplyEvent event = new AreaEffectCloudApplyEvent((AreaEffectCloud)((Object)cloud.getBukkitEntity()), entities);
        cloud.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static VehicleCreateEvent callVehicleCreateEvent(class_1297 entity) {
        Vehicle bukkitEntity = (Vehicle)((Object)entity.getBukkitEntity());
        VehicleCreateEvent event = new VehicleCreateEvent(bukkitEntity);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityBreedEvent callEntityBreedEvent(class_1309 child, class_1309 mother, class_1309 father, class_1309 breeder, class_1799 bredWith, int experience) {
        LivingEntity breederEntity = (LivingEntity)((Object)(breeder == null ? null : breeder.getBukkitEntity()));
        CraftItemStack bredWithStack = bredWith == null ? null : CraftItemStack.asCraftMirror(bredWith).clone();
        EntityBreedEvent event = new EntityBreedEvent((LivingEntity)((Object)child.getBukkitEntity()), (LivingEntity)((Object)mother.getBukkitEntity()), (LivingEntity)((Object)father.getBukkitEntity()), breederEntity, bredWithStack, experience);
        child.method_37908().getCraftServer().getPluginManager().callEvent(event);
        return event;
    }

    public static BlockPhysicsEvent callBlockPhysicsEvent(class_1936 world, class_2338 blockposition) {
        CraftBlock block = CraftBlock.at(world, blockposition);
        BlockPhysicsEvent event = new BlockPhysicsEvent(block, block.getBlockData());
        if (world instanceof class_1937) {
            Objects.requireNonNull(((class_1937)world).method_8503()).bridge$server().getPluginManager().callEvent(event);
        }
        return event;
    }

    public static boolean handleBlockFormEvent(class_1937 world, class_2338 pos, class_2680 block) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(class_1309 entity, @Nullable class_1293 oldEffect, @Nullable class_1293 newEffect, EntityPotionEffectEvent.Cause cause) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(class_1309 entity, @Nullable class_1293 oldEffect, @Nullable class_1293 newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action) {
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, true);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(class_1309 entity, @Nullable class_1293 oldEffect, @Nullable class_1293 newEffect, EntityPotionEffectEvent.Cause cause, boolean willOverride) {
        EntityPotionEffectEvent.Action action = EntityPotionEffectEvent.Action.CHANGED;
        if (oldEffect == null) {
            action = EntityPotionEffectEvent.Action.ADDED;
        } else if (newEffect == null) {
            action = EntityPotionEffectEvent.Action.REMOVED;
        }
        return CraftEventFactory.callEntityPotionEffectChangeEvent(entity, oldEffect, newEffect, cause, action, willOverride);
    }

    public static EntityPotionEffectEvent callEntityPotionEffectChangeEvent(class_1309 entity, @Nullable class_1293 oldEffect, @Nullable class_1293 newEffect, EntityPotionEffectEvent.Cause cause, EntityPotionEffectEvent.Action action, boolean willOverride) {
        PotionEffect bukkitOldEffect = oldEffect == null ? null : CraftPotionUtil.toBukkit(oldEffect);
        PotionEffect bukkitNewEffect = newEffect == null ? null : CraftPotionUtil.toBukkit(newEffect);
        Preconditions.checkState((bukkitOldEffect != null || bukkitNewEffect != null ? 1 : 0) != 0, (Object)"Old and new potion effect are both null");
        EntityPotionEffectEvent event = new EntityPotionEffectEvent((LivingEntity)((Object)entity.getBukkitEntity()), bukkitOldEffect, bukkitNewEffect, cause, action, willOverride);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean handleBlockFormEvent(class_1937 world, class_2338 pos, class_2680 block, @Nullable class_1297 entity) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, 3, entity);
    }

    public static boolean handleBlockFormEvent(class_1937 world, class_2338 pos, class_2680 block, int flag) {
        return CraftEventFactory.handleBlockFormEvent(world, pos, block, flag, null);
    }

    public static boolean handleBlockFormEvent(class_1937 world, class_2338 pos, class_2680 block, int flag, @Nullable class_1297 entity) {
        CraftBlockState blockState = CraftBlockStates.getBlockState((class_1936)world, pos, flag);
        blockState.setData(block);
        BlockFormEvent event = entity == null ? new BlockFormEvent(blockState.getBlock(), blockState) : new EntityBlockFormEvent(entity.getBukkitEntity(), blockState.getBlock(), blockState);
        world.getCraftServer().getPluginManager().callEvent(event);
        if (!event.isCancelled()) {
            blockState.update(true);
        }
        return !event.isCancelled();
    }

    public static boolean handleBatToggleSleepEvent(class_1297 bat, boolean awake) {
        BatToggleSleepEvent event = new BatToggleSleepEvent((Bat)((Object)bat.getBukkitEntity()), awake);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static boolean handlePlayerRecipeListUpdateEvent(class_1657 who, class_2960 recipe) {
        PlayerRecipeDiscoverEvent event = new PlayerRecipeDiscoverEvent((Player)((Object)who.getBukkitEntity()), CraftNamespacedKey.fromMinecraft(recipe));
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static EntityPickupItemEvent callEntityPickupItemEvent(class_1297 who, class_1542 item, int remaining, boolean cancelled) {
        EntityPickupItemEvent event = new EntityPickupItemEvent((LivingEntity)((Object)who.getBukkitEntity()), (Item)((Object)item.getBukkitEntity()), remaining);
        event.setCancelled(cancelled);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static LightningStrikeEvent callLightningStrikeEvent(LightningStrike entity, LightningStrikeEvent.Cause cause) {
        LightningStrikeEvent event = new LightningStrikeEvent(entity.getWorld(), entity, cause);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callRaidTriggerEvent(class_3765 raid, class_3222 player) {
        RaidTriggerEvent event = new RaidTriggerEvent(new CraftRaid(raid), raid.method_16831().getWorld(), player.getBukkitEntity());
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static void callRaidFinishEvent(class_3765 raid, List<Player> players) {
        RaidFinishEvent event = new RaidFinishEvent(new CraftRaid(raid), raid.method_16831().getWorld(), players);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static void callRaidStopEvent(class_3765 raid, RaidStopEvent.Reason reason) {
        RaidStopEvent event = new RaidStopEvent(new CraftRaid(raid), raid.method_16831().getWorld(), reason);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static void callRaidSpawnWaveEvent(class_3765 raid, class_3763 leader, List<class_3763> raiders) {
        CraftRaider craftLeader = (CraftRaider)leader.getBukkitEntity();
        ArrayList<Raider> craftRaiders = new ArrayList<Raider>();
        for (class_3763 entityRaider : raiders) {
            craftRaiders.add((Raider)((Object)entityRaider.getBukkitEntity()));
        }
        RaidSpawnWaveEvent event = new RaidSpawnWaveEvent(new CraftRaid(raid), raid.method_16831().getWorld(), craftLeader, craftRaiders);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static LootGenerateEvent callLootGenerateEvent(class_1263 inventory, class_52 lootTable, class_47 lootInfo, List<class_1799> loot, boolean plugin) {
        InventoryHolder owner;
        CraftWorld world = lootInfo.method_299().getWorld();
        class_1297 entity = (class_1297)lootInfo.method_296(class_181.field_1226);
        NamespacedKey key = CraftNamespacedKey.fromMinecraft((class_2960)world.getHandle().method_8503().method_3857().bridge$lootTableToKey().get(lootTable));
        CraftLootTable craftLootTable = new CraftLootTable(key, lootTable);
        List bukkitLoot = loot.stream().map(CraftItemStack::asCraftMirror).collect(Collectors.toCollection(ArrayList::new));
        try {
            owner = inventory.getOwner();
        }
        catch (AbstractMethodError error) {
            owner = null;
        }
        LootGenerateEvent event = new LootGenerateEvent(world, entity != null ? entity.getBukkitEntity() : null, owner, craftLootTable, CraftLootTable.convertContext(lootInfo), bukkitLoot, plugin);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callStriderTemperatureChangeEvent(class_4985 strider, boolean shivering) {
        StriderTemperatureChangeEvent event = new StriderTemperatureChangeEvent((Strider)((Object)strider.getBukkitEntity()), shivering);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static boolean handleEntitySpellCastEvent(class_1617 caster, class_1617.class_1618 spell) {
        EntitySpellCastEvent event = new EntitySpellCastEvent((Spellcaster)((Object)caster.getBukkitEntity()), CraftSpellcaster.toBukkitSpell(spell));
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    public static ArrowBodyCountChangeEvent callArrowBodyCountChangeEvent(class_1309 entity, int oldAmount, int newAmount, boolean isReset) {
        LivingEntity bukkitEntity = (LivingEntity)((Object)entity.getBukkitEntity());
        ArrowBodyCountChangeEvent event = new ArrowBodyCountChangeEvent(bukkitEntity, oldAmount, newAmount, isReset);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static EntityExhaustionEvent callPlayerExhaustionEvent(class_1657 humanEntity, EntityExhaustionEvent.ExhaustionReason exhaustionReason, float exhaustion) {
        EntityExhaustionEvent event = new EntityExhaustionEvent(humanEntity.getBukkitEntity(), exhaustionReason, exhaustion);
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static PiglinBarterEvent callPiglinBarterEvent(class_4836 piglin, List<class_1799> outcome, class_1799 input) {
        PiglinBarterEvent event = new PiglinBarterEvent((Piglin)((Object)piglin.getBukkitEntity()), CraftItemStack.asBukkitCopy(input), outcome.stream().map(CraftItemStack::asBukkitCopy).collect(Collectors.toList()));
        Bukkit.getPluginManager().callEvent(event);
        return event;
    }

    public static void callEntitiesLoadEvent(class_1937 world, class_1923 coords, List<class_1297> entities) {
        List<Entity> bukkitEntities = Collections.unmodifiableList(entities.stream().map(InjectionEntity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesLoadEvent event = new EntitiesLoadEvent(new CraftChunk((class_3218)world, coords.field_9181, coords.field_9180), bukkitEntities);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static void callEntitiesUnloadEvent(class_1937 world, class_1923 coords, List<class_1297> entities) {
        List<Entity> bukkitEntities = Collections.unmodifiableList(entities.stream().map(InjectionEntity::getBukkitEntity).collect(Collectors.toList()));
        EntitiesUnloadEvent event = new EntitiesUnloadEvent(new CraftChunk((class_3218)world, coords.field_9181, coords.field_9180), bukkitEntities);
        Bukkit.getPluginManager().callEvent(event);
    }

    public static SpawnerSpawnEvent callSpawnerSpawnEvent(class_1297 spawnee, class_2338 pos) {
        CraftEntity entity = spawnee.getBukkitEntity();
        BlockState state = entity.getWorld().getBlockAt(pos.method_10263(), pos.method_10264(), pos.method_10260()).getState();
        if (!(state instanceof CreatureSpawner)) {
            state = null;
        }
        SpawnerSpawnEvent event = new SpawnerSpawnEvent(entity, (CreatureSpawner)state);
        entity.getServer().getPluginManager().callEvent(event);
        return event;
    }

    public static boolean callTNTPrimeEvent(class_1937 world, class_2338 pos, TNTPrimeEvent.PrimeCause cause, class_1297 causingEntity, class_2338 causePosition) {
        CraftEntity bukkitEntity = causingEntity == null ? null : causingEntity.getBukkitEntity();
        CraftBlock bukkitBlock = causePosition == null ? null : CraftBlock.at((class_1936)world, causePosition);
        TNTPrimeEvent event = new TNTPrimeEvent(CraftBlock.at((class_1936)world, pos), cause, bukkitEntity, bukkitBlock);
        Bukkit.getPluginManager().callEvent(event);
        return !event.isCancelled();
    }

    static {
        sourceBlockOverride = null;
        ZERO = Functions.constant((Object)-0.0);
    }
}

