/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.bukkit.nms.remappers;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.InheritanceProvider;

public class BannerInheritanceMap
extends InheritanceMap {
    protected final List<String> emptyList = new ImmutableList.Builder().build();
    protected final Map<String, List<String>> _inheritanceMap = new HashMap<String, List<String>>();

    public void generate(InheritanceProvider inheritanceProvider, Collection<String> classes) {
        for (String className : classes) {
            Collection parents = inheritanceProvider.getParents(className);
            if (parents == null) {
                System.out.println("No inheritance information found for " + className);
                continue;
            }
            ArrayList<String> filteredParents = new ArrayList<String>();
            for (String parent : parents) {
                if (!classes.contains(parent)) continue;
                filteredParents.add(parent);
            }
            if (filteredParents.isEmpty()) continue;
            this.setParents(className, filteredParents);
        }
    }

    public void save(PrintWriter writer) {
        ArrayList<String> classes = new ArrayList<String>(this._inheritanceMap.keySet());
        Collections.sort(classes);
        for (String className : classes) {
            writer.print(className);
            writer.print(' ');
            Collection parents = this.getParents(className);
            writer.println(Joiner.on((char)' ').join((Iterable)parents));
        }
    }

    public void load(BufferedReader reader, BiMap<String, String> classMap) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(" ");
            if (tokens.length < 2) {
                throw new IOException("Invalid inheritance map file line: " + line);
            }
            String className = tokens[0];
            List<String> parents = Arrays.asList(tokens).subList(1, tokens.length);
            if (classMap == null) {
                this.setParents(className, new ArrayList<String>(parents));
                continue;
            }
            String remappedClassName = JarRemapper.mapTypeName((String)className, null, classMap, null);
            if (remappedClassName == null) {
                throw new IOException("Inheritance map input class not remapped: " + className);
            }
            ArrayList<String> remappedParents = new ArrayList<String>();
            for (String parent : parents) {
                String remappedParent = JarRemapper.mapTypeName((String)parent, null, classMap, null);
                if (remappedParent == null) {
                    throw new IOException("Inheritance map parent class not remapped: " + parent);
                }
                remappedParents.add(remappedParent);
            }
            this.setParents(remappedClassName, remappedParents);
        }
    }

    public boolean hasParents(String className) {
        return this._inheritanceMap.containsKey(className);
    }

    public List<String> getParents(String className) {
        return this._inheritanceMap.get(className);
    }

    public void setParents(String className, Collection<String> parents) {
        if (parents == null || parents.isEmpty()) {
            this._inheritanceMap.put(className, this.emptyList);
        } else {
            this._inheritanceMap.put(className, (List<String>)new ImmutableList.Builder().addAll(parents).build());
        }
    }

    public int size() {
        return this._inheritanceMap.size();
    }
}

