/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.mappings;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mohistmc.banner.BannerMCStart;
import com.mohistmc.banner.stackdeobf.mappings.MappingCacheVisitor;
import com.mohistmc.banner.stackdeobf.mappings.providers.AbstractMappingProvider;
import com.mohistmc.banner.stackdeobf.util.CompatUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;

public final class CachedMappings {
    private static final Int2ObjectMap<String> CLASSES = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private static final Int2ObjectMap<String> METHODS = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private static final Int2ObjectMap<String> FIELDS = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());

    private CachedMappings() {
    }

    public static void init(AbstractMappingProvider provider) {
        CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.creating"));
        ExecutorService cacheExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Mappings Cache Thread").setDaemon(true).build());
        long start = System.currentTimeMillis();
        ((CompletableFuture)provider.cacheMappings(new MappingCacheVisitor((Map<Integer, String>)CLASSES, (Map<Integer, String>)METHODS, (Map<Integer, String>)FIELDS), cacheExecutor).thenAccept($ -> {
            long timeDiff = System.currentTimeMillis() - start;
            CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.cached.mappings"), (Object)timeDiff);
            CompatUtil.LOGGER.info(" " + BannerMCStart.I18N.get("stackdeobf.classes") + " " + CLASSES.size());
            CompatUtil.LOGGER.info(" " + BannerMCStart.I18N.get("stackdeobf.methods") + " " + METHODS.size());
            CompatUtil.LOGGER.info(" " + BannerMCStart.I18N.get("stackdeobf.fields") + " " + FIELDS.size());
        })).thenRunAsync(() -> {
            CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.shutting.down"));
            CompatUtil.LOGGER.info(BannerMCStart.I18N.get("load.libraries"));
            cacheExecutor.shutdown();
        });
    }

    @Nullable
    public static String remapClass(int id) {
        return (String)CLASSES.get(id);
    }

    @Nullable
    public static String remapMethod(int id) {
        return (String)METHODS.get(id);
    }

    @Nullable
    public static String remapField(int id) {
        return (String)FIELDS.get(id);
    }
}

