/*
 * Decompiled with CFR 0.152.
 */
package com.mohistmc.banner.stackdeobf.mappings.providers;

import com.mohistmc.banner.BannerMCStart;
import com.mohistmc.banner.stackdeobf.http.HttpUtil;
import com.mohistmc.banner.stackdeobf.mappings.providers.AbstractMappingProvider;
import com.mohistmc.banner.stackdeobf.util.CompatUtil;
import com.mohistmc.banner.stackdeobf.util.MavenArtifactInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.MappingFormat;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BuildBasedMappingProvider
extends AbstractMappingProvider {
    protected final MavenArtifactInfo artifactInfo;
    protected Path path;
    protected MemoryMappingTree mappings;

    public BuildBasedMappingProvider(String name, MavenArtifactInfo artifactInfo) {
        super(name);
        this.artifactInfo = artifactInfo;
    }

    @Override
    protected CompletableFuture<Void> downloadMappings0(Path cacheDir, Executor executor) {
        String version = CompatUtil.WORLD_VERSION >= 1963 ? CompatUtil.VERSION_ID : CompatUtil.VERSION_NAME;
        version = StringUtils.split((String)version, (char)' ')[0];
        return this.fetchLatestVersion(cacheDir, version, executor).thenCompose(build -> {
            this.path = cacheDir.resolve(this.name + "_" + build + ".gz");
            if (Files.exists(this.path, new LinkOption[0])) {
                CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.download.already"), (Object)this.name, build);
                return CompletableFuture.completedFuture(null);
            }
            URI uri = this.artifactInfo.buildUri((String)build, "jar");
            CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.downloading"), (Object)this.name, build);
            return HttpUtil.getAsync(uri, executor).thenAccept(mappingJarBytes -> {
                byte[] mappingBytes = this.extractPackagedMappings((byte[])mappingJarBytes);
                try (OutputStream fileOutput = Files.newOutputStream(this.path, new OpenOption[0]);
                     GZIPOutputStream gzipOutput = new GZIPOutputStream(fileOutput);){
                    gzipOutput.write(mappingBytes);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        });
    }

    private CompletableFuture<String> fetchLatestVersion(Path cacheDir, String mcVersion, Executor executor) {
        return CompletableFuture.completedFuture(null).thenComposeAsync($ -> {
            Path versionCachePath = cacheDir.resolve(this.name + "_" + mcVersion + "_latest.txt");
            if (Files.exists(versionCachePath, new LinkOption[0])) {
                try {
                    long lastVersionFetch = Files.getLastModifiedTime(versionCachePath, new LinkOption[0]).toMillis();
                    long timeDiff = (System.currentTimeMillis() - lastVersionFetch) / 1000L / 60L;
                    long maxTimeDiff = Long.getLong("stackdeobf.build-refresh-cooldown", 2880L);
                    if (timeDiff <= maxTimeDiff) {
                        CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.getbuild"), (Object)this.name, (Object)((long)Math.floor((double)timeDiff / 60.0)), (Object)((long)Math.ceil((double)(maxTimeDiff - timeDiff) / 60.0)));
                        return CompletableFuture.completedFuture(Files.readString(versionCachePath).trim());
                    }
                    CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.refreshing"), (Object)this.name, (Object)((long)Math.ceil((double)timeDiff / 60.0)));
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            }
            URI metaUri = this.artifactInfo.buildMetaUri();
            CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.fetching"), (Object)this.name);
            return HttpUtil.getAsync(metaUri, executor).thenApply(resp -> {
                try (ByteArrayInputStream input = new ByteArrayInputStream((byte[])resp);){
                    Document document;
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        document = factory.newDocumentBuilder().parse(input);
                    }
                    catch (ParserConfigurationException | SAXException exception) {
                        throw new IOException(exception);
                    }
                    NodeList versions = document.getElementsByTagName("version");
                    int i = versions.getLength() - 1;
                    while (i >= 0) {
                        String version = versions.item(i).getTextContent();
                        if (version.startsWith(mcVersion + "+") || version.startsWith(mcVersion + ".") && version.substring((mcVersion + ".").length()).indexOf(46) == -1) {
                            Files.writeString(versionCachePath, (CharSequence)version, new OpenOption[0]);
                            CompatUtil.LOGGER.info(BannerMCStart.I18N.get("stackdeobf.cached.lastest"), (Object)this.name, (Object)version);
                            String string = version;
                            return string;
                        }
                        --i;
                    }
                    throw new IllegalArgumentException(BannerMCStart.I18N.get("stackdeobf.cantfind") + " " + this.name + " " + BannerMCStart.I18N.get("stackdeobf.mappings.version") + " " + mcVersion);
                }
                catch (IOException exception) {
                    throw new RuntimeException(BannerMCStart.I18N.get("stackdeobf.cantparse") + " " + metaUri + " " + BannerMCStart.I18N.get("stackdeobf.for") + " " + mcVersion, exception);
                }
            });
        }, executor);
    }

    @Override
    protected CompletableFuture<Void> parseMappings0(Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            MemoryMappingTree mappings = new MemoryMappingTree();
            try (InputStream fileInput = Files.newInputStream(this.path, new OpenOption[0]);
                 GZIPInputStream gzipInput = new GZIPInputStream(fileInput);
                 InputStreamReader reader = new InputStreamReader(gzipInput);){
                MappingReader.read((Reader)reader, (MappingFormat)MappingFormat.TINY_2, (MappingVisitor)mappings);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            this.mappings = mappings;
            return null;
        }, executor);
    }

    @Override
    protected CompletableFuture<Void> visitMappings0(MappingVisitor visitor, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.mappings.accept(visitor);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            return null;
        }, executor);
    }
}

